/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.draganddrop;

import com.rapidminer.Process;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonScriptingOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.file.LoadFileOperator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.OperatorService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class PythonOperatorFactory {
    private static final PythonOperatorFactory INSTANCE = new PythonOperatorFactory();

    public static PythonOperatorFactory getInstance() {
        return INSTANCE;
    }

    public PythonScriptingOperator create(Path filePath) throws OperatorCreationException {
        PythonScriptingOperator operator = (PythonScriptingOperator)OperatorService.createOperator(PythonScriptingOperator.class);
        operator.markAsNewlyCreatedFromFile(filePath);
        try {
            operator.setParameterScriptFile(filePath);
        }
        catch (OperatorException e) {
            throw new OperatorCreationException(0, operator.getOperatorClassName(), (Throwable)e);
        }
        return operator;
    }

    public List<Operator> create(BinaryEntry binaryEntry, Process process) throws OperatorCreationException {
        Path filePath;
        ArrayList<Operator> operators = new ArrayList<Operator>();
        RepositoryLocation entryLocation = binaryEntry.getLocation();
        String resolvedLocation = process.getRepositoryLocation() != null ? entryLocation.makeRelative(process.getRepositoryLocation().parent()) : entryLocation.getAbsoluteLocation();
        LoadFileOperator source = (LoadFileOperator)OperatorService.createOperator(LoadFileOperator.class);
        source.setParameter("repository_entry", resolvedLocation);
        source.setParameter("resource_type", String.valueOf(2));
        operators.add((Operator)source);
        try {
            filePath = binaryEntry.toPath();
        }
        catch (IOException e) {
            throw new OperatorCreationException(0, PythonScriptingOperator.class.getCanonicalName(), (Throwable)e);
        }
        PythonScriptingOperator pythonOp = this.create(filePath);
        operators.add(pythonOp);
        ((OutputPort)source.getOutputPorts().getPortByIndex(0)).connectTo((InputPort)pythonOp.getInputPorts().getPortByIndex(0));
        return operators;
    }
}

