/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.properties.celleditors.value;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.rapidminer.extension.pythonscripting.definition.ConfigurationTools;
import com.rapidminer.extension.pythonscripting.definition.InvalidDeclarationException;
import com.rapidminer.extension.pythonscripting.definition.OperatorConfiguration;
import com.rapidminer.extension.pythonscripting.gui.dialog.CodeEditor;
import com.rapidminer.extension.pythonscripting.gui.draganddrop.PythonOperatorCallback;
import com.rapidminer.extension.pythonscripting.parameter.ParameterTypeOperator;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import com.rapidminer.repository.versioned.BasicBinaryEntry;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.container.Pair;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;

public class OperatorCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private final JPanel panel;
    private final JButton editDefinitionButton;
    private final transient ParameterTypeOperator type;
    private String definition = null;
    private String declaration = null;
    private transient Operator operator = null;

    public OperatorCellEditor(ParameterTypeOperator type) {
        this.type = type;
        this.panel = new JPanel();
        this.editDefinitionButton = new JButton((Action)((Object)new SimpleAction("python_scripting.edit_operator_definition", this::showDeclarationEditor)));
        JButton editScriptButton = new JButton((Action)((Object)new SimpleAction("python_scripting.edit_python_script", this::showScriptEditor)));
        JButton saveButton = new JButton((Action)((Object)new SimpleAction("python_scripting.save_python_operator", this::saveOperator)));
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = 0;
        this.panel.add((Component)this.editDefinitionButton, c);
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        ++c.gridx;
        this.panel.add((Component)editScriptButton, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.panel.add((Component)saveButton, c);
    }

    private void showDeclarationEditor() {
        String operatorType = this.type.getOperatorType();
        String key = "python_scripting." + operatorType + ".edit_operator_definition";
        CodeEditor dialog = new CodeEditor(key, this.definition, "text/json", json -> {
            try {
                Set<String> staticParameters = PythonOperatorCallback.PARAMETER_MAP.get(operatorType);
                Set<String> staticInputs = PythonOperatorCallback.STATIC_INPUT_MAP.get(operatorType);
                Set<String> staticOutputs = PythonOperatorCallback.STATIC_OUTPUT_MAP.get(operatorType);
                ConfigurationTools.readAndValidateOperatorDeclaration(json, staticParameters, staticInputs, staticOutputs);
                return null;
            }
            catch (InvalidDeclarationException e) {
                return I18N.getGUIMessage((String)"gui.python_scripting.declaration.invalid_structure", (Object[])new Object[]{e.getMessage()});
            }
            catch (JsonProcessingException e) {
                JsonLocation location = e.getLocation();
                if (location == null) {
                    return I18N.getGUIMessage((String)"gui.python_scripting.declaration.generic_parsing_error", (Object[])new Object[0]);
                }
                return I18N.getGUIMessage((String)"gui.python_scripting.declaration.localized_parsing_error", (Object[])new Object[]{location.getLineNr(), location.getColumnNr()});
            }
            catch (Exception e) {
                return I18N.getGUIMessage((String)"gui.python_scripting.declaration.generic_parsing_error", (Object[])new Object[0]);
            }
        });
        dialog.setVisible(true);
        if (dialog.wasConfirmed()) {
            this.definition = dialog.getCode();
            this.fireEditingStopped();
        } else {
            this.fireEditingCanceled();
        }
    }

    private void showScriptEditor() {
        String key = "python_scripting." + this.type.getOperatorType() + ".edit_python_script";
        CodeEditor dialog = new CodeEditor(key, this.declaration, "text/python", null);
        dialog.setVisible(true);
        if (dialog.wasConfirmed()) {
            this.declaration = dialog.getCode();
            this.fireEditingStopped();
        } else {
            this.fireEditingCanceled();
        }
    }

    private void saveOperator() {
        Object locationName = RepositoryLocationChooser.selectLocation(null, (String)"My Operator", (Component)this.panel, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
        if (locationName != null) {
            String suffix = ".pyop";
            if (!((String)locationName).endsWith(suffix)) {
                locationName = (String)locationName + suffix;
            }
            try {
                String parameter = this.operator.getParameter(this.type.getKey());
                Pair<String, String> pair = ParameterTypeOperator.decode(parameter);
                OperatorConfiguration config = new OperatorConfiguration();
                config.setType(this.type.getOperatorType());
                config.setDeclaration(ConfigurationTools.readAndValidateOperatorDeclaration((String)pair.getFirst(), PythonOperatorCallback.PARAMETER_MAP.get(this.type.getOperatorType()), PythonOperatorCallback.STATIC_INPUT_MAP.get(this.type.getOperatorType()), PythonOperatorCallback.STATIC_OUTPUT_MAP.get(this.type.getOperatorType())));
                config.setDefinition((String)pair.getSecond());
                RepositoryLocation location = RepositoryLocation.getRepositoryLocationData((String)locationName, (Operator)this.operator, BasicBinaryEntry.class);
                BinaryEntry entry = RepositoryManager.getInstance(null).getOrCreateBinaryEntry(location);
                try (OutputStream out = entry.openOutputStream();){
                    ConfigurationTools.writeOperatorConfiguration(out, config);
                }
            }
            catch (UserError | RepositoryException | IOException e) {
                SwingTools.showSimpleErrorMessage((String)"python_scripting.save_conf_failed", (Throwable)e, (Object[])new Object[0]);
                LogService.getRoot().log(Level.SEVERE, "Failed to save operator configuration.", e);
            }
        }
        this.fireEditingStopped();
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    public Object getCellEditorValue() {
        return ParameterTypeOperator.encode(this.definition, this.declaration);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        Pair<String, String> pair = ParameterTypeOperator.decode((String)value);
        this.definition = (String)pair.getFirst();
        this.declaration = (String)pair.getSecond();
        return this.panel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }

    public boolean rendersLabel() {
        return false;
    }

    public void activate() {
        this.editDefinitionButton.doClick();
    }

    private static class SimpleAction
    extends ResourceAction {
        private final transient Runnable action;

        public SimpleAction(String i18nKey, Runnable action) {
            super(true, i18nKey, new Object[0]);
            this.action = action;
        }

        public void actionPerformed(ActionEvent e) {
            this.action.run();
        }
    }
}

