/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.properties.celleditors.value;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PythonBinaryComparator
implements Comparator<String> {
    private static Pattern patternPythonBinary = Pattern.compile(String.format("\\%spython[^\\%s]*$", File.separator, File.separator));

    private int compareBasedOnVersion(String fullName1, String fileName1, String fullName2, String fileName2) {
        Version version1 = new Version(fileName1);
        Version version2 = new Version(fileName2);
        if (version1.major == version2.major) {
            if (version1.minor == version2.minor) {
                if (version1.suffix.length() - version2.suffix.length() != 0) {
                    return version1.suffix.length() - version2.suffix.length();
                }
                if (version1.isExeExtension && !version2.isExeExtension) {
                    return 1;
                }
                if (version2.isExeExtension && !version1.isExeExtension) {
                    return -1;
                }
                return fullName1.compareTo(fullName2);
            }
            if (version1.minor < version2.minor) {
                return 1;
            }
            return -1;
        }
        if (version1.major < version2.major) {
            return 1;
        }
        return -1;
    }

    @Override
    public int compare(String o1, String o2) {
        String name2;
        if (o1.equals(o2)) {
            return 0;
        }
        String name1 = Paths.get(o1, new String[0]).getFileName().toString();
        if (name1.equals(name2 = Paths.get(o2, new String[0]).getFileName().toString())) {
            return o1.compareTo(o2);
        }
        Matcher matcherPythonBinary1 = patternPythonBinary.matcher(o1);
        Matcher matcherPythonBinary2 = patternPythonBinary.matcher(o2);
        if (!matcherPythonBinary1.find()) {
            if (!matcherPythonBinary2.find()) {
                return name1.compareTo(name2);
            }
            return 1;
        }
        if (!matcherPythonBinary2.find()) {
            return -1;
        }
        return this.compareBasedOnVersion(o1, name1, o2, name2);
    }

    public static List<String> sortByDirectory(List<String> list) {
        ArrayList<String> result = new ArrayList<String>(list.size());
        HashSet<String> visitedDirectories = new HashSet<String>();
        for (String s : list) {
            String parent = Paths.get(s, new String[0]).getParent().toString();
            if (visitedDirectories.contains(parent)) continue;
            for (String ss : list) {
                String pp = Paths.get(ss, new String[0]).getParent().toString();
                if (!parent.equals(pp)) continue;
                result.add(ss);
                visitedDirectories.add(pp);
            }
        }
        return result;
    }

    private static class Version {
        private static Pattern patternMajorVersion = Pattern.compile(String.format("python(?<major>[0-9])[^\\%s]*$", File.separator));
        private static Pattern patternMajorMinorVersion = Pattern.compile(String.format("python(?<major>[0-9])\\.?(?<minor>[0-9])[^\\%s]*$", File.separator));
        private static Pattern patternSuffix = Pattern.compile(String.format("python[0-9]{0,2}(?<suffix>[a-z])[^\\%s]*$", File.separator));
        private static Pattern patternExeSuffix = Pattern.compile(String.format("python[0-9]{0,2}[^\\%s]*\\.exe$", File.separator));
        private final int major;
        private final int minor;
        private final String suffix;
        private final boolean isExeExtension;

        public Version(String fileName) {
            Matcher matcherMajorMinor = patternMajorMinorVersion.matcher(fileName);
            if (matcherMajorMinor.find()) {
                this.major = Integer.parseInt(matcherMajorMinor.group("major"));
                this.minor = Integer.parseInt(matcherMajorMinor.group("minor"));
            } else {
                Matcher matcherMajor = patternMajorVersion.matcher(fileName);
                this.major = matcherMajor.find() ? Integer.parseInt(matcherMajor.group("major")) : Integer.MAX_VALUE;
                this.minor = Integer.MAX_VALUE;
            }
            Matcher matcherSuffix = patternSuffix.matcher(fileName);
            this.suffix = matcherSuffix.find() ? matcherSuffix.group("suffix") : "";
            this.isExeExtension = patternExeSuffix.matcher(fileName).find();
        }
    }
}

