/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.gui.properties.celleditors.value;

import com.rapidminer.RapidMiner;
import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.parameter.ParameterTypeScriptingEnvironment;
import com.rapidminer.extension.pythonscripting.parameter.PythonEnvironmentSetupTestingResult;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.properties.celleditors.value.AbstractSuggestionBoxValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.SimpleSuggestionBoxValueCellEditor;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;

public class PythonEnvironmentCellEditor
extends SimpleSuggestionBoxValueCellEditor {
    private static final int SHOW_DIALOG_TIMER_DELAY = 2000;
    private static final int INSTALLED_MODULES_PANE_WIDTH = 300;
    private static final int INSTALLED_MODULES_PANE_HEIGHT = 200;
    private final ParameterTypeScriptingEnvironment type;

    public PythonEnvironmentCellEditor(ParameterTypeScriptingEnvironment type) {
        super((ParameterTypeSuggestion)type);
        ResourceAction refreshAction;
        if (RapidMiner.isInitialized()) {
            PluginInitPythonScripting.initPluginForFirstTime();
        }
        this.type = type;
        if (type.areFilePathsProvided()) {
            this.addConfigureButton(new JButton((Action)this.createFileChooserAction()));
        }
        if (type.getTestAction() != null) {
            this.addConfigureButton(new JButton((Action)this.createTestAction()));
        }
        if ((refreshAction = type.getRefreshAction()) != null) {
            this.addConfigureButton(new JButton((Action)refreshAction));
        }
    }

    protected ResourceAction createFileChooserAction() {
        return new ResourceAction(true, "choose_file", new Object[0]){

            public void loggedActionPerformed(ActionEvent e) {
                String value = (String)PythonEnvironmentCellEditor.this.getCellEditorValue();
                File file = value == null || value.length() == 0 ? null : RapidMinerGUI.getMainFrame().getProcess().resolveFileName(value);
                File selectedFile = SwingTools.chooseFile((Component)ApplicationFrame.getApplicationFrame(), (File)file, (boolean)true, null, null);
                if (selectedFile != null) {
                    AbstractSuggestionBoxValueCellEditor.SuggestionComboBox suggestionComboBox = PythonEnvironmentCellEditor.this.getSuggestionComboBox();
                    suggestionComboBox.setSelectedItem(selectedFile.toPath().toAbsolutePath().toString());
                    PythonEnvironmentCellEditor.this.fireEditingStopped();
                } else {
                    PythonEnvironmentCellEditor.this.fireEditingCanceled();
                }
            }
        };
    }

    protected ResourceAction createTestAction() {
        ResourceAction action = this.type.getTestAction();
        return new ResourceAction(action.getKey(), new Object[0]){

            protected void loggedActionPerformed(ActionEvent e) {
                ActionEvent event = new ActionEvent(e.getSource(), e.getID(), PythonEnvironmentCellEditor.this.getSelectedEnvironment(), e.getWhen(), e.getModifiers());
                TestActionThread refreshThread = new TestActionThread("python_test_thread", event);
                refreshThread.setCancelable(false);
                refreshThread.setShowDialogTimerDelay(2000L);
                refreshThread.setStartDialogShowTimer(true);
                refreshThread.setIndeterminate(true);
                refreshThread.start();
            }
        };
    }

    public List<Object> getSuggestions(Operator operator, ProgressListener progressListener) {
        return ((ParameterTypeSuggestion)this.getParameterType()).getSuggestionProvider().getSuggestions(operator, progressListener);
    }

    public String getSelectedEnvironment() {
        return (String)this.getCellEditorValue();
    }

    private final class TestActionThread
    extends ProgressThread {
        private ActionEvent event;

        private TestActionThread(String i18nKey, ActionEvent event) {
            super(i18nKey);
            this.event = event;
        }

        private JComponent createGUIForInstalledModulesList(String installedModulesHTML) {
            JEditorPane installedModulesList = new JEditorPane();
            installedModulesList.setContentType("text/html");
            installedModulesList.setEditable(false);
            installedModulesList.setText(installedModulesHTML);
            ExtendedJScrollPane scrollPane = new ExtendedJScrollPane((Component)installedModulesList);
            scrollPane.setPreferredSize(new Dimension(300, 200));
            return scrollPane;
        }

        public void run() {
            try {
                PythonEnvironmentCellEditor.this.type.getTestAction().actionPerformed(this.event);
            }
            catch (PythonEnvironmentSetupTestingResult testingAction) {
                String message;
                String i18nKey;
                if (testingAction.succeeded()) {
                    i18nKey = "python_scripting.test.success";
                    message = I18N.getGUIMessage((String)"gui.label.python_scripting.testing.success", (Object[])new Object[]{testingAction.getMessage()});
                } else {
                    i18nKey = "python_scripting.test.failure";
                    message = testingAction.getMessage();
                }
                SwingUtilities.invokeLater(() -> {
                    String msg = message;
                    JComponent guiList = null;
                    if (testingAction.getInstalledModules() != null && testingAction.getInstalledModules().length() > 0) {
                        guiList = this.createGUIForInstalledModulesList(testingAction.getInstalledModules());
                        msg = message.replaceAll("</html>", "<br><br>" + I18N.getGUIMessage((String)"gui.label.python_scripting.testing.installed_modules", (Object[])new Object[0]) + "</html>");
                    }
                    SwingTools.showMessageDialog((String)i18nKey, (JComponent)guiList, (Object[])new Object[]{msg});
                });
            }
            catch (Exception error) {
                LogService.getRoot().warning("An error occured during testing python: " + error.getMessage());
            }
        }
    }
}

