/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.launcher;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.launcher.CommandType;
import com.rapidminer.extension.pythonscripting.launcher.LauncherTools;
import com.rapidminer.extension.pythonscripting.launcher.ProcessExecutor;
import com.rapidminer.extension.pythonscripting.launcher.VersionMismatchException;
import com.rapidminer.extension.pythonscripting.serialization.SerializationService;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.launcher.CustomCommandLineLauncher;
import com.rapidminer.license.verification.JarVerifier;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.container.Pair;
import com.rapidminer.tools.usagestats.ActionStatisticsCollector;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class ExtendedCmdLauncher
extends RapidMiner
implements CustomCommandLineLauncher,
BreakpointListener {
    private static final int NORMAL_EXIT = 0;
    private static final int UNCATEGORIZED_ERROR = 1;
    private static final int LIBRARY_VERSION_MISMATCH = 2;
    private static final String RAPIDMINER_VERSION_MSG = "RAPIDMINER_VERSION=";
    private static final String EXIT_CODE_MSG = "EXIT_CODE=";
    private static final String RAPIDMINER_ERROR_MSG_FIRST_LINE = "RAPIDMINER_ERROR_MSG_FIRST_LINE=";
    private static final String RAPIDMINER_ERROR_MSG = "RAPIDMINER_ERROR_MSG=";
    private String repositoryLocation = null;
    private final List<Pair<String, String>> macros = new ArrayList<Pair<String, String>>();
    private final List<String> inputs = new ArrayList<String>();
    private final List<String> outputs = new ArrayList<String>();
    private final List<String> operators = new ArrayList<String>();
    private String outputDirectory = null;
    private CommandType commandType = null;
    private int resultSize = 0;
    private VersionNumber pythonLibVersion = null;

    public void breakpointReached(Process process, Operator operator, IOContainer container, int location) {
        System.out.println("Results in application " + operator.getApplyCount() + " of " + operator.getName() + ":" + Tools.getLineSeparator() + container);
        System.out.println("Breakpoint reached " + (location == 0 ? "before " : "after ") + operator.getName() + ", press enter...");
        new WaitForKeyThread(process).start();
    }

    public void resume() {
    }

    private void parseArguments(String[] argv) {
        this.repositoryLocation = null;
        for (String encoded : argv) {
            String element = LauncherTools.decodeArgument(encoded);
            if (element == null) continue;
            if (!element.startsWith("-") || element.length() < 2) {
                throw new IllegalArgumentException("Illegal command line argument specified: " + element);
            }
            String prefix = element.substring(1, 2);
            Object value = element.substring(2);
            if ("P".equals(prefix)) {
                if (this.repositoryLocation != null) {
                    throw new IllegalArgumentException("Only one process can be specified (multiple -P option is present).");
                }
                this.repositoryLocation = value;
                continue;
            }
            if ("M".equals(prefix)) {
                String[] split = ((String)value).split("=", 2);
                String macroValue = split.length == 2 ? split[1] : "";
                this.macros.add((Pair<String, String>)new Pair((Object)split[0], (Object)macroValue));
                continue;
            }
            if ("I".equals(prefix)) {
                this.inputs.add((String)value);
                continue;
            }
            if ("O".equals(prefix)) {
                this.outputs.add((String)value);
                continue;
            }
            if ("N".equals(prefix)) {
                this.operators.add((String)value);
                continue;
            }
            if ("D".equals(prefix)) {
                if (this.outputDirectory != null) {
                    throw new IllegalArgumentException("Only one output directory can be specified (multiple -D option is present).");
                }
                if (((String)value).charAt(((String)value).length() - 1) != File.separatorChar) {
                    value = (String)value + File.separatorChar;
                }
                this.outputDirectory = value;
                continue;
            }
            if ("T".equals(prefix)) {
                SerializationService.getInstance().setTempDir(Paths.get((String)value, new String[0]));
                continue;
            }
            if ("B".equals(prefix)) {
                PluginInitPythonScripting.setTemporaryDefaultPythonBinary(Paths.get((String)value, new String[0]));
                continue;
            }
            if ("A".equals(prefix)) {
                if (this.commandType != null) {
                    throw new IllegalArgumentException("CommandType can be specified once (multiple -C option is present).");
                }
                this.commandType = CommandType.valueOf((String)value);
                continue;
            }
            if (!"V".equals(prefix)) continue;
            this.pythonLibVersion = new VersionNumber((String)value);
        }
        if (this.repositoryLocation == null) {
            if (this.inputs.isEmpty() || this.outputs.isEmpty()) {
                throw new IllegalArgumentException("No process or input-output pair is specified .");
            }
            if (this.inputs.size() != this.outputs.size()) {
                throw new IllegalArgumentException("If no process is specified, the number of inputs and outputs should be equal.");
            }
        }
        if (this.operators.size() > 1) {
            throw new IllegalArgumentException("Currently only one operator can be specified.");
        }
        if (!this.outputs.isEmpty() && this.outputDirectory != null) {
            throw new IllegalArgumentException("Either specify all output file with the -O options or the output directory with the -D option.");
        }
        if (this.repositoryLocation == null && this.outputDirectory != null) {
            throw new IllegalArgumentException("-D option is not valid, when no process is specified.");
        }
        if (this.commandType == null) {
            throw new IllegalArgumentException("-A option is not specified.");
        }
        if (this.pythonLibVersion == null || !this.pythonLibVersion.isAtLeast(new VersionNumber("9.5.0"))) {
            throw new VersionMismatchException("You are using an older version of the 'rapidminer' Python library. Upgrade it to 9.5.0 or newer using the following command: 'pip install --upgrade git+https://github.com/rapidminer/python-rapidminer.git'");
        }
    }

    private void printUsage() {
        System.out.println("SEVERE: Usage: " + ExtendedCmdLauncher.class.getName() + " [-Pprocess] [-Noperator] [-Iinput=value] [-Ooutput=value] [-Ddirectory] [-Mname=value] [-Ttempdir] [-Bbinary] [-Acommand]\nSEVERE:  -Pprocess     a repository/file location containing a process, if no process specified, the inputs will be converted and saved to the output locations. If param contains file extension, it wiil be treated as a file, if not a repository location.\nSEVERE:  -Noperator    executes the operator with the given name\nSEVERE:  -Iinput       reads the file/repository (repository: supports only IOObjects right now) location as input, the order of these options are important (if no extension is provided, the program will read the repository, if the extension is provided it will assume a regular local file system file)\nSEVERE:  -Ooutput      writes the result of the execution to the given file/repository, the order of these options are important (if no extension is provided, the program will read the repository, if the extension is provided it will assume a regular local file system file)\nSEVERE:  -Ddirectory   the output directory, in which output will be saved with names 'output1.json', 'output2.json', etc. Existing files will be overriden. If output files are specified, then this param will be not used.\nSEVERE:  -Mname=value  sets the macro 'name' with the value 'value'\nSEVERE:  -Ttempdir     temporary directory, to be deleted by the caller of the CmdLauncher'\nSEVERE:  -Bbinary      path to a python binary to be used by default by 'Execute Python'\nSEVERE:  -Acommand     command from the caller side, either 'read_resource', 'write_resource' or 'run_process'\nSEVERE:  -Vversion     version of the caller Python library");
    }

    private int getRealResultSize(IOContainer results) {
        if (results.size() == 0) {
            return 0;
        }
        if (results.getElementAt(results.size() - 1) != null) {
            return results.size();
        }
        return results.size() - 1;
    }

    private int getRealResultSizeAndCheckCmdParameters(IOContainer results) {
        int resultSize = this.getRealResultSize(results);
        if (!this.outputs.isEmpty()) {
            if (resultSize < this.outputs.size()) {
                LogService.getRoot().log(Level.WARNING, "Less result is generated (" + resultSize + "), than the number of specified outputs.");
            } else if (resultSize > this.outputs.size()) {
                throw new IllegalArgumentException("More result is generated (" + resultSize + "), than the number of specified outputs. ");
            }
        }
        return resultSize;
    }

    private String getOutput(int index) {
        if (!this.outputs.isEmpty()) {
            return this.outputs.get(index);
        }
        return "file:" + this.outputDirectory + "output" + index;
    }

    private void serializeResults(IOContainer results) throws IOException, RepositoryException, MalformedRepositoryLocationException, ProcessStoppedException, UserError {
        this.resultSize = this.getRealResultSizeAndCheckCmdParameters(results);
        LogService.getRoot().log(Level.FINEST, "Serializing " + this.resultSize + " IOObject.");
        for (int i = 0; i < this.resultSize; ++i) {
            IOObject result = results.getElementAt(i);
            if (result != null) {
                LogService.getRoot().log(Level.FINEST, "Serializing result to '" + this.getOutput(i) + "'.");
                SerializationService.getInstance().serialize(result, this.getOutput(i), null);
                continue;
            }
            LogService.getRoot().log(Level.FINEST, "No data delivered to output port " + i + ".");
        }
    }

    private Process loadProcess() throws XMLException, MalformedRepositoryLocationException, IOException {
        Process process = SerializationService.getInstance().loadProcess(this.repositoryLocation);
        for (Pair<String, String> macro : this.macros) {
            process.getContext().addMacro(macro);
        }
        process.addBreakpointListener((BreakpointListener)this);
        return process;
    }

    private IOContainer loadInputs() throws RepositoryException, IOException, MalformedRepositoryLocationException, ProcessStoppedException, UserError {
        ArrayList<IOObject> inp = new ArrayList<IOObject>();
        for (String file : this.inputs) {
            inp.add(SerializationService.getInstance().deserialize(file, null));
        }
        return new IOContainer(inp);
    }

    private IOContainer execute(Operator operator, IOContainer inputs) throws OperatorException, RepositoryException, IOException {
        ProcessExecutor executor = new ProcessExecutor();
        return executor.run(operator, inputs);
    }

    private Operator getOperatorWithName(Process process, String operatorName) {
        for (Operator op : process.getAllOperators()) {
            if (!operatorName.equals(op.getName())) continue;
            return op;
        }
        throw new IllegalArgumentException("No operator with name '" + operatorName + "' found in the process.");
    }

    private void execute() throws IOException, XMLException, InstantiationException, OperatorException, IllegalAccessException, RepositoryException {
        Object operator = this.operators.isEmpty() ? this.loadProcess().getRootOperator() : this.getOperatorWithName(this.loadProcess(), this.operators.get(0));
        IOContainer results = this.execute((Operator)operator, this.loadInputs());
        this.serializeResults(results);
        LogService.getRoot().log(Level.INFO, "com.rapidminer.RapidMinerCommandLine.process_finished");
    }

    private boolean shouldExecuteProcess() {
        return this.repositoryLocation != null;
    }

    private void convert() throws RepositoryException, IOException, MalformedRepositoryLocationException, ProcessStoppedException, UserError {
        for (int i = 0; i < this.inputs.size() && i < this.outputs.size(); ++i) {
            String in = this.inputs.get(i);
            String out = this.outputs.get(i);
            LogService.getRoot().info("Converting '" + in + "' to '" + out + "'...");
            IOObject data = SerializationService.getInstance().deserialize(in, null);
            SerializationService.getInstance().serialize(data, out, null);
            LogService.getRoot().info("Converting '" + in + "' to '" + out + "' was successful.");
        }
    }

    private String getDetailedMessage(Throwable e) {
        if (e instanceof UserError) {
            UserError err = (UserError)e;
            if (err.getOperator() != null) {
                return err.getMessage() + err.getDetails() + "(In operator '" + err.getOperator().getName() + "'.)";
            }
            return err.getMessage() + err.getDetails();
        }
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        return e.toString();
    }

    private void verifyJar() throws GeneralSecurityException {
        try {
            JarVerifier.verify((Class[])new Class[]{RapidMiner.class, ExtendedCmdLauncher.class});
        }
        catch (GeneralSecurityException e) {
            System.out.println("SEVERE: Failed to verify Altair AI Studio installation: " + e.toString());
            throw e;
        }
    }

    private void parseArgumentsAndPrintUsage(String[] argv) {
        try {
            this.parseArguments(argv);
        }
        catch (IllegalArgumentException e) {
            System.out.println("SEVERE: Error while parsing command line arguments: '" + e.toString() + "'");
            this.printUsage();
            throw e;
        }
    }

    private void recordUsage(String exceptionClass) {
        int numOfRepositoryEntries = 0;
        int numOfLocalFiles = 0;
        if (this.commandType == CommandType.RUN_PROCESS) {
            if (this.repositoryLocation.startsWith("repositorylocation:")) {
                numOfRepositoryEntries = 1;
                numOfLocalFiles = 0;
            } else {
                numOfRepositoryEntries = 0;
                numOfLocalFiles = 1;
            }
            ActionStatisticsCollector.getInstance().log("python_rapidminer", this.commandType.toString().toLowerCase(), "repository=" + numOfRepositoryEntries + "|local_file=" + numOfLocalFiles + "|inputs=" + this.inputs.size() + "|outputs=" + this.resultSize + "|macros=" + this.macros.size() + "|operator=" + !this.operators.isEmpty() + "|exception=" + exceptionClass);
        } else {
            if (this.commandType == CommandType.READ_RESOURCE) {
                for (String input : this.inputs) {
                    if (input.startsWith("repositorylocation:")) {
                        ++numOfRepositoryEntries;
                        continue;
                    }
                    ++numOfLocalFiles;
                }
            } else {
                for (String output : this.outputs) {
                    if (output.startsWith("repositorylocation:")) {
                        ++numOfRepositoryEntries;
                        continue;
                    }
                    ++numOfLocalFiles;
                }
            }
            ActionStatisticsCollector.getInstance().log("python_rapidminer", this.commandType.toString().toLowerCase(), "repository=" + numOfRepositoryEntries + "|local_file=" + numOfLocalFiles + "|exception=" + exceptionClass);
        }
    }

    @Override
    public void run(String[] argv) {
        try {
            System.out.println(RAPIDMINER_VERSION_MSG + PluginInitPythonScripting.getVersion());
            this.verifyJar();
            this.parseArgumentsAndPrintUsage(argv);
            if (this.shouldExecuteProcess()) {
                this.execute();
            } else {
                this.convert();
            }
        }
        catch (Throwable e) {
            System.out.println(RAPIDMINER_ERROR_MSG_FIRST_LINE + e.getClass().getCanonicalName() + ": " + this.getDetailedMessage(e));
            e.printStackTrace(new PrintWriter(System.out){

                @Override
                public void println(Object x) {
                    System.out.println(ExtendedCmdLauncher.RAPIDMINER_ERROR_MSG + x);
                }
            });
            System.out.println(EXIT_CODE_MSG + this.getExitCode(e));
            this.recordUsage(e.getClass().getCanonicalName());
            RapidMiner.quit((RapidMiner.ExitMode)RapidMiner.ExitMode.ERROR);
        }
        System.out.println("EXIT_CODE=0");
        this.recordUsage("None");
        RapidMiner.quit((RapidMiner.ExitMode)RapidMiner.ExitMode.NORMAL);
    }

    private int getExitCode(Throwable exception) {
        if (exception instanceof VersionMismatchException) {
            return 2;
        }
        return 1;
    }

    private static class WaitForKeyThread
    extends Thread {
        private final Process process;

        public WaitForKeyThread(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                System.in.read();
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.rapidminer.RapidMinerCommandLine.waiting_for_user_input_error", (Object[])new Object[]{e.getMessage()}), e);
            }
            this.process.resume();
        }
    }
}

