/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.launcher;

import com.rapidminer.Process;
import com.rapidminer.core.license.DatabaseConstraintViolationException;
import com.rapidminer.core.license.LicenseViolationException;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.SystemInfoUtilities;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.usagestats.ActionStatisticsCollector;
import java.io.IOException;
import java.util.logging.Level;

public class ProcessExecutor {
    private static final String LOG_WARNING_FEWER_INPUT_PROCESS = "Process requires more inputs, than provided. This may result in execution failure.";
    private static final String LOG_WARNING_MORE_INPUT_PROCESS = "More inputs were provided, than the number of input port of the process, some inputs will be ignored.";
    private static final String LOG_WARNING_FEWER_INPUT_OPERATOR = "Operator requires more inputs, than provided. This may result in execution failure.";
    private static final String LOG_WARNING_MORE_INPUT_OPERATOR = "More inputs were provided, than the number of input port of the operator, some inputs will be ignored.";

    private IOContainer runRootOperator(Process process, IOContainer inputs) throws OperatorException {
        ExecutionUnit executionUnit = process.getRootOperator().getSubprocess(0);
        int inputPortNumber = executionUnit.getInnerSources().getNumberOfConnectedPorts();
        if (inputs.size() < inputPortNumber) {
            LogService.getRoot().log(Level.WARNING, LOG_WARNING_FEWER_INPUT_PROCESS);
        }
        if (inputs.size() > inputPortNumber) {
            LogService.getRoot().log(Level.WARNING, LOG_WARNING_MORE_INPUT_PROCESS);
        }
        return process.run(inputs);
    }

    private void removeOperatorsFromProcess(Process process, Operator from) {
        OperatorChain currentOperator = from.getParent();
        while (!currentOperator.equals(process.getRootOperator())) {
            for (Operator op : currentOperator.getImmediateChildren()) {
                op.remove();
                LogService.getRoot().log(Level.FINEST, "Removing: " + op.getName() + ".");
            }
            currentOperator = currentOperator.getParent();
        }
        for (Operator op : currentOperator.getImmediateChildren()) {
            op.remove();
            LogService.getRoot().log(Level.FINEST, "Removing: " + op.getName() + ".");
        }
    }

    private void addOperatorToProcess(Process process, Operator operator, IOContainer inputs) {
        process.getRootOperator().getSubprocess(0).addOperator(operator);
        LogService.getRoot().log(Level.FINEST, "Number of input ports is: " + inputs.size() + ".");
        for (int i = 0; i < inputs.size(); ++i) {
            try {
                ((OutputPort)process.getRootOperator().getSubprocess(0).getInnerSources().getPortByIndex(i)).connectTo((InputPort)operator.getInputPorts().getAllPorts().get(i));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                LogService.getRoot().log(Level.WARNING, LOG_WARNING_MORE_INPUT_OPERATOR);
            }
        }
        int outputPortNum = operator.getOutputPorts().getAllPorts().size();
        LogService.getRoot().log(Level.FINEST, "Number of output ports is: " + outputPortNum + ".");
        for (int i = 0; i < outputPortNum; ++i) {
            ((OutputPort)operator.getOutputPorts().getAllPorts().get(i)).connectTo((InputPort)process.getRootOperator().getSubprocess(0).getInnerSinks().getPortByIndex(i));
        }
    }

    private IOContainer runNonRootOperator(Process process, Operator operatorToRun, IOContainer inputs) throws OperatorException {
        this.removeOperatorsFromProcess(process, operatorToRun);
        if (operatorToRun.getInputPorts().getAllPorts().size() - 1 > inputs.size()) {
            LogService.getRoot().log(Level.WARNING, LOG_WARNING_FEWER_INPUT_OPERATOR);
        }
        if (operatorToRun.getInputPorts().getAllPorts().size() < inputs.size()) {
            LogService.getRoot().log(Level.WARNING, LOG_WARNING_MORE_INPUT_OPERATOR);
        }
        this.addOperatorToProcess(process, operatorToRun, inputs);
        return process.run(inputs);
    }

    private IOContainer runOperator(Process process, Operator operator, IOContainer inputs) throws OperatorException {
        if (process.getRootOperator().equals(operator)) {
            return this.runRootOperator(process, inputs);
        }
        return this.runNonRootOperator(process, operator, inputs);
    }

    public IOContainer run(Process process) throws OperatorException, RepositoryException, IOException {
        return this.run(process, null);
    }

    public IOContainer run(Process process, IOContainer inputs) throws OperatorException, RepositoryException, IOException {
        return this.run((Operator)process.getRootOperator(), inputs);
    }

    private IOContainer runAndSendEmail(Operator operator, IOContainer inputs) throws OperatorException {
        Process process = operator.getProcess();
        IOContainer results = this.runOperator(process, operator, inputs);
        process.getRootOperator().sendEmail(results, null);
        return results;
    }

    private IOContainer runAndLogSpecialErrorCases(Operator operator, IOContainer inputs) throws OperatorException, RepositoryException, IOException {
        try {
            IOContainer results = this.runAndSendEmail(operator, inputs);
            LogService.getRoot().log(Level.INFO, "com.rapidminer.RapidMinerCommandLine.process_finished");
            return results;
        }
        catch (OutOfMemoryError e) {
            LogService.getRoot().log(Level.SEVERE, "com.rapidminer.RapidMinerCommandLine.out_of_memory");
            ActionStatisticsCollector.getInstance().log("error", "out_of_memory", String.valueOf(SystemInfoUtilities.getMaxHeapMemorySize()));
            Process process = operator.getProcess();
            process.getLogger().log(Level.SEVERE, "Here: " + process.getRootOperator().createMarkedProcessTree(10, "==>", process.getCurrentOperator()));
            try {
                process.getRootOperator().sendEmail(null, (Throwable)e);
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
            throw e;
        }
        catch (DatabaseConstraintViolationException ex) {
            if (ex.getOperatorName() != null) {
                LogService.getRoot().log(Level.SEVERE, "com.rapidminer.RapidMinerCommandLine.database_constraint_violation_exception_in_operator", new Object[]{ex.getDatabaseURL(), ex.getOperatorName()});
            } else {
                LogService.getRoot().log(Level.SEVERE, "com.rapidminer.RapidMinerCommandLine.database_constraint_violation_exception", new Object[]{ex.getDatabaseURL()});
            }
            throw ex;
        }
        catch (LicenseViolationException e) {
            LogService.getRoot().log(Level.SEVERE, "com.rapidminer.RapidMinerCommandLine.operator_constraint_violation_exception", new Object[]{e.getOperatorName()});
            throw e;
        }
        catch (RuntimeException e) {
            String debugProperty = ParameterService.getParameterValue((String)"rapidminer.general.debugmode");
            boolean debugMode = Tools.booleanValue((String)debugProperty, (boolean)false);
            Object message = e.getMessage();
            if (!debugMode) {
                message = e.getMessage() != null ? "operator cannot be executed (" + e.getMessage() + "). Check the log messages..." : "operator cannot be executed. Check the log messages...";
            }
            Process process = operator.getProcess();
            LogService.getRoot().log(Level.SEVERE, "Process failed: " + (String)message, e);
            LogService.getRoot().log(Level.SEVERE, "Here: " + process.getRootOperator().createMarkedProcessTree(10, "==>", process.getCurrentOperator()));
            try {
                process.getRootOperator().sendEmail(null, (Throwable)e);
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
            throw e;
        }
    }

    private IOContainer runAndLogGeneralErrorCase(Operator operator, IOContainer inputs) throws OperatorException, RepositoryException, IOException {
        try {
            return this.runAndLogSpecialErrorCases(operator, inputs);
        }
        catch (RuntimeException t) {
            Process process = operator.getProcess();
            if (process != null) {
                ActionStatisticsCollector.getInstance().log(process.getCurrentOperator(), "FAILURE");
                ActionStatisticsCollector.getInstance().log(process.getCurrentOperator(), "RUNTIME_EXCEPTION");
            }
            throw t;
        }
    }

    public IOContainer run(Operator operator, IOContainer inputs) throws OperatorException, RepositoryException, IOException {
        return this.runAndLogGeneralErrorCase(operator, inputs);
    }
}

