/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.model;

import com.rapidminer.adaption.belt.ContextAdapter;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.table.BeltConverter;
import com.rapidminer.belt.table.Builders;
import com.rapidminer.belt.table.Table;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.belt.util.ColumnMetaData;
import com.rapidminer.belt.util.ColumnReference;
import com.rapidminer.belt.util.ColumnRole;
import com.rapidminer.core.concurrency.ConcurrencyContext;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.studio.concurrency.internal.SequentialConcurrencyContext;
import java.util.ArrayList;
import java.util.Iterator;

public final class ModelUtils {
    private ModelUtils() {
        throw new AssertionError((Object)"Static utility class must not be instantiated.");
    }

    public static ExampleSet createFeatureSet(ExampleSet exampleSet, ExampleSet trainingSet) {
        Attributes trainingAttributes = trainingSet.getAttributes();
        ExampleSet clonedExampleSet = (ExampleSet)exampleSet.clone();
        Attributes clonedAttributes = clonedExampleSet.getAttributes();
        ArrayList<AttributeRole> reorderedAttributes = new ArrayList<AttributeRole>(trainingAttributes.allSize());
        Iterator iterator = trainingAttributes.allAttributeRoles();
        while (iterator.hasNext()) {
            AttributeRole trainingAttributeRole = (AttributeRole)iterator.next();
            if ("label".equals(trainingAttributeRole.getSpecialName())) continue;
            String attributeName = trainingAttributeRole.getAttribute().getName();
            reorderedAttributes.add(clonedAttributes.getRole(attributeName));
        }
        clonedAttributes.clearRegular();
        clonedAttributes.clearSpecial();
        reorderedAttributes.forEach(arg_0 -> ((Attributes)clonedAttributes).add(arg_0));
        return clonedExampleSet;
    }

    public static ExampleSet mergePrediction(ExampleSet exampleSet, ExampleSet trainingHeader, IOObject predictionSet, IOObject scoreSet) {
        SequentialConcurrencyContext context = new SequentialConcurrencyContext();
        Table dataTable = BeltConverter.convert((ExampleSet)exampleSet, (ConcurrencyContext)context).getTable();
        Attribute labelAttribute = trainingHeader.getAttributes().getLabel();
        Table predictionTable = ModelUtils.convertToTable(predictionSet, (ConcurrencyContext)context);
        Table scoresTable = scoreSet != null ? ModelUtils.convertToTable(scoreSet, (ConcurrencyContext)context) : null;
        Object predictionLabel = labelAttribute == null ? predictionTable.label(0) : "prediction(" + labelAttribute.getName() + ")";
        TableBuilder builder = Builders.newTableBuilder((Table)dataTable);
        ModelUtils.addPredictionToTableBuilder(builder, dataTable, predictionTable, (String)predictionLabel);
        if (scoresTable != null) {
            ModelUtils.addScoresToTableBuilder(builder, dataTable, scoresTable, labelAttribute, (String)predictionLabel);
        }
        Table combinedTable = builder.build(ContextAdapter.adapt((ConcurrencyContext)context));
        return BeltConverter.convert((IOTable)new IOTable(combinedTable), (ConcurrencyContext)context);
    }

    private static Table convertToTable(IOObject ioObject, ConcurrencyContext context) {
        if (ioObject instanceof ExampleSet) {
            return BeltConverter.convert((ExampleSet)((ExampleSet)ioObject), (ConcurrencyContext)context).getTable();
        }
        if (ioObject instanceof IOTable) {
            return ((IOTable)ioObject).getTable();
        }
        throw new IllegalArgumentException("Unsupported IOObject type: " + ioObject.getClass().getName());
    }

    private static void addPredictionToTableBuilder(TableBuilder tableBuilder, Table dataTable, Table predictionTable, String predictionLabel) {
        if (dataTable.contains(predictionLabel)) {
            tableBuilder.remove(predictionLabel);
        }
        tableBuilder.add(predictionLabel, predictionTable.column(0)).addMetaData(predictionLabel, (ColumnMetaData)ColumnRole.PREDICTION);
    }

    private static void addScoresToTableBuilder(TableBuilder tableBuilder, Table dataTable, Table scoresTable, Attribute labelAttribute, String predictionLabel) {
        for (String scoreColumnLabel : scoresTable.labels()) {
            Object confidenceLabel;
            Object object = confidenceLabel = labelAttribute == null ? scoreColumnLabel : "confidence(" + scoreColumnLabel + ")";
            if (dataTable.contains((String)confidenceLabel)) {
                tableBuilder.remove((String)confidenceLabel);
            }
            tableBuilder.add((String)confidenceLabel, scoresTable.column(scoreColumnLabel)).addMetaData((String)confidenceLabel, (ColumnMetaData)ColumnRole.SCORE).addMetaData((String)confidenceLabel, (ColumnMetaData)new ColumnReference(predictionLabel, scoreColumnLabel));
        }
    }
}

