/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.model;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.ExampleSetUtilities;
import com.rapidminer.extension.pythonscripting.model.EnvironmentReference;
import com.rapidminer.extension.pythonscripting.model.ModelUtils;
import com.rapidminer.extension.pythonscripting.operator.EnvironmentTools;
import com.rapidminer.extension.pythonscripting.operator.scripting.ScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonNativeObject;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonScriptingOperator;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.DummyOperator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.repository.versioned.JsonStorableModel;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.Tools;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;

public class PythonModel
extends PredictionModel
implements EnvironmentReference,
JsonStorableModel {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String script;
    private final byte[] payload;
    private boolean defaultPython = true;
    private String packageManager = null;
    private String environment = null;

    protected PythonModel() {
        this.name = "";
        this.description = "";
        this.script = "";
        this.payload = null;
    }

    public PythonModel(String name, String description, String script, byte[] payload, ExampleSet trainingSet) {
        super(trainingSet, ExampleSetUtilities.SetsCompareOption.ALLOW_SUPERSET, ExampleSetUtilities.TypesCompareOption.ALLOW_SAME_PARENTS);
        this.name = name;
        this.description = description;
        this.script = script;
        this.payload = payload;
    }

    public IOObject copy() {
        PythonModel model = new PythonModel(this.name, this.description, this.script, this.payload, (ExampleSet)this.getTrainingHeader());
        model.setDefaultPython(this.isDefaultPython());
        model.setPackageManager(this.getPackageManager());
        model.setEnvironment(this.getEnvironment());
        return model;
    }

    public ExampleSet apply(ExampleSet data) throws OperatorException {
        this.checkCompatibility(data);
        return this.performPrediction(data, null);
    }

    public ExampleSet performPrediction(ExampleSet data, Attribute predictedLabel) throws OperatorException {
        IOObject scoreSet;
        IOObject predictionSet;
        List<IOObject> results;
        Operator operator = this.getOperatorOrDummy();
        ExampleSet featureSet = ModelUtils.createFeatureSet(data, (ExampleSet)this.getTrainingHeader());
        boolean arrowSerializationUsed = operator.getCompatibilityLevel().isAbove((VersionNumber)PythonScriptingOperator.VERSION_ARROW_SERIALIZATION);
        ScriptRunner runner = EnvironmentTools.getScriptRunner(operator, this, this.getApplicationScript(), null, false, arrowSerializationUsed);
        try (ByteArrayInputStream payloadStream = new ByteArrayInputStream(this.payload);){
            PythonNativeObject model = new PythonNativeObject(payloadStream);
            results = runner.run(Arrays.asList(new IOObject[]{featureSet, model}), 2);
        }
        catch (UserError e) {
            throw e;
        }
        catch (Exception e) {
            operator.checkForStop();
            throw new UserError(operator, (Throwable)e, "python_scripting.python_runner_error");
        }
        if (results == null || results.isEmpty()) {
            throw new UserError(operator, "python_scripting.invalid_application_result_size");
        }
        try {
            predictionSet = results.get(0);
            scoreSet = results.size() > 1 ? results.get(1) : null;
        }
        catch (ClassCastException e) {
            throw new UserError(operator, (Throwable)e, "python_scripting.invalid_application_result_type");
        }
        return ModelUtils.mergePrediction(data, (ExampleSet)this.getTrainingHeader(), predictionSet, scoreSet);
    }

    private String getApplicationScript() {
        return this.script + "\nrm_main = rm_apply\n";
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        Attribute label = this.getTrainingHeader().getAttributes().getLabel();
        if (label == null) {
            return this.getName() + " model:" + Tools.getLineSeparator() + Tools.getLineSeparator() + this.description;
        }
        return this.getName() + " model for label " + label.getName() + ":" + Tools.getLineSeparator() + Tools.getLineSeparator() + this.description;
    }

    @Override
    public Operator getOperatorOrDummy() {
        Operator operator = this.getOperator();
        if (operator == null) {
            try {
                operator = OperatorService.createOperator(DummyOperator.class);
            }
            catch (OperatorCreationException e) {
                throw new AssertionError((Object)"Failed to instantiate dummy operator.");
            }
        }
        return operator;
    }

    public void setParameter(String key, Object value) throws OperatorException {
        if (key == null) {
            return;
        }
        try {
            switch (key) {
                case "use_default_python": {
                    this.defaultPython = Boolean.parseBoolean((String)value);
                    break;
                }
                case "package_manager": {
                    this.packageManager = (String)value;
                    break;
                }
                case "conda_environment": 
                case "venvw_environment": 
                case "python_binary": {
                    this.environment = (String)value;
                    break;
                }
                default: {
                    throw new UserError(this.getOperator(), "python_scripting.unsupported_application_parameter", new Object[]{key});
                }
            }
        }
        catch (ClassCastException e) {
            throw new UserError(this.getOperator(), "python_scripting.invalid_application_parameter", new Object[]{key});
        }
    }

    @Override
    public boolean isDefaultPython() {
        return this.defaultPython;
    }

    @Override
    public void setDefaultPython(boolean defaultPython) {
        this.defaultPython = defaultPython;
    }

    @Override
    public String getPackageManager() {
        return this.packageManager;
    }

    @Override
    public void setPackageManager(String packageManager) {
        this.packageManager = packageManager;
    }

    @Override
    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(String environment) {
        this.environment = environment;
    }
}

