/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator;

import com.rapidminer.ProcessLocation;
import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.model.EnvironmentReference;
import com.rapidminer.extension.pythonscripting.operator.PythonContext;
import com.rapidminer.extension.pythonscripting.operator.scripting.AbstractScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.ScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.LegacyPythonScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonArrowScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonBinarySupplier;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonSetupTester;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.RemoteScriptRunner;
import com.rapidminer.extension.pythonscripting.parameter.CondaEnvironmentSuggestionProvider;
import com.rapidminer.extension.pythonscripting.parameter.ParameterTypeScriptingEnvironment;
import com.rapidminer.extension.pythonscripting.parameter.PythonBinariesSuggestionProvider;
import com.rapidminer.extension.pythonscripting.parameter.VenvwEnvironmentSuggestionProvider;
import com.rapidminer.gui.properties.SettingsDialog;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryLocationBuilder;
import com.rapidminer.repository.versioned.BasicEntry;
import com.rapidminer.repository.versioned.BasicProcessEntry;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.RMUrlHandler;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class EnvironmentTools {
    public static final String PREFERENCES_TAB = "python_scripting";
    public static final String PARAMETER_USE_DEFAULT_PYTHON = "use_default_python";
    public static final String PARAMETER_PACKAGE_MANAGER = "package_manager";
    public static final String PARAMETER_CONDA_ENVIRONMENT = "conda_environment";
    public static final String PARAMETER_VENVW_ENVIRONMENT = "venvw_environment";
    public static final String PARAMETER_PYTHON_BINARY = "python_binary";
    protected static final Set<String> ENV_MGMT_PARAMETERS = Stream.of("use_default_python", "package_manager", "conda_environment", "venvw_environment", "python_binary").collect(Collectors.toSet());
    private static final String PYTHON_SCRIPTING_NOT_FOUND_I18NKEY = "python_scripting.not_found";
    private static final String PYTHON_SCRIPTING_CONDA_NOT_FOUND_I18NKEY = "python_scripting.conda_env_not_found";
    private static final String PYTHON_SCRIPTING_VENVW_NOT_FOUND_I18NKEY = "python_scripting.venvw_env_not_found";
    private static final Map<String, String> ENVIRONMENT_PARAMETERS = new HashMap<String, String>(3);

    private EnvironmentTools() {
        throw new AssertionError((Object)"Static utility class must not be instantiated.");
    }

    public static Path getPythonBinary(Operator operator) throws UndefinedParameterError {
        if (operator.getParameterAsBoolean(PARAMETER_USE_DEFAULT_PYTHON)) {
            return PluginInitPythonScripting.getDefaultPythonBinary();
        }
        String manager = operator.getParameterAsString(PARAMETER_PACKAGE_MANAGER);
        if (manager == null) {
            manager = "specific python binaries";
        }
        switch (manager) {
            case "conda (anaconda)": {
                String condaEnv = operator.getParameterAsString(PARAMETER_CONDA_ENVIRONMENT);
                if (condaEnv != null) {
                    return PythonSetupTester.INSTANCE.getFullPathForCondaEnvironment(condaEnv);
                }
                throw new UndefinedParameterError(PARAMETER_CONDA_ENVIRONMENT);
            }
            case "virtualenvwrapper": {
                String virtualEnv = operator.getParameterAsString(PARAMETER_VENVW_ENVIRONMENT);
                if (virtualEnv != null) {
                    return PythonSetupTester.INSTANCE.getFullPathForVenvwEnvironment(virtualEnv);
                }
                throw new UndefinedParameterError(PARAMETER_VENVW_ENVIRONMENT);
            }
        }
        String path = operator.getParameterAsString(PARAMETER_PYTHON_BINARY);
        if (path != null) {
            return PythonSetupTester.INSTANCE.getFullPathForPythonBinary(path);
        }
        throw new UndefinedParameterError(PARAMETER_PYTHON_BINARY);
    }

    public static Path getPythonBinary(EnvironmentReference model) throws UndefinedParameterError {
        if (model.isDefaultPython()) {
            return PluginInitPythonScripting.getDefaultPythonBinary();
        }
        String manager = model.getPackageManager();
        if (manager == null) {
            manager = "specific python binaries";
        }
        String environment = model.getEnvironment();
        switch (manager) {
            case "conda (anaconda)": {
                if (environment != null) {
                    return PythonSetupTester.INSTANCE.getFullPathForCondaEnvironment(environment);
                }
                throw new UndefinedParameterError(PARAMETER_CONDA_ENVIRONMENT);
            }
            case "virtualenvwrapper": {
                if (environment != null) {
                    return PythonSetupTester.INSTANCE.getFullPathForVenvwEnvironment(environment);
                }
                throw new UndefinedParameterError(PARAMETER_VENVW_ENVIRONMENT);
            }
        }
        if (environment != null) {
            return PythonSetupTester.INSTANCE.getFullPathForPythonBinary(environment);
        }
        throw new UndefinedParameterError(PARAMETER_PYTHON_BINARY);
    }

    public static String getPythonEnvironmentName(Operator operator) throws UndefinedParameterError {
        if (operator.getParameterAsBoolean(PARAMETER_USE_DEFAULT_PYTHON)) {
            return PluginInitPythonScripting.getDefaultPythonEnvironmentName();
        }
        String manager = operator.getParameterAsString(PARAMETER_PACKAGE_MANAGER);
        String parameter = ENVIRONMENT_PARAMETERS.getOrDefault(manager, "specific python binaries");
        return operator.getParameterAsString(parameter);
    }

    public static void checkPythonEnvironment(Operator operator) throws UserError {
        Path pythonBinaryPath;
        try {
            pythonBinaryPath = EnvironmentTools.getPythonBinary(operator);
        }
        catch (InvalidPathException e) {
            throw new UserError(operator, (Throwable)e, "python_scripting.invalid_path", new Object[]{e.getMessage()});
        }
        EnvironmentTools.checkPythonEnvironment(operator, pythonBinaryPath);
    }

    public static void checkPythonEnvironment(Operator operator, EnvironmentReference env) throws UserError {
        Path pythonBinaryPath;
        try {
            pythonBinaryPath = EnvironmentTools.getPythonBinary(env);
        }
        catch (InvalidPathException e) {
            throw new UserError(operator, (Throwable)e, "python_scripting.invalid_path", new Object[]{e.getMessage()});
        }
        EnvironmentTools.checkPythonEnvironment(operator, pythonBinaryPath);
    }

    private static void checkPythonEnvironment(Operator operator, Path pythonBinaryPath) throws UserError {
        if (pythonBinaryPath == null) {
            String name = EnvironmentTools.getPythonEnvironmentName(operator);
            if (name == null) {
                name = "";
            }
            throw new UserError(operator, "python_scripting.setup_test_environment.failure", new Object[]{name});
        }
        String pythonBinary = pythonBinaryPath.toString();
        LogService.getRoot().info(() -> String.format("Using Python binary '%s' to run Python code in operator '%s'.", pythonBinary, operator.getName()));
        PluginInitPythonScripting.logExtensionProperties();
        if (!PythonSetupTester.INSTANCE.isPythonInstalled(pythonBinary)) {
            throw new UserError(operator, "python_scripting.setup_test.failure", new Object[]{pythonBinaryPath});
        }
    }

    public static List<ParameterType> getParameterTypes(Operator operator) {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        ParameterTypeBoolean useDefaultPython = new ParameterTypeBoolean(PARAMETER_USE_DEFAULT_PYTHON, I18N.getGUIMessage((String)"gui.parameters.python_scripting.preferences.use_default_python", (Object[])new Object[0]), true, true);
        types.add((ParameterType)useDefaultPython);
        ParameterTypeCategory packageManagers = new ParameterTypeCategory(PARAMETER_PACKAGE_MANAGER, I18N.getGUIMessage((String)"gui.parameters.python_scripting.preferences.package_manager", (Object[])new Object[0]), PluginInitPythonScripting.getPackageManagers(), 0);
        packageManagers.setExpert(true);
        packageManagers.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition(operator.getParameterHandler(), PARAMETER_USE_DEFAULT_PYTHON, true, false));
        types.add((ParameterType)packageManagers);
        ParameterTypeScriptingEnvironment condaEnvs = new ParameterTypeScriptingEnvironment(PARAMETER_CONDA_ENVIRONMENT, I18N.getGUIMessage((String)"gui.parameters.python_scripting.preferences.conda_environment", (Object[])new Object[0]), new CondaEnvironmentSuggestionProvider());
        condaEnvs.setOptional(true);
        condaEnvs.setExpert(true);
        condaEnvs.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition(operator.getParameterHandler(), PARAMETER_USE_DEFAULT_PYTHON, true, false));
        condaEnvs.registerDependencyCondition((ParameterCondition)new EqualStringCondition(operator.getParameterHandler(), PARAMETER_PACKAGE_MANAGER, true, new String[]{"conda (anaconda)"}));
        types.add((ParameterType)condaEnvs);
        ParameterTypeScriptingEnvironment venevwEnvs = new ParameterTypeScriptingEnvironment(PARAMETER_VENVW_ENVIRONMENT, I18N.getGUIMessage((String)"gui.parameters.python_scripting.preferences.venvw_environment", (Object[])new Object[0]), new VenvwEnvironmentSuggestionProvider());
        venevwEnvs.setOptional(true);
        venevwEnvs.setExpert(true);
        venevwEnvs.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition(operator.getParameterHandler(), PARAMETER_USE_DEFAULT_PYTHON, true, false));
        venevwEnvs.registerDependencyCondition((ParameterCondition)new EqualStringCondition(operator.getParameterHandler(), PARAMETER_PACKAGE_MANAGER, true, new String[]{"virtualenvwrapper"}));
        types.add((ParameterType)venevwEnvs);
        ParameterTypeScriptingEnvironment binaries = new ParameterTypeScriptingEnvironment(PARAMETER_PYTHON_BINARY, I18N.getGUIMessage((String)"gui.parameters.python_scripting.preferences.python_binary", (Object[])new Object[0]), new PythonBinariesSuggestionProvider());
        binaries.setOptional(true);
        binaries.setExpert(true);
        binaries.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition(operator.getParameterHandler(), PARAMETER_USE_DEFAULT_PYTHON, true, false));
        binaries.registerDependencyCondition((ParameterCondition)new EqualStringCondition(operator.getParameterHandler(), PARAMETER_PACKAGE_MANAGER, true, new String[]{"specific python binaries"}));
        types.add((ParameterType)binaries);
        return types;
    }

    public static ProcessSetupError getErrorForPythonInstallationProblem(Operator operator, Path pythonPath) {
        String i18nKey = null;
        String param = "";
        ArrayList<Object> fixes = new ArrayList<Object>();
        if (!PythonSetupTester.INSTANCE.isPandasInstalled(pythonPath.toString())) {
            i18nKey = "python_scripting.pandas";
            fixes.add(EnvironmentTools.constructQuickFixWithUrl(i18nKey, "gui.label.python_scripting.download_anaconda.url"));
            fixes.add(EnvironmentTools.constructQuickFixWithUrl("python_scripting.pandas_directly", "gui.label.python_scripting.download_pandas.url"));
        } else if (PythonSetupTester.INSTANCE.pandasVersionNotSufficient(pythonPath.toString())) {
            i18nKey = "python_scripting.pandas_version";
            fixes.add(EnvironmentTools.constructQuickFixWithUrl(i18nKey, "gui.label.python_scripting.upgrade_pandas.url"));
        }
        if (!PythonSetupTester.INSTANCE.isCPickleInstalled(pythonPath.toString())) {
            i18nKey = "python_scripting.cpickle";
            fixes.add(EnvironmentTools.constructQuickFixWithUrl(i18nKey, "gui.label.python_scripting.download_cpickle.url"));
        }
        if (i18nKey != null && operator.getParameterAsBoolean(PARAMETER_USE_DEFAULT_PYTHON)) {
            fixes.add(new AbstractQuickFix(1, true, "python_scripting.configure", new Object[0]){

                public void apply() {
                    new SettingsDialog(EnvironmentTools.PREFERENCES_TAB).setVisible(true);
                }
            });
        }
        if (i18nKey != null) {
            return new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, operator.getPortOwner(), fixes, i18nKey, new Object[]{param});
        }
        return null;
    }

    public static ProcessSetupError getErrorForDefaultPythonNotSetProperlyProblem(Operator operator) {
        String i18nKey;
        Path defaultPath = null;
        InvalidPathException exception = null;
        try {
            defaultPath = PluginInitPythonScripting.getDefaultPythonBinary();
        }
        catch (InvalidPathException e) {
            exception = e;
        }
        String param = "";
        ArrayList<2> fixes = new ArrayList<2>();
        if ("conda (anaconda)".equals(ParameterService.getParameterValue((String)"rapidminer.python_scripting.package_manager"))) {
            i18nKey = PYTHON_SCRIPTING_CONDA_NOT_FOUND_I18NKEY;
            param = ParameterService.getParameterValue((String)"rapidminer.python_scripting.conda_environment");
        } else if ("virtualenvwrapper".equals(ParameterService.getParameterValue((String)"rapidminer.python_scripting.package_manager"))) {
            i18nKey = PYTHON_SCRIPTING_VENVW_NOT_FOUND_I18NKEY;
            param = ParameterService.getParameterValue((String)"rapidminer.python_scripting.venvw_environment");
        } else {
            i18nKey = PYTHON_SCRIPTING_NOT_FOUND_I18NKEY;
            if (defaultPath != null) {
                param = defaultPath.toString();
            }
        }
        if (exception == null && "".equals(param)) {
            i18nKey = "python_scripting.not_configured";
            param = "";
        }
        fixes.add(new AbstractQuickFix(1, true, "python_scripting.configure", new Object[0]){

            public void apply() {
                new SettingsDialog(EnvironmentTools.PREFERENCES_TAB).setVisible(true);
            }
        });
        if (exception == null) {
            return new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, operator.getPortOwner(), fixes, i18nKey, new Object[]{param});
        }
        return new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, operator.getPortOwner(), fixes, i18nKey + ".invalid_path", new Object[]{param, ((Throwable)exception).getMessage()});
    }

    public static ProcessSetupError getErrorForOperatorsPythonNotSetProperlyProblem(Operator operator, Exception exception) {
        String i18nKey = null;
        String paramValue = "";
        ArrayList<ParameterSettingQuickFix> fixes = new ArrayList<ParameterSettingQuickFix>();
        try {
            String paramName;
            if ("conda (anaconda)".equals(operator.getParameterAsString(PARAMETER_PACKAGE_MANAGER))) {
                paramName = PARAMETER_CONDA_ENVIRONMENT;
                i18nKey = PYTHON_SCRIPTING_CONDA_NOT_FOUND_I18NKEY;
            } else if ("virtualenvwrapper".equals(operator.getParameterAsString(PARAMETER_PACKAGE_MANAGER))) {
                paramName = PARAMETER_VENVW_ENVIRONMENT;
                i18nKey = PYTHON_SCRIPTING_VENVW_NOT_FOUND_I18NKEY;
            } else {
                paramName = PARAMETER_PYTHON_BINARY;
                i18nKey = PYTHON_SCRIPTING_NOT_FOUND_I18NKEY;
            }
            paramValue = operator.getParameterAsString(paramName);
            fixes.add(new ParameterSettingQuickFix(operator, paramName));
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (exception == null) {
            return new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, operator.getPortOwner(), fixes, i18nKey, new Object[]{paramValue});
        }
        return new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, operator.getPortOwner(), fixes, i18nKey + ".invalid_path", new Object[]{paramValue, exception.getMessage()});
    }

    private static QuickFix constructQuickFixWithUrl(String i18nKey, String urli18nKey) {
        final String url = I18N.getGUIMessage((String)urli18nKey, (Object[])new Object[0]);
        return new AbstractQuickFix(1, true, i18nKey, new Object[0]){

            public void apply() {
                try {
                    RMUrlHandler.openInBrowser((URI)new URI(url));
                }
                catch (Exception ex) {
                    SwingTools.showSimpleErrorMessage((String)"cannot_open_browser", (Throwable)ex, (Object[])new Object[0]);
                }
            }
        };
    }

    private static PythonBinarySupplier getPythonBinarySupplier(final Operator operator) {
        return new PythonBinarySupplier(){

            @Override
            public Path getPythonBinary() throws UndefinedParameterError {
                return EnvironmentTools.getPythonBinary(operator);
            }

            @Override
            public String getPythonEnvironmentName() throws UndefinedParameterError {
                return EnvironmentTools.getPythonEnvironmentName(operator);
            }
        };
    }

    public static PythonBinarySupplier getPythonBinarySupplier(final EnvironmentReference model) {
        return new PythonBinarySupplier(){

            @Override
            public Path getPythonBinary() throws UndefinedParameterError {
                return EnvironmentTools.getPythonBinary(model);
            }

            @Override
            public String getPythonEnvironmentName() {
                return model.isDefaultPython() ? PluginInitPythonScripting.getDefaultPythonEnvironmentName() : model.getEnvironment();
            }
        };
    }

    public static ScriptRunner getScriptRunner(Operator operator, String script, Path workingDirectory, boolean legacyIo, boolean arrowSerializationUsed) throws UserError {
        return EnvironmentTools.createScriptRunner(operator, script, workingDirectory, legacyIo, arrowSerializationUsed, null);
    }

    public static ScriptRunner getScriptRunner(Operator operator, EnvironmentReference env, String script, Path workingDirectory, boolean legacyIo, boolean arrowSerializationUsed) throws UserError {
        return EnvironmentTools.createScriptRunner(operator, script, workingDirectory, legacyIo, arrowSerializationUsed, env);
    }

    private static ScriptRunner createScriptRunner(Operator operator, String script, Path workingDirectory, boolean legacyIo, boolean arrowSerializationUsed, EnvironmentReference env) throws UserError {
        Map<String, String> connection = PythonContext.lookUpRemoteConnection(operator);
        if (connection != null) {
            return new RemoteScriptRunner(script, operator, connection);
        }
        PythonBinarySupplier supplier = env != null ? EnvironmentTools.getPythonBinarySupplierWithEnv(operator, env) : EnvironmentTools.getPythonBinarySupplierWithoutEnv(operator);
        return EnvironmentTools.createLocalScriptRunner(operator, supplier, script, workingDirectory, legacyIo, arrowSerializationUsed);
    }

    private static ScriptRunner createLocalScriptRunner(Operator operator, PythonBinarySupplier supplier, String script, Path workingDirectory, boolean legacyIo, boolean arrowSerializationUsed) {
        AbstractScriptRunner runner;
        if (legacyIo) {
            runner = new LegacyPythonScriptRunner(script, operator, supplier);
        } else {
            Path workingDir = workingDirectory != null ? workingDirectory : EnvironmentTools.lookupProcessDir(operator);
            AbstractScriptRunner abstractScriptRunner = runner = arrowSerializationUsed ? new PythonArrowScriptRunner(script, operator, supplier) : new PythonScriptRunner(script, operator, supplier);
            if (runner instanceof PythonScriptRunner) {
                ((PythonScriptRunner)runner).setWorkingDirectory(workingDir);
            } else {
                ((PythonArrowScriptRunner)runner).setWorkingDirectory(workingDir);
            }
        }
        runner.registerLogger(LogService.getRoot());
        LogService.getRoot().info(() -> String.format("Using script runner '%s' to run Python code in operator '%s'.", runner.getClass().getSimpleName(), operator.getName()));
        return runner;
    }

    private static Path lookupProcessDir(Operator operator) {
        ProcessLocation location;
        ProcessLocation processLocation = location = operator.getProcess() == null ? null : operator.getProcess().getProcessLocation();
        if (location != null) {
            try {
                String locString = location.toString();
                if (locString.endsWith(".rmp")) {
                    locString = locString.substring(0, locString.lastIndexOf(".rmp"));
                }
                RepositoryLocation repoLocation = new RepositoryLocationBuilder().buildFromAbsoluteLocation(locString);
                repoLocation.setExpectedDataEntryType(ProcessEntry.class);
                BasicProcessEntry processEntry = (BasicProcessEntry)repoLocation.locateData();
                if (processEntry == null) {
                    return null;
                }
                return processEntry.getRepositoryAdapter().getRealPath((BasicEntry)processEntry).getParent();
            }
            catch (OperatorException | RepositoryException | ClassCastException e) {
                LogService.getRoot().finest(() -> EnvironmentTools.lambda$lookupProcessDir$2((Exception)e));
            }
        }
        return null;
    }

    private static PythonBinarySupplier getPythonBinarySupplierWithEnv(Operator operator, EnvironmentReference env) throws UserError {
        EnvironmentTools.checkPythonEnvironment(operator, env);
        return EnvironmentTools.getPythonBinarySupplier(env);
    }

    private static PythonBinarySupplier getPythonBinarySupplierWithoutEnv(Operator operator) throws UserError {
        EnvironmentTools.checkPythonEnvironment(operator);
        return EnvironmentTools.getPythonBinarySupplier(operator);
    }

    private static /* synthetic */ String lambda$lookupProcessDir$2(Exception e) {
        return String.format("Could not set working directory for the script: %s", e.getMessage());
    }

    static {
        ENVIRONMENT_PARAMETERS.put("conda (anaconda)", PARAMETER_CONDA_ENVIRONMENT);
        ENVIRONMENT_PARAMETERS.put("virtualenvwrapper", PARAMETER_VENVW_ENVIRONMENT);
        ENVIRONMENT_PARAMETERS.put("specific python binaries", PARAMETER_PYTHON_BINARY);
    }
}

