/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class OperatorSentinel {
    private static final int SENTINEL_PERIOD = 500;
    private static final ScheduledExecutorService SENTINEL_SERVICE = Executors.newSingleThreadScheduledExecutor();

    private OperatorSentinel() {
        throw new AssertionError((Object)"Static utility class must not be instantiated.");
    }

    public static Sentinel scheduleSentinel(Operator operator, Runnable action) {
        if (operator == null) {
            return () -> {};
        }
        ScheduledFuture<?> future = SENTINEL_SERVICE.scheduleAtFixedRate(() -> {
            try {
                operator.checkForStop();
            }
            catch (ProcessStoppedException e) {
                action.run();
            }
        }, 500L, 500L, TimeUnit.MILLISECONDS);
        return () -> future.cancel(true);
    }

    public static interface Sentinel
    extends AutoCloseable {
        @Override
        public void close();
    }
}

