/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator;

import com.rapidminer.Process;
import com.rapidminer.ProcessListener;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.valueprovider.handler.ValueProviderHandlerRegistry;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;
import java.util.Map;

public class PythonContext
extends OperatorChain {
    private static final String PARAMETER_ENABLED = "enabled";
    private final PortPairExtender inputExtender = new PortPairExtender("in", this.getInputPorts(), this.getSubprocess(0).getInnerSources());
    private final PortPairExtender outputExtender = new PortPairExtender("out", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());
    private final ConnectionInformationSelector selector = new ConnectionInformationSelector((Operator)this, "python_scripting:standpy");

    public PythonContext(OperatorDescription description) {
        super(description, new String[]{"Nested Process"});
        this.inputExtender.start();
        this.outputExtender.start();
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule((MDTransformationRule)new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.outputExtender.makePassThroughRule());
    }

    public void doWork() throws OperatorException {
        final int numOperators = this.getSubprocess(0).getEnabledOperators().size();
        this.getProgress().setTotal(numOperators);
        this.getProcess().getRootOperator().addProcessListener(new ProcessListener(){
            private int counter = 0;

            public void processStarts(Process process) {
            }

            public void processStartedOperator(Process process, Operator op) {
            }

            public void processFinishedOperator(Process process, Operator op) {
                try {
                    if (op.getParent() != null && op.getParent().equals((Object)PythonContext.this)) {
                        PythonContext.this.getProgress().setCompleted(++this.counter);
                    }
                }
                catch (ProcessStoppedException e) {
                    PythonContext.this.getProcess().getRootOperator().removeProcessListener((ProcessListener)this);
                }
                if (this.counter == numOperators) {
                    PythonContext.this.getProcess().getRootOperator().removeProcessListener((ProcessListener)this);
                }
            }

            public void processEnded(Process process) {
                PythonContext.this.getProcess().getRootOperator().removeProcessListener((ProcessListener)this);
            }
        });
        this.clearAllInnerSinks();
        this.inputExtender.passDataThrough();
        super.doWork();
        this.outputExtender.passDataThrough();
        this.selector.passDataThrough();
    }

    public List<ParameterType> getParameterTypes() {
        List types = ConnectionInformationSelector.createParameterTypes((ConnectionInformationSelector)this.selector);
        types.add(new ParameterTypeBoolean(PARAMETER_ENABLED, "Override environment configuration of nested Python operators.", true));
        return types;
    }

    private ConnectionInformation getConnection() throws UserError {
        return this.selector.getConnection();
    }

    public static Map<String, String> lookUpRemoteConnection(Operator operator) throws UserError {
        OperatorChain parent;
        OperatorChain operatorChain = parent = operator == null ? null : operator.getParent();
        while (parent != null) {
            PythonContext context;
            if (parent.isEnabled() && parent instanceof PythonContext && (context = (PythonContext)parent).getParameterAsBoolean(PARAMETER_ENABLED)) {
                ConnectionInformation connection = context.getConnection();
                return ValueProviderHandlerRegistry.getInstance().injectValues(connection, (Operator)parent, false);
            }
            parent = parent.getParent();
        }
        return null;
    }
}

