/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator;

import com.rapidminer.adaption.belt.ContextAdapter;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.NumericBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.execution.Context;
import com.rapidminer.belt.table.BeltConverter;
import com.rapidminer.belt.table.Builders;
import com.rapidminer.belt.table.Table;
import com.rapidminer.core.concurrency.ConcurrencyContext;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.pythonscripting.definition.ConfigurationTools;
import com.rapidminer.extension.pythonscripting.model.EnvironmentReference;
import com.rapidminer.extension.pythonscripting.operator.EnvironmentTools;
import com.rapidminer.extension.pythonscripting.operator.OperatorSentinel;
import com.rapidminer.extension.pythonscripting.operator.scripting.ScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonNativeObject;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonScriptingOperator;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.DummyOperator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.WrapperOperatorRuntimeException;
import com.rapidminer.studio.concurrency.internal.SequentialConcurrencyContext;
import com.rapidminer.timeseriesanalysis.datamodel.dimension.interfaces.IndexDimension;
import com.rapidminer.timeseriesanalysis.datamodel.dimension.interfaces.SeriesValues;
import com.rapidminer.timeseriesanalysis.datamodel.series.SeriesBuilder;
import com.rapidminer.timeseriesanalysis.forecast.ForecastModel;
import com.rapidminer.timeseriesanalysis.tools.SeriesUtils;
import com.rapidminer.tools.OperatorService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class PythonForecast
extends ForecastModel<Double, Double>
implements EnvironmentReference {
    private static final long serialVersionUID = -6649151276866127156L;
    private static final String ENTRYPOINT = PythonForecast.loadEntrypointScript();
    private final String name;
    private final String description;
    private final String script;
    private final byte[] payload;
    private boolean defaultPython = true;
    private String packageManager = null;
    private String environment = null;
    private transient Operator operator = null;

    public PythonForecast() {
        this.name = "";
        this.description = "";
        this.script = "";
        this.payload = null;
    }

    protected PythonForecast(String name, String description, String script, byte[] payload, Operator operator) {
        this.name = name;
        this.description = description;
        this.script = script;
        this.payload = payload;
        this.operator = operator;
    }

    private static String loadEntrypointScript() {
        return ConfigurationTools.loadTextFile("scripts/forecaster_entrypoint.py");
    }

    protected SeriesValues<Double> forecastValues(IndexDimension<Double> indexDimension, SeriesValues<Double> seriesValues, String forecastSeriesName) {
        try {
            ScriptRunner runner = this.createScriptRunner();
            List<IOObject> results = this.executeScript(runner);
            List<Double> forecastResults = this.extractForecastResults(results.get(0));
            return SeriesUtils.createSeriesValues(forecastResults, (SeriesBuilder.ValuesType)SeriesBuilder.ValuesType.REAL, (String)forecastSeriesName);
        }
        catch (OperatorException e) {
            throw new WrapperOperatorRuntimeException(e);
        }
        catch (Exception e) {
            throw new WrapperOperatorRuntimeException((OperatorException)((Object)new UserError(this.operator, (Throwable)e, "python_scripting.python_runner_error")));
        }
    }

    private ScriptRunner createScriptRunner() throws OperatorException {
        Operator op = this.getOperatorOrDummy();
        boolean useArrowSerialization = op.getCompatibilityLevel().isAbove((VersionNumber)PythonScriptingOperator.VERSION_ARROW_SERIALIZATION);
        return EnvironmentTools.getScriptRunner(op, this, this.getApplicationScript(), null, false, useArrowSerialization);
    }

    private List<IOObject> executeScript(ScriptRunner runner) throws OperatorException, IOException {
        Context context = ContextAdapter.adapt((ConcurrencyContext)new SequentialConcurrencyContext());
        Table horizonTable = this.createHorizonTable(context);
        try (OperatorSentinel.Sentinel sentinel = OperatorSentinel.scheduleSentinel(null, runner::cancel);){
            List<IOObject> list;
            try (ByteArrayInputStream payloadStream = new ByteArrayInputStream(this.payload);){
                PythonNativeObject model = new PythonNativeObject(payloadStream);
                list = runner.run(Arrays.asList(new IOObject[]{model, BeltConverter.convertSequentially((IOTable)new IOTable(horizonTable))}), 1);
            }
            return list;
        }
    }

    private Table createHorizonTable(Context context) {
        NumericBuffer buffer = Buffers.realBuffer((int)1);
        buffer.set(0, (double)this.forecastHorizon);
        return Builders.newTableBuilder((int)1).add("Value", buffer.toColumn()).build(context);
    }

    private List<Double> extractForecastResults(IOObject predictionSet) {
        if (predictionSet instanceof ExampleSet) {
            return this.extractFromExampleSet((ExampleSet)predictionSet);
        }
        if (predictionSet instanceof IOTable) {
            return this.extractFromIOTable((IOTable)predictionSet);
        }
        throw new IllegalArgumentException("Unsupported type for predictionSet: " + predictionSet.getClass());
    }

    private List<Double> extractFromExampleSet(ExampleSet exampleSet) {
        Attribute attribute = exampleSet.getExampleTable().getAttribute(0);
        ArrayList<Double> result = new ArrayList<Double>();
        for (Example example : exampleSet) {
            result.add(example.getValue(attribute));
        }
        return result;
    }

    private List<Double> extractFromIOTable(IOTable ioTable) {
        Table table = ioTable.getTable();
        Column column = table.column(0);
        double[] values = new double[table.height()];
        column.fill(values, 0);
        return Arrays.stream(values).boxed().collect(Collectors.toList());
    }

    public ForecastModel<Double, Double> copy() {
        PythonForecast model = new PythonForecast(this.name, this.description, this.script, this.payload, this.operator);
        model.setDefaultPython(this.isDefaultPython());
        model.setPackageManager(this.getPackageManager());
        model.setEnvironment(this.getEnvironment());
        return model;
    }

    public String getName() {
        return "Python Forecast Model";
    }

    public String getApplicationScript() {
        return this.script + ENTRYPOINT;
    }

    @Override
    public boolean isDefaultPython() {
        return this.defaultPython;
    }

    @Override
    public void setDefaultPython(boolean defaultPython) {
        this.defaultPython = defaultPython;
    }

    @Override
    public String getPackageManager() {
        return this.packageManager;
    }

    @Override
    public void setPackageManager(String packageManager) {
        this.packageManager = packageManager;
    }

    @Override
    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Override
    public Operator getOperatorOrDummy() {
        if (this.operator != null) {
            return this.operator;
        }
        try {
            return OperatorService.createOperator(DummyOperator.class);
        }
        catch (OperatorCreationException e) {
            throw new AssertionError((Object)"Failed to instantiate dummy operator.");
        }
    }

    public String toString() {
        return "Python Forecast Model";
    }
}

