/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.table.Table;
import com.rapidminer.connection.ConnectionInformationContainerIOObject;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.pythonscripting.definition.ConfigurationTools;
import com.rapidminer.extension.pythonscripting.definition.DynamicParameter;
import com.rapidminer.extension.pythonscripting.definition.DynamicPort;
import com.rapidminer.extension.pythonscripting.definition.InvalidDeclarationException;
import com.rapidminer.extension.pythonscripting.definition.OperatorDeclaration;
import com.rapidminer.extension.pythonscripting.model.EnvironmentReference;
import com.rapidminer.extension.pythonscripting.operator.EnvironmentTools;
import com.rapidminer.extension.pythonscripting.operator.scripting.AbstractScriptingLanguageOperator;
import com.rapidminer.extension.pythonscripting.operator.scripting.ScriptRunner;
import com.rapidminer.extension.pythonscripting.parameter.ParameterTypeOperator;
import com.rapidminer.extension.pythonscripting.parameter.SimpleCondition;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.tools.TableSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.container.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;

public abstract class PythonOperator
extends Operator {
    public static final String PARAMETER_OPERATOR = "operator";
    public static final String PARAMETER_EDITABLE = "editable";
    private static final Set<String> STATIC_PARAMETERS = new HashSet<String>();
    private static final Set<String> INVALID_DEFINITIONS = new HashSet<String>();
    private static final Map<String, Class<? extends IOObject>> PORT_TYPES;
    private static final JsonFactory JSON;
    private boolean immutable = false;
    private String immutableDeclaration = null;
    private String immutableDefinition = null;
    private List<ParameterGroup> dynamicParameters = Collections.emptyList();
    private OperatorDeclaration declaration = null;
    private boolean managePorts;
    private int numberOfStaticInputs;
    private int numberOfStaticOutputs;
    private boolean parametersInitialized;

    public PythonOperator(OperatorDescription description, boolean managePorts) {
        this(description, managePorts, 0, 0);
    }

    public PythonOperator(OperatorDescription description, boolean managePorts, int numberOfStaticInputs, int numberOfStaticOutputs) {
        super(description);
        this.managePorts = managePorts;
        this.numberOfStaticInputs = numberOfStaticInputs;
        this.numberOfStaticOutputs = numberOfStaticOutputs;
        this.parametersInitialized = false;
    }

    public Operator cloneOperator(String name, boolean forParallelExecution) {
        PythonOperator clone = (PythonOperator)super.cloneOperator(name, forParallelExecution);
        clone.managePorts = this.managePorts;
        clone.numberOfStaticInputs = this.numberOfStaticInputs;
        clone.numberOfStaticOutputs = this.numberOfStaticOutputs;
        clone.immutable = this.immutable;
        clone.immutableDeclaration = this.immutableDeclaration;
        clone.immutableDefinition = this.immutableDefinition;
        clone.tryReloadDeclaration();
        return clone;
    }

    protected void setImmutable(String declaration, String definition) {
        if (this.immutable) {
            throw new IllegalStateException("This operator's declaration and definition cannot be changed.");
        }
        this.immutable = true;
        this.immutableDeclaration = declaration;
        this.immutableDefinition = definition;
        this.tryReloadDeclaration();
    }

    public abstract String getDefaultDeclaration();

    public abstract String getDefaultScript();

    public abstract String getType();

    public static Set<String> getStaticParameters() {
        return STATIC_PARAMETERS;
    }

    public static Set<String> getStaticInputPorts() {
        return Collections.emptySet();
    }

    public static Set<String> getStaticOutputPorts() {
        return Collections.emptySet();
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        if (!this.immutable) {
            ParameterTypeBoolean editable = new ParameterTypeBoolean(PARAMETER_EDITABLE, "Enables the operator toolbar.", true);
            editable.setHidden(true);
            types.add((ParameterType)editable);
            ParameterTypeOperator config = new ParameterTypeOperator(PARAMETER_OPERATOR, "Tools for editing the operator definition and declaration.", this.getType());
            config.setDefaultValue(new Object[]{this.getDefaultDeclaration(), this.getDefaultScript()});
            config.registerDependencyCondition(new SimpleCondition(this, PARAMETER_EDITABLE, Boolean.toString(true), false));
            types.add((ParameterType)config);
        }
        types.addAll(EnvironmentTools.getParameterTypes(this));
        this.dynamicParameters.forEach(group -> types.addAll(group.getParameterTypes()));
        return types;
    }

    public Parameters getParameters() {
        Parameters parameters = super.getParameters();
        if (!this.parametersInitialized) {
            parameters.addObserver(this::onSetParameter, false);
            this.parametersInitialized = true;
        }
        return parameters;
    }

    public void setParameters(Parameters parameters) {
        Parameters old = this.getParameters();
        super.setParameters(parameters);
        if (parameters != old) {
            parameters.addObserver(this::onSetParameter, false);
            this.parametersInitialized = true;
        }
    }

    private void onSetParameter(Observable<String> ignored, String key) {
        if (!this.immutable && PARAMETER_OPERATOR.equals(key)) {
            this.tryReloadDeclaration();
        }
    }

    protected String getScript() throws UndefinedParameterError {
        if (this.immutable) {
            return this.immutableDefinition;
        }
        String configuration = this.getParameter(PARAMETER_OPERATOR);
        return (String)ParameterTypeOperator.decode(configuration).getSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void reloadDeclaration() throws IOException, UndefinedParameterError {
        this.declaration = null;
        this.dynamicParameters = Collections.emptyList();
        try {
            String json;
            if (this.immutable) {
                json = this.immutableDeclaration;
            } else {
                String config = this.getParameters().getParameter(PARAMETER_OPERATOR);
                json = (String)ParameterTypeOperator.decode(config).getFirst();
            }
            if (!INVALID_DEFINITIONS.contains(json)) {
                this.declaration = ConfigurationTools.readAndValidateOperatorDeclaration(json, PythonOperator.getStaticParameters(), PythonOperator.getStaticInputPorts(), PythonOperator.getStaticOutputPorts());
            }
        }
        finally {
            List<DynamicParameter> parameters;
            if (this.managePorts) {
                OutputPorts outputs;
                List<String> outputNames;
                List<DynamicPort> outputDeclaration;
                InputPorts inputs;
                List<String> inputNames;
                List<DynamicPort> inputDeclaration = this.getInputDeclaration();
                if (this.portsDiffer(inputDeclaration, inputNames = (inputs = this.getInputPorts()).getAllPorts().stream().skip(this.numberOfStaticInputs).map(Port::getName).collect(Collectors.toList()), this.getInputTypes())) {
                    List inputPorts = inputs.getAllPorts();
                    for (int i = this.numberOfStaticInputs; i < inputPorts.size(); ++i) {
                        inputs.removePort((Port)((InputPort)inputPorts.get(i)));
                    }
                    inputDeclaration.forEach(port -> {
                        InputPort input = (InputPort)inputs.createPort(port.getName());
                        MetaData meta = new MetaData(PORT_TYPES.getOrDefault(port.getType(), IOObject.class));
                        input.addPrecondition((Precondition)new SimplePrecondition(input, meta, true));
                    });
                }
                if (this.portsDiffer(outputDeclaration = this.getOutputDeclaration(), outputNames = (outputs = this.getOutputPorts()).getAllPorts().stream().skip(this.numberOfStaticOutputs).map(Port::getName).collect(Collectors.toList()), this.getOutputTypes())) {
                    List outputPorts = outputs.getAllPorts();
                    for (int i = this.numberOfStaticOutputs; i < outputPorts.size(); ++i) {
                        outputs.removePort((Port)((OutputPort)outputPorts.get(i)));
                    }
                    outputDeclaration.forEach(port -> {
                        OutputPort output = (OutputPort)outputs.createPort(port.getName());
                        this.getTransformer().addGenerationRule(output, PORT_TYPES.getOrDefault(port.getType(), IOObject.class));
                    });
                }
            }
            Set keys = this.getParameters().getKeys();
            HashSet dynamicKeys = new HashSet(keys);
            dynamicKeys.removeAll(STATIC_PARAMETERS);
            keys.removeAll(dynamicKeys);
            if (this.declaration != null && (parameters = this.declaration.getParameters()) != null) {
                ArrayList<ParameterGroup> types = new ArrayList<ParameterGroup>();
                for (DynamicParameter parameter : parameters) {
                    types.add(this.createParameterType(parameter));
                }
                this.dynamicParameters = types;
            }
            List<ParameterType> types = this.getParameterTypes();
            types.forEach(arg_0 -> ((Parameters)this.getParameters()).addParameterType(arg_0));
        }
    }

    private boolean portsDiffer(List<DynamicPort> declarations, List<String> names, Map<String, Class<? extends IOObject>> types) {
        if (declarations.size() != names.size()) {
            return true;
        }
        for (int i = 0; i < declarations.size(); ++i) {
            DynamicPort portDeclaration = declarations.get(i);
            String name = names.get(i);
            if (!portDeclaration.getName().equals(name)) {
                return true;
            }
            Class<IOObject> type = PORT_TYPES.getOrDefault(portDeclaration.getType(), IOObject.class);
            if (type == types.get(name)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Class<? extends IOObject>> getInputTypes() {
        HashMap<String, Class<? extends IOObject>> types = new HashMap<String, Class<? extends IOObject>>();
        for (InputPort port : this.getInputPorts().getAllPorts()) {
            for (Precondition condition : port.getAllPreconditions()) {
                MetaData meta = condition.getExpectedMetaData();
                if (meta == null) continue;
                types.put(port.getName(), meta.getObjectClass());
            }
        }
        return types;
    }

    private Map<String, Class<? extends IOObject>> getOutputTypes() {
        HashMap<String, Class<? extends IOObject>> types = new HashMap<String, Class<? extends IOObject>>();
        for (MDTransformationRule rule : this.getTransformer().getRules()) {
            if (!(rule instanceof GenerateNewMDRule)) continue;
            GenerateNewMDRule generationRule = (GenerateNewMDRule)rule;
            String name = generationRule.getOutputPort().getName();
            MetaData meta = generationRule.getUnmodifiedMetaData();
            types.put(name, meta.getObjectClass());
        }
        return types;
    }

    private List<DynamicPort> getInputDeclaration() {
        if (this.declaration == null) {
            return Collections.emptyList();
        }
        List<DynamicPort> names = this.declaration.getInputs();
        return names == null ? Collections.emptyList() : names;
    }

    private List<DynamicPort> getOutputDeclaration() {
        if (this.declaration == null) {
            return Collections.emptyList();
        }
        List<DynamicPort> names = this.declaration.getOutputs();
        return names == null ? Collections.emptyList() : names;
    }

    protected void tryReloadDeclaration() {
        try {
            this.reloadDeclaration();
        }
        catch (InvalidDeclarationException e) {
            LogService.getRoot().log(Level.SEVERE, "Failed to parse declaration: {0}", e.getMessage());
        }
        catch (JsonProcessingException e) {
            JsonLocation location = e.getLocation();
            if (location == null) {
                LogService.getRoot().log(Level.SEVERE, "Failed to parse declaration: Invalid JSON.", e);
            } else {
                LogService.getRoot().log(Level.SEVERE, "Failed to parse declaration: Unexpected symbol at line {0} column {1}.", new Object[]{location.getLineNr(), location.getColumnNr()});
            }
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.SEVERE, "Failed to parse declaration: Invalid JSON.", e);
        }
        catch (UndefinedParameterError e) {
            LogService.getRoot().log(Level.SEVERE, "Failed to look up operator configuration.", e);
        }
    }

    private ParameterGroup createParameterType(DynamicParameter parameter) {
        ParameterTypeString type;
        String name = parameter.getName();
        String parameterType = parameter.getType() == null ? "string" : parameter.getType();
        Object value = parameter.getValue();
        if ("attributes".equals(parameterType)) {
            return new TableSelectorGroup(name, value.toString());
        }
        String description = parameter.getDescription() == null ? "" : parameter.getDescription();
        switch (parameterType) {
            case "boolean": {
                type = new ParameterTypeBoolean(name, description, (value instanceof Boolean ? (Boolean)value : Boolean.FALSE).booleanValue());
                break;
            }
            case "integer": {
                type = new ParameterTypeInt(name, description, (int)parameter.getMinOrDefault(-2.147483648E9), (int)parameter.getMaxOrDefault(2.147483647E9));
                if (!(value instanceof Number)) break;
                type.setDefaultValue((Object)((Number)value).intValue());
                break;
            }
            case "real": {
                type = new ParameterTypeDouble(name, description, parameter.getMinOrDefault(Double.NEGATIVE_INFINITY), parameter.getMaxOrDefault(Double.POSITIVE_INFINITY));
                if (!(value instanceof Number)) break;
                type.setDefaultValue((Object)((Number)value).doubleValue());
                break;
            }
            case "category": {
                String[] categories = parameter.getCategories().toArray(new String[0]);
                int defaultValue = 0;
                if (value != null) {
                    defaultValue = parameter.getCategories().indexOf(value.toString());
                }
                type = new ParameterTypeCategory(name, description, categories, defaultValue);
                break;
            }
            default: {
                type = new ParameterTypeString(name, description);
                if (value == null) break;
                type.setDefaultValue((Object)value.toString());
            }
        }
        type.setOptional(parameter.isOptional());
        type.setExpert(parameter.isAdvanced());
        return new SingleParameterGroup((ParameterType)type);
    }

    protected byte[] compileParametersAsJson(ParameterKeyValue ... additionalParams) throws OperatorException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JsonGenerator generator = JSON.createGenerator((OutputStream)out);){
            generator.writeStartObject();
            for (ParameterKeyValue param : additionalParams) {
                if (param.getSecond() == null) {
                    generator.writeNullField((String)param.getFirst());
                    continue;
                }
                generator.writeStringField((String)param.getFirst(), (String)param.getSecond());
            }
            for (ParameterGroup group : this.dynamicParameters) {
                group.writeValues(generator);
            }
            generator.writeEndObject();
        }
        catch (IOException | NumberFormatException e) {
            throw new OperatorException("Failed to compile parameters as JSON.", (Throwable)e);
        }
        return out.toByteArray();
    }

    public OperatorDeclaration getDeclaration() {
        return this.declaration;
    }

    protected void checkExampleSet(List<IOObject> objects) {
        if (this.getDeclaration().isDropSpecial()) {
            objects.replaceAll(ioo -> {
                if (ioo instanceof ExampleSet) {
                    ExampleSet set = (ExampleSet)((ExampleSet)ioo).clone();
                    set.getAttributes().clearSpecial();
                    return set;
                }
                return ioo;
            });
        }
    }

    protected List<IOObject> checkInputTypes(ScriptRunner scriptRunner) throws UserError {
        List<Class<? extends IOObject>> supportedTypes = scriptRunner.getSupportedTypes();
        InputPorts inputs = this.getInputPorts();
        int nInputs = inputs.getNumberOfPorts();
        ArrayList<IOObject> objects = new ArrayList<IOObject>(nInputs);
        for (int i = 0; i < nInputs; ++i) {
            InputPort port = (InputPort)inputs.getPortByIndex(i);
            objects.add(port.getData(IOObject.class));
        }
        AbstractScriptingLanguageOperator.checkInputTypes(this, objects, inputs, supportedTypes);
        return objects;
    }

    protected void setWrapper(EnvironmentReference wrapper) throws UndefinedParameterError {
        wrapper.setDefaultPython(this.getParameterAsBoolean("use_default_python"));
        if (!wrapper.isDefaultPython()) {
            String manager = this.getParameterAsString("package_manager");
            wrapper.setPackageManager(manager);
            if (manager.equals("conda (anaconda)")) {
                wrapper.setEnvironment(this.getParameterAsString("conda_environment"));
            } else if (manager.equals("virtualenvwrapper")) {
                wrapper.setEnvironment(this.getParameterAsString("venvw_environment"));
            } else {
                wrapper.setEnvironment(this.getParameterAsString("python_binary"));
            }
        }
    }

    static {
        STATIC_PARAMETERS.add(PARAMETER_OPERATOR);
        STATIC_PARAMETERS.add(PARAMETER_EDITABLE);
        STATIC_PARAMETERS.addAll(EnvironmentTools.ENV_MGMT_PARAMETERS);
        INVALID_DEFINITIONS.add(null);
        INVALID_DEFINITIONS.add("");
        INVALID_DEFINITIONS.add("_REMOVED_");
        PORT_TYPES = new HashMap<String, Class<? extends IOObject>>(4);
        PORT_TYPES.put("variable", IOObject.class);
        PORT_TYPES.put("table", IOTable.class);
        PORT_TYPES.put("file", FileObject.class);
        PORT_TYPES.put("connection", ConnectionInformationContainerIOObject.class);
        JSON = new JsonFactory();
    }

    protected class ParameterKeyValue
    extends Pair<String, String> {
        private static final long serialVersionUID = -6643501125256661721L;

        public ParameterKeyValue(String t, String k) {
            super((Object)t, (Object)k);
        }
    }

    private final class TableSelectorGroup
    implements ParameterGroup {
        private final String name;
        private final InputPort port;
        private final TableSubsetSelector selector;
        private final List<ParameterType> types;

        private TableSelectorGroup(String name, String port) {
            this.name = name;
            this.port = (InputPort)PythonOperator.this.getInputPorts().getPortByName(port);
            this.selector = new TableSubsetSelector((Operator)PythonOperator.this, this.port);
            this.types = this.selector.getParameterTypes();
        }

        @Override
        public List<ParameterType> getParameterTypes() {
            return this.types;
        }

        @Override
        public void writeValues(JsonGenerator generator) throws IOException, UserError {
            generator.writeArrayFieldStart(this.name);
            IOTable ioo = (IOTable)this.port.getDataAsOrNull(IOTable.class);
            if (ioo != null) {
                Table table = ioo.getTable();
                Table subset = this.selector.getSubset(table, false);
                for (String label : subset.labels()) {
                    generator.writeString(label);
                }
            }
            generator.writeEndArray();
        }
    }

    private final class SingleParameterGroup
    implements ParameterGroup {
        private final ParameterType type;

        private SingleParameterGroup(ParameterType type) {
            this.type = type;
        }

        @Override
        public List<ParameterType> getParameterTypes() {
            return Collections.singletonList(this.type);
        }

        @Override
        public void writeValues(JsonGenerator generator) throws IOException, UndefinedParameterError {
            String key = this.type.getKey();
            String value = PythonOperator.this.getParameterAsString(key);
            if (value == null) {
                generator.writeNullField(key);
            } else {
                ParameterType single = PythonOperator.this.getParameterType(key);
                if (single instanceof ParameterTypeBoolean) {
                    generator.writeBooleanField(key, Boolean.parseBoolean(value));
                } else if (single instanceof ParameterTypeInt) {
                    generator.writeNumberField(key, Integer.parseInt(value));
                } else if (single instanceof ParameterTypeDouble) {
                    generator.writeNumberField(key, Double.parseDouble(value));
                } else {
                    generator.writeStringField(key, value);
                }
            }
        }
    }

    private static interface ParameterGroup {
        public List<ParameterType> getParameterTypes();

        public void writeValues(JsonGenerator var1) throws IOException, UserError;
    }
}

