/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator;

import com.rapidminer.extension.pythonscripting.definition.ConfigurationTools;
import com.rapidminer.extension.pythonscripting.operator.EnvironmentTools;
import com.rapidminer.extension.pythonscripting.operator.PythonOperator;
import com.rapidminer.extension.pythonscripting.operator.scripting.ScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonScriptingOperator;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.BufferedFileObject;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class PythonTransformer
extends PythonOperator {
    public static final String TYPE = "transformer";
    private static final String ENTRYPOINT;
    private static final String DECLARATION_TEMPLATE;
    private static final String SCRIPT_TEMPLATE;
    private static final Set<String> STATIC_INPUTPORTS;
    private static final Set<String> STATIC_OUTPUTPORTS;

    public PythonTransformer(OperatorDescription description) {
        this(description, true);
    }

    public PythonTransformer(OperatorDescription description, boolean reloadDeclaration) {
        super(description, true);
        if (reloadDeclaration) {
            this.tryReloadDeclaration();
        }
    }

    protected PythonTransformer(OperatorDescription description, String declaration, String definition) {
        this(description, false);
        this.setImmutable(declaration, definition);
    }

    public OperatorVersion[] getIncompatibleVersionChanges() {
        ArrayList<OperatorVersion> versions = new ArrayList<OperatorVersion>(Arrays.asList(super.getIncompatibleVersionChanges()));
        versions.add(PythonScriptingOperator.VERSION_HDF5_DATE_TIME_BUG);
        versions.add(PythonScriptingOperator.VERSION_ARROW_SERIALIZATION);
        return versions.toArray(new OperatorVersion[0]);
    }

    public static Set<String> getStaticInputPorts() {
        return STATIC_INPUTPORTS;
    }

    public static Set<String> getStaticOutputPorts() {
        return STATIC_OUTPUTPORTS;
    }

    public void doWork() throws OperatorException {
        List<IOObject> results;
        try {
            this.reloadDeclaration();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, "python_scripting.loading_json_failed");
        }
        OperatorVersion compatibilityLevel = this.getCompatibilityLevel();
        boolean arrowSerializationUsed = compatibilityLevel.isAbove((VersionNumber)PythonScriptingOperator.VERSION_ARROW_SERIALIZATION);
        ScriptRunner runner = EnvironmentTools.getScriptRunner(this, this.getScript() + ENTRYPOINT, null, false, arrowSerializationUsed);
        List<IOObject> objects = this.checkInputTypes(runner);
        this.checkExampleSet(objects);
        BufferedFileObject parameters = new BufferedFileObject(this.compileParametersAsJson(new PythonOperator.ParameterKeyValue[0]));
        objects.add((IOObject)parameters);
        OutputPorts outputs = this.getOutputPorts();
        int nOutputs = outputs.getNumberOfPorts();
        try {
            results = runner.run(objects, nOutputs);
        }
        catch (UserError e) {
            throw e;
        }
        catch (Exception e) {
            this.checkForStop();
            throw new UserError((Operator)this, (Throwable)e, "python_scripting.python_runner_error");
        }
        if (results.size() != nOutputs) {
            throw new UserError((Operator)this, "python_scripting.mismatching_outputs", new Object[]{nOutputs, results.size()});
        }
        for (int i = 0; i < nOutputs; ++i) {
            OutputPort port = (OutputPort)outputs.getPortByIndex(i);
            port.deliver(results.get(i));
        }
    }

    @Override
    public String getDefaultDeclaration() {
        return DECLARATION_TEMPLATE;
    }

    @Override
    public String getDefaultScript() {
        return SCRIPT_TEMPLATE;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    static {
        STATIC_INPUTPORTS = Collections.emptySet();
        STATIC_OUTPUTPORTS = Collections.emptySet();
        ENTRYPOINT = ConfigurationTools.loadTextFile("scripts/transformer_entrypoint.py");
        DECLARATION_TEMPLATE = ConfigurationTools.loadTextFile("scripts/transformer_declaration_template.json");
        SCRIPT_TEMPLATE = ConfigurationTools.loadTextFile("scripts/transformer_definition_template.py");
    }
}

