/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.utils.ExampleSetBuilder;
import com.rapidminer.example.utils.ExampleSets;
import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.launcher.VersionMismatchException;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonScriptingOperator;
import com.rapidminer.extension.pythonscripting.serialization.ExampleSetEncodedCsvSerializer;
import com.rapidminer.extension.pythonscripting.serialization.SerializationService;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.RepositoryEntryNotFoundException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebServiceProcessor
extends Operator {
    private InputPort fileInputPort = (InputPort)this.getInputPorts().createPort("file");
    private OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("output");
    private static final String TAG_COMMAND = "command";
    private static final String TAG_VERSION = "library_version";
    private static final String TAG_PATH = "path";
    private static final String TAG_DATA = "data";
    private static final String TAG_EXTENSION = "extension";
    private static final String TAG_CONTENT = "content";
    private static final String TAG_SIZE_LIMIT_KB = "size_limit_kb";
    private static final String VALUE_COMMAND_LOAD = "read_resource";
    private static final String VALUE_COMMAND_SAVE = "write_resource";
    private static final String VALUE_COMMAND_DEL = "delete_resource";
    private static final String VALUE_COMMAND_TEST = "test";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String TYPE_MESSAGE = "message";
    private static final String TYPE_VERSION_INFO = "version_info";
    private static final Set<String> ENCODED_EXTENSIONS = new HashSet<String>(Arrays.asList(new ExampleSetEncodedCsvSerializer().getSerializedFileExtensions()));

    public WebServiceProcessor(OperatorDescription description) {
        super(description);
    }

    protected void performAdditionalChecks() {
        this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "python_scripting.repository_service_canvas", new Object[]{this.getName()}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doWork() throws OperatorException {
        FileObject input = (FileObject)this.fileInputPort.getDataOrNull(FileObject.class);
        if (input != null) {
            String content;
            try (InputStream stream = input.openStream();){
                content = Tools.readTextFile((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 302, new Object[]{"InputFileObject", e.toString()});
            }
            JSONObject jsonObj = new JSONObject(content);
            if (!jsonObj.has(TAG_VERSION) || !new VersionNumber(jsonObj.getString(TAG_VERSION)).isAtLeast(new VersionNumber("9.5.0"))) {
                throw new VersionMismatchException("You are using an older version of the 'rapidminer' Python library. Upgrade it to 9.5.0 or newer using the following command: 'pip install --upgrade git+https://github.com/rapidminer/python-rapidminer.git'");
            }
            String command = jsonObj.getString(TAG_COMMAND);
            if (VALUE_COMMAND_LOAD.equals(command)) {
                this.outputPort.deliver(this.loadObject(jsonObj));
                return;
            } else if (VALUE_COMMAND_SAVE.equals(command)) {
                this.outputPort.deliver(this.saveObject(jsonObj));
                return;
            } else if (VALUE_COMMAND_DEL.equals(command)) {
                this.outputPort.deliver(this.deleteObject(jsonObj));
                return;
            } else {
                if (!VALUE_COMMAND_TEST.equals(command)) throw new UserError((Operator)this, "python_scripting.invalid_command", new Object[]{command});
                this.deliverTestOutput();
            }
            return;
        }
        this.deliverTestOutput();
    }

    private void deliverTestOutput() {
        Attribute attr0 = AttributeFactory.createAttribute((String)ATTRIBUTE_TYPE, (int)1);
        Attribute attr1 = AttributeFactory.createAttribute((String)ATTRIBUTE_VALUE, (int)1);
        int message = attr0.getMapping().mapString(TYPE_MESSAGE);
        int versionInfo = attr0.getMapping().mapString(TYPE_VERSION_INFO);
        int actualMessage = attr1.getMapping().mapString("Test succeeded, version: " + PluginInitPythonScripting.getVersion());
        int actualVersion = attr1.getMapping().mapString(PluginInitPythonScripting.getVersion());
        this.outputPort.deliver((IOObject)ExampleSets.from((Attribute[])new Attribute[]{attr0, attr1}).addRow(new double[]{message, actualMessage}).addRow(new double[]{versionInfo, actualVersion}).build());
    }

    private ExampleSet versionInfoResponse() {
        Attribute attr0 = AttributeFactory.createAttribute((String)ATTRIBUTE_TYPE, (int)1);
        Attribute attr1 = AttributeFactory.createAttribute((String)ATTRIBUTE_VALUE, (int)1);
        int versionInfo = attr0.getMapping().mapString(TYPE_VERSION_INFO);
        int actualVersion = attr1.getMapping().mapString(PluginInitPythonScripting.getVersion());
        return ExampleSets.from((Attribute[])new Attribute[]{attr0, attr1}).addRow(new double[]{versionInfo, actualVersion}).build();
    }

    private IOObjectEntry getRepositoryEntry(String path) throws RepositoryException, UserError {
        RepositoryLocation location = RepositoryLocation.getRepositoryLocationData((String)path, (Operator)this, IOObjectEntry.class);
        location.setFailIfDuplicateIOObjectExists(true);
        IOObjectEntry entry = (IOObjectEntry)location.locateData();
        if (entry == null) {
            throw new RepositoryEntryNotFoundException("Entry '" + location + "' does not exist.");
        }
        return entry;
    }

    private void setRepositoryEntry(IOObject ioObject, String path) throws UserError {
        try {
            RepositoryLocation location = RepositoryLocation.getRepositoryLocationData((String)path, (Operator)this, IOObjectEntry.class);
            RepositoryManager.getInstance(null).store(ioObject, location, (Operator)this);
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, 315, new Object[]{path, e.getMessage()});
        }
    }

    private IOObject loadObject(JSONObject json) throws OperatorException {
        String path = json.getString(TAG_PATH);
        long sizeLimitKb = json.getLong(TAG_SIZE_LIMIT_KB);
        try {
            IOObjectEntry entry = this.getRepositoryEntry(path);
            if (entry.getSize() > sizeLimitKb * 1024L) {
                throw new UserError((Operator)this, "python_scripting.size_limit", new Object[]{sizeLimitKb, TAG_SIZE_LIMIT_KB});
            }
            this.checkForStop();
            IOObject res = entry.retrieveData(null);
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            attrs.add(AttributeFactory.createAttribute((String)TAG_EXTENSION, (int)1));
            attrs.add(AttributeFactory.createAttribute((String)TAG_CONTENT, (int)1));
            boolean arrowSerializationUsed = this.getCompatibilityLevel().isAbove((VersionNumber)PythonScriptingOperator.VERSION_ARROW_SERIALIZATION);
            String[] extensions = SerializationService.getInstance().getSerializedFileExtensionsForResource(res, arrowSerializationUsed);
            OutputStream[] bos = new ByteArrayOutputStream[extensions.length];
            for (int i = 0; i < extensions.length; ++i) {
                bos[i] = new ByteArrayOutputStream();
            }
            try {
                SerializationService.getInstance().serialize(res, SerializationService.getInstance().getSerializedFileExtensionsForResource(res, arrowSerializationUsed)[0], bos, this);
            }
            catch (IOException e1) {
                throw new OperatorException("Internal error: could not serialize data set.", (Throwable)e1);
            }
            ExampleSetBuilder builder = ExampleSets.from(attrs);
            for (int i = 0; i < extensions.length; ++i) {
                int contentValue;
                int extensionValue = ((Attribute)attrs.get(0)).getMapping().mapString(extensions[i]);
                try {
                    String contentStr = !ENCODED_EXTENSIONS.contains(extensions[i]) ? new String(Base64.getEncoder().encode(((ByteArrayOutputStream)bos[i]).toByteArray()), StandardCharsets.UTF_8) : ((ByteArrayOutputStream)bos[i]).toString(StandardCharsets.UTF_8.name());
                    contentValue = ((Attribute)attrs.get(1)).getMapping().mapString(contentStr);
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                    throw new RuntimeException(e1);
                }
                builder.addRow(new double[]{extensionValue, contentValue});
            }
            int versionInfo = ((Attribute)attrs.get(0)).getMapping().mapString(TYPE_VERSION_INFO);
            int actualVersion = ((Attribute)attrs.get(1)).getMapping().mapString(PluginInitPythonScripting.getVersion());
            builder.addRow(new double[]{versionInfo, actualVersion});
            res = builder.build();
            res.getAnnotations().setAnnotation("Source", entry.getLocation().toString());
            return res;
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, 312, new Object[]{path, e.getMessage()});
        }
    }

    private IOObject saveObject(JSONObject json) throws OperatorException {
        IOObject res;
        String path = json.getString(TAG_PATH);
        JSONArray payload = json.getJSONArray(TAG_DATA);
        if (payload.length() < 1) {
            LogService.getRoot().info("Empty input dataset.");
            return this.versionInfoResponse();
        }
        HashMap<String, InputStream> bos = new HashMap<String, InputStream>();
        for (int i = 0; i < payload.length(); ++i) {
            this.checkForStop();
            JSONObject jsonRow = payload.getJSONObject(i);
            String extensionValue = jsonRow.getString(TAG_EXTENSION);
            String contentValue = jsonRow.getString(TAG_CONTENT);
            try {
                byte[] content = contentValue.getBytes(StandardCharsets.UTF_8.name());
                if (!ENCODED_EXTENSIONS.contains(extensionValue)) {
                    content = Base64.getDecoder().decode(content);
                }
                bos.put(extensionValue, new ByteArrayInputStream(content));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        try {
            res = SerializationService.getInstance().deserialize(bos, SerializationService.getInstance().getSupportedFormat((String)bos.keySet().iterator().next()), this);
        }
        catch (IOException e) {
            throw new OperatorException("Could not deserialize input.", (Throwable)e);
        }
        this.setRepositoryEntry(res, path);
        return this.versionInfoResponse();
    }

    private IOObject deleteObject(JSONObject json) throws OperatorException {
        IOObjectEntry locateEntry;
        String path = json.getString(TAG_PATH);
        try {
            locateEntry = this.getRepositoryEntry(path);
            this.checkForStop();
        }
        catch (RepositoryEntryNotFoundException e) {
            LogService.getRoot().finer("Repository entry does not exist, no need for deletion: " + path);
            return this.versionInfoResponse();
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, 312, new Object[]{path, e.getMessage()});
        }
        try {
            locateEntry.delete();
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, "io.delete_file", new Object[]{locateEntry});
        }
        return this.versionInfoResponse();
    }
}

