/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting;

import com.rapidminer.extension.pythonscripting.operator.OperatorSentinel;
import com.rapidminer.extension.pythonscripting.operator.scripting.ScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonScriptingOperator;
import com.rapidminer.extension.pythonscripting.serialization.MacrosIOObject;
import com.rapidminer.extension.pythonscripting.serialization.SerializationService;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.tools.LogService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class AbstractScriptRunner
implements ScriptRunner {
    private static final String INPUT_FILE_PREFIX = "rapidminer_input";
    private static final String OUTPUT_FILE_PATTERN = "rapidminer_output[0-9]{3}\\..*";
    private static final String ERROR_FILE_NAME = "rapidminer_error.log";
    private Logger logger;
    private final String script;
    private Process process;
    private final Operator operator;

    protected AbstractScriptRunner(String script, Operator operator) {
        Objects.requireNonNull(operator);
        this.script = script;
        this.operator = operator;
    }

    protected abstract Process startScriptExecutionProcess(Path var1, int var2) throws IOException, UserError;

    protected abstract void handleLanguageSpecificExitCode(int var1, String var2) throws UserError;

    protected abstract String getUserscriptFilename();

    @Override
    public void registerLogger(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected Operator getOperator() {
        return this.operator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IOObject> run(List<IOObject> inputs, int outputPortCount) throws IOException, OperatorException {
        Path workingDirectory = null;
        try {
            workingDirectory = Files.createTempDirectory("scripting", new FileAttribute[0]);
            this.serializeInputs(inputs, workingDirectory);
            this.writeUserScriptToFile(workingDirectory);
            this.process = this.startScriptExecutionProcess(workingDirectory, outputPortCount);
            try (OperatorSentinel.Sentinel ignored = OperatorSentinel.scheduleSentinel(this.operator, this::cancel);){
                int exitCode = this.process.waitFor();
                this.handleProcessExitCode(exitCode, workingDirectory);
            }
            catch (InterruptedException e) {
                this.handleProcessInterruption();
            }
            List<IOObject> list = this.deserializeResults(workingDirectory);
            return list;
        }
        finally {
            this.deleteWorkingDirectory(workingDirectory);
        }
    }

    @Override
    public void cancel() {
        if (this.process != null) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void serializeInputs(List<IOObject> inputs, Path workingDirectory) throws IOException, UserError, ProcessStoppedException {
        int uniqueFileNameIndex = 0;
        for (IOObject input : inputs) {
            Path inputFilePath = this.generateInputFilePath(workingDirectory, uniqueFileNameIndex, this.getFileExtension(input));
            try {
                SerializationService.getInstance().serialize(input, "file:" + inputFilePath.toAbsolutePath(), this.operator);
            }
            catch (MalformedRepositoryLocationException | RepositoryException e) {
                this.logger.warning("Unexpected repository-related error during serialization: " + e.getMessage());
            }
            this.operator.checkForStop();
            ++uniqueFileNameIndex;
        }
    }

    protected List<IOObject> deserializeResults(Path workingDirectory) throws IOException, UserError, ProcessStoppedException {
        LinkedList<Path> outputFiles = new LinkedList<Path>();
        Pattern outputFilePattern = Pattern.compile(OUTPUT_FILE_PATTERN);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(workingDirectory);){
            for (Path entry : stream) {
                if (!outputFilePattern.matcher(entry.getFileName().toString()).matches()) continue;
                outputFiles.add(entry);
            }
        }
        outputFiles.sort(Comparator.comparing(path -> path.getFileName().toString()));
        LinkedList<IOObject> outputs = new LinkedList<IOObject>();
        for (Path outputFile : outputFiles) {
            IOObject deserializedObject = this.deserializeOutputFile(outputFile);
            if (deserializedObject != null) {
                this.handleMacrosIOObject(deserializedObject);
                outputs.add(deserializedObject);
            }
            this.operator.checkForStop();
        }
        return outputs;
    }

    protected String getFileExtension(IOObject object) {
        boolean arrowSerializationUsed = this.operator.getCompatibilityLevel().isAbove((VersionNumber)PythonScriptingOperator.VERSION_ARROW_SERIALIZATION);
        return SerializationService.getInstance().getSerializedFileExtensionsForResource(object, arrowSerializationUsed)[0];
    }

    private IOObject deserializeOutputFile(Path outputFile) throws IOException, UserError, ProcessStoppedException {
        try {
            return SerializationService.getInstance().deserialize("file:" + outputFile.toAbsolutePath(), this.operator);
        }
        catch (MalformedRepositoryLocationException | RepositoryException e) {
            this.logger.warning("Unexpected error during deserialization: " + e.getMessage());
            return null;
        }
    }

    private void handleMacrosIOObject(IOObject object) {
        if (object instanceof MacrosIOObject) {
            MacrosIOObject macros = (MacrosIOObject)object;
            macros.setOperator(this.operator);
            macros.updateDefinedMacros();
        }
    }

    private Path generateInputFilePath(Path workingDirectory, int index, String fileExtension) {
        String fileName = INPUT_FILE_PREFIX + String.format("%03d", index) + "." + fileExtension;
        return Paths.get(workingDirectory.toString(), fileName);
    }

    private void deleteEntry(Path entry) {
        try {
            if (Files.isDirectory(entry, new LinkOption[0])) {
                this.deleteWorkingDirectory(entry);
            } else {
                Files.delete(entry);
            }
        }
        catch (IOException | SecurityException e) {
            this.logger.warning(String.format("Failed to delete entry '%s': %s", entry.toAbsolutePath(), e.getMessage()));
        }
    }

    private void handleProcessExitCode(int exitCode, Path tempFolder) throws OperatorException {
        if (exitCode == 143) {
            LogService.getRoot().info("Python process has been killed.");
            throw new ProcessStoppedException(this.operator);
        }
        if (exitCode != 0) {
            String errorString = this.getError(tempFolder);
            this.handleLanguageSpecificExitCode(exitCode, errorString);
            if (errorString.isEmpty()) {
                throw new OperatorException(OperatorException.getErrorMessage((String)"python_scripting.script_failed", (Object[])new Object[0]));
            }
            throw new OperatorException(OperatorException.getErrorMessage((String)"python_scripting.script_failed_message", (Object[])new Object[]{errorString}));
        }
    }

    private void handleProcessInterruption() throws CancellationException {
        Thread.currentThread().interrupt();
        this.cancel();
        throw new CancellationException();
    }

    private String getError(Path workingDirectory) {
        Path errorFilePath = Paths.get(workingDirectory.toString(), ERROR_FILE_NAME);
        try {
            byte[] fileContent = Files.readAllBytes(errorFilePath);
            return new String(fileContent, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return "";
        }
    }

    private void deleteWorkingDirectory(Path workingDirectory) {
        if (workingDirectory == null) {
            return;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(workingDirectory);){
            for (Path entry : directoryStream) {
                this.deleteEntry(entry);
            }
        }
        catch (IOException e) {
            this.logger.warning(String.format("Failed to delete contents of temp folder '%s': %s", workingDirectory.toAbsolutePath(), e.getMessage()));
        }
        try {
            Files.delete(workingDirectory);
        }
        catch (IOException | SecurityException e) {
            this.logger.warning(String.format("Failed to delete temp folder '%s': %s", workingDirectory.toAbsolutePath(), e.getMessage()));
        }
    }

    private void writeUserScriptToFile(Path workingDirectory) throws IOException {
        Path scriptFilePath = Paths.get(workingDirectory.toString(), this.getUserscriptFilename());
        Files.write(scriptFilePath, this.script.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

