/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.gui.dialog.CodeCell;
import com.rapidminer.extension.pythonscripting.gui.dialog.IpynbFileMultipleCodeCellModel;
import com.rapidminer.extension.pythonscripting.gui.dialog.MultipleCodeCellModel;
import com.rapidminer.extension.pythonscripting.gui.dialog.MultipleCodeCellsPropertyDialog;
import com.rapidminer.extension.pythonscripting.gui.dialog.PythonFileMultipleCodeCellModel;
import com.rapidminer.extension.pythonscripting.operator.scripting.ScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.metadata.MetaDataCachingRule;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.wizards.PreviewCreator;
import com.rapidminer.gui.wizards.PreviewListener;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.error.ParameterError;
import com.rapidminer.operator.nio.file.BinaryEntryFileObject;
import com.rapidminer.operator.nio.file.FileInputPortHandler;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypePreview;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.OrParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.RepositoryLocationBuilder;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.usagestats.ActionStatisticsCollector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import org.json.JSONException;

public abstract class AbstractScriptingLanguageOperator
extends Operator {
    protected static final String UNKNOWN_EXTENSION = "unknown";
    private static final String PARAMETER_SCRIPT_FILE = "script_file";
    private static final String PARAMETER_VIEW_SCRIPT = "view_script";
    private final InputPort scriptInputPort = (InputPort)this.getInputPorts().createPort("script file");
    private final FileInputPortHandler scriptInputHandler = new FileInputPortHandler((Operator)this, this.scriptInputPort, "script_file");
    private final InputPortExtender inExtender = new InputPortExtender("input", (Ports)this.getInputPorts());
    private final OutputPortExtender outExtender = new OutputPortExtender("output", (Ports)this.getOutputPorts());
    private final MetaDataCachingRule cachingRule = new MetaDataCachingRule(this);

    public AbstractScriptingLanguageOperator(OperatorDescription description) {
        super(description);
        this.inExtender.start();
        this.outExtender.start();
        if (!RapidMiner.getExecutionMode().isHeadless()) {
            this.getTransformer().addRule(this::showSetupProblems);
            this.getTransformer().addRule((MDTransformationRule)this.cachingRule);
        }
    }

    protected synchronized void showSetupProblems() {
        this.clear(9);
        this.logScriptInputType();
        try {
            if (this.isFileSpecified() && !this.scriptInputPort.isConnected() && !Paths.get(this.getFileName(), new String[0]).toFile().exists()) {
                ArrayList<ParameterSettingQuickFix> fixes = new ArrayList<ParameterSettingQuickFix>();
                fixes.add(new ParameterSettingQuickFix((Operator)this, PARAMETER_SCRIPT_FILE));
                this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), fixes, "python_scripting.script_not_exists", new Object[]{this.getParameter(PARAMETER_SCRIPT_FILE)}));
            }
        }
        catch (OperatorException e) {
            LogService.getRoot().severe("Error while validating operator '" + this.getName() + "': " + e.getMessage());
        }
    }

    protected abstract ScriptRunner getScriptRunner() throws IOException, OperatorException;

    protected UserError getUserError(IOException e) {
        if (e.getCause() instanceof JSONException) {
            if (this.isFileSpecified()) {
                return new ParameterError((Operator)this, "python_scripting.nb_error", PARAMETER_VIEW_SCRIPT, new Object[]{e.getCause().getMessage()});
            }
            return new UserError((Operator)this, (Throwable)e, "python_scripting.nb_error", new Object[]{e.getCause().getMessage()});
        }
        if (this.isFileSpecified()) {
            return new ParameterError((Operator)this, "python_scripting.io_error", PARAMETER_SCRIPT_FILE, new Object[]{e.getMessage()});
        }
        return new UserError((Operator)this, (Throwable)e, "python_scripting.io_error", new Object[]{e.getMessage()});
    }

    public void doWork() throws OperatorException {
        ScriptRunner scriptRunner;
        try {
            scriptRunner = this.getScriptRunner();
        }
        catch (IOException e) {
            throw this.getUserError(e);
        }
        List<IOObject> inputs = this.checkInputTypes(scriptRunner);
        int numberOfOutputPorts = this.outExtender.getManagedPorts().size() - 1;
        try {
            List<IOObject> outputs = scriptRunner.run(inputs, numberOfOutputPorts);
            this.outExtender.deliver(outputs);
            this.cachingRule.setOperatorWorked();
        }
        catch (CancellationException e) {
            this.checkForStop();
            throw new UserError((Operator)this, (Throwable)e, "python_scripting.execution_interruption", new Object[0]);
        }
        catch (IOException e) {
            throw this.getUserError(e);
        }
    }

    public List<ParameterType> getParameterTypes() {
        List parameterTypes = super.getParameterTypes();
        ParameterTypeText scriptParameter = new ParameterTypeText(this.getScriptParameterName(), this.getScriptParameterDescription(), this.getScriptParameterTextType(), this.getScriptParameterTemplateScript());
        parameterTypes.add(scriptParameter);
        ParameterTypePreview viewScriptParameter = new ParameterTypePreview(PARAMETER_VIEW_SCRIPT, "Show contents of script file", ScriptPreviewer.class, (PreviewListener)this);
        viewScriptParameter.setExpert(false);
        parameterTypes.add(viewScriptParameter);
        ParameterTypeFile scriptFileParameter = new ParameterTypeFile(PARAMETER_SCRIPT_FILE, "A file containing an executable script", true, this.getScriptFileExtensions()){
            private static final long serialVersionUID = 1724272769993964554L;

            public String[] getKeys() {
                return new String[]{"Script file", "Notebook file"};
            }
        };
        scriptFileParameter.setAddAllFileExtensionsFilter(true);
        scriptFileParameter.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, () -> this.scriptInputPort, false, false));
        scriptFileParameter.setExpert(false);
        scriptFileParameter.setOptional(true);
        scriptFileParameter.setPrimary(true);
        scriptParameter.registerDependencyCondition(new ParameterCondition((ParameterHandler)this, true){

            public boolean isConditionFullfilled() {
                return !AbstractScriptingLanguageOperator.this.hasScriptFile();
            }
        });
        scriptParameter.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, () -> this.scriptInputPort, true, false));
        ParameterCondition paraCondition = new ParameterCondition((ParameterHandler)this, false){

            public boolean isConditionFullfilled() {
                return AbstractScriptingLanguageOperator.this.hasScriptFile();
            }
        };
        PortConnectedCondition portCondition = new PortConnectedCondition((ParameterHandler)this, () -> this.scriptInputPort, false, true);
        viewScriptParameter.registerDependencyCondition((ParameterCondition)new OrParameterCondition((ParameterHandler)this, false, new ParameterCondition[]{paraCondition, portCondition}));
        parameterTypes.add(scriptFileParameter);
        return parameterTypes;
    }

    public void setParameterScriptFile(Path file) throws OperatorException {
        if (this.scriptInputPort.isConnected()) {
            throw new OperatorException("Cannot set script file parameter if script input port is connected!");
        }
        this.setParameter(PARAMETER_SCRIPT_FILE, file.toAbsolutePath().toString());
    }

    private boolean hasScriptFile() {
        try {
            return this.getParameterAsFile(PARAMETER_SCRIPT_FILE) != null;
        }
        catch (UserError userError) {
            return false;
        }
    }

    protected abstract String getSelectedNotebookTagsRegexp();

    protected abstract void setSelectedNotebookTagsRegexp(String var1);

    protected abstract String getNotebook(Reader var1) throws IOException;

    protected boolean isFileSpecified() {
        return this.scriptInputHandler.isFileSpecified() || this.scriptInputPort.isConnected();
    }

    private String getFileFormat(String fileName) {
        int lastIndex = fileName.lastIndexOf(46);
        if (lastIndex < 0) {
            return "";
        }
        return fileName.substring(lastIndex);
    }

    protected String getFileFormat() throws OperatorException {
        if (this.scriptInputPort.isConnected()) {
            String source = this.getSourceFromMetaData();
            if (source == null) {
                return UNKNOWN_EXTENSION;
            }
            return this.getFileFormat(source);
        }
        if (this.scriptInputHandler.isFileSpecified()) {
            return this.getFileFormat(this.scriptInputHandler.getSelectedFile().getAbsolutePath());
        }
        throw new OperatorException("No script file is specified.");
    }

    protected String getFileName() throws OperatorException {
        if (!this.isFileSpecified()) {
            throw new OperatorException("No script is specified.");
        }
        if (this.scriptInputPort.isConnected()) {
            FileObject file = (FileObject)this.scriptInputPort.getDataAsOrNull(FileObject.class);
            if (file != null) {
                return file.getFile().getAbsolutePath();
            }
            String source = this.getSourceFromMetaData();
            if (source != null) {
                return AbstractScriptingLanguageOperator.getFileFromSource(source).getAbsolutePath();
            }
            throw new OperatorException("Cannot retrieve file name.");
        }
        return this.scriptInputHandler.getSelectedFile().getAbsolutePath();
    }

    private String getScript(File file) throws IOException {
        File originalFile = file;
        if (this.scriptInputPort.isConnected()) {
            try {
                FileObject fo = (FileObject)this.scriptInputPort.getDataOrNull(FileObject.class);
                if (fo.getAnnotations().containsKey((Object)"Source")) {
                    originalFile = new File(fo.getAnnotations().get((Object)"Source"));
                }
            }
            catch (UserError fo) {
                // empty catch block
            }
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), PluginInitPythonScripting.getExtensionDefaultEncoding());){
            String string = this.getScriptFromReader(reader, originalFile.getName());
            return string;
        }
    }

    private String getScriptFromReader(Reader reader, String originalFileName) throws IOException {
        if (originalFileName.endsWith(".ipynb")) {
            ActionStatisticsCollector.getInstance().log("python", "script_load", "ipynb");
            LogService.getRoot().log(Level.FINEST, "Loading script file with .ipynb extension.");
            return this.getNotebook(reader);
        }
        if (originalFileName.endsWith(".py")) {
            ActionStatisticsCollector.getInstance().log("python", "script_load", "py");
            LogService.getRoot().log(Level.FINEST, "Loading script file with .py extension.");
        } else {
            ActionStatisticsCollector.getInstance().log("python", "script_load", UNKNOWN_EXTENSION);
            LogService.getRoot().log(Level.WARNING, "File '" + originalFileName + "' is neither a .py or .ipynb file, handling as python code with .py extension. ");
        }
        return Tools.readTextFile((Reader)reader);
    }

    protected String getScriptFromOriginalFile(File file) throws IOException {
        return this.getScriptFromReader(new InputStreamReader((InputStream)new FileInputStream(file), PluginInitPythonScripting.getExtensionDefaultEncoding()), file.getName());
    }

    protected boolean isScriptPortConnected() {
        return this.scriptInputPort.isConnected();
    }

    protected String getScript(boolean forceGet) throws IOException {
        boolean fileSpecified = this.scriptInputHandler.isFileSpecified();
        if (!(fileSpecified && forceGet || !this.scriptInputPort.isConnected())) {
            return I18N.getGUILabel((String)(Boolean.parseBoolean(ParameterService.getParameterValue((String)"rapidminer.gui.validate_automatically")) ? "scripting.port_file" : "scripting.port_file_no_validate"), (Object[])new Object[0]);
        }
        if (fileSpecified) {
            File selectedFile;
            try {
                selectedFile = this.scriptInputHandler.getSelectedFile();
            }
            catch (OperatorException e) {
                throw new IOException(e);
            }
            return this.getScript(selectedFile);
        }
        try {
            return this.getParameters().getParameter(this.getScriptParameterName());
        }
        catch (UndefinedParameterError undefinedParameterError) {
            throw new IOException("Undefined parameter error:", undefinedParameterError);
        }
    }

    private String getSourceFromMetaData() {
        MetaData md = this.scriptInputPort.getRawMetaData();
        if (md != null) {
            return md.getAnnotations().getAnnotation("Source");
        }
        return null;
    }

    private static File getFileFromSource(String source) throws OperatorException {
        return new BinaryEntryFileObject(new RepositoryLocationBuilder().withExpectedDataEntryType(BinaryEntry.class).buildFromAbsoluteLocation(source)).getFile();
    }

    protected String getScriptAndReplaceMacros(boolean forceGet) throws IOException, UndefinedParameterError {
        return this.replaceMacros(this.getScript(forceGet));
    }

    protected abstract String getScriptParameterName();

    protected abstract String getScriptParameterDescription();

    protected abstract TextType getScriptParameterTextType();

    protected abstract String getScriptParameterTemplateScript();

    protected abstract String[] getScriptFileExtensions();

    protected String getScriptSourceTypeForLogging() throws IOException {
        if (this.scriptInputHandler.isFileSpecified()) {
            try {
                File selectedFile = this.scriptInputHandler.getSelectedFile();
                if (selectedFile.getName().endsWith(".ipynb")) {
                    return "file_ipynb";
                }
                if (selectedFile.getName().endsWith(".py")) {
                    return "file_py";
                }
                return "file_unknown";
            }
            catch (OperatorException e) {
                throw new IOException(e);
            }
        }
        return "editor";
    }

    protected String replaceMacros(String value) throws UndefinedParameterError {
        Process p = this.getProcess();
        if (p != null) {
            String intermediate = p.getMacroHandler().resolveMacros("", value);
            return p.getMacroHandler().resolvePredefinedMacros(intermediate, (Operator)this);
        }
        return value;
    }

    protected List<IOObject> checkInputTypes(ScriptRunner scriptRunner) throws UserError {
        List<Class<? extends IOObject>> supportedTypes = scriptRunner.getSupportedTypes();
        List inputs = this.inExtender.getData(IOObject.class, false);
        AbstractScriptingLanguageOperator.checkInputTypes(this, inputs, this.getInputPorts(), supportedTypes);
        return inputs;
    }

    public static void checkInputTypes(Operator operator, List<IOObject> inputs, InputPorts inputPorts, List<Class<? extends IOObject>> supportedTypes) throws UserError {
        for (int index = 0; index < inputs.size(); ++index) {
            IOObject input = inputs.get(index);
            boolean isSupported = false;
            for (Class<? extends IOObject> type : supportedTypes) {
                if (!type.isInstance(input)) continue;
                isSupported = true;
                break;
            }
            if (isSupported) continue;
            throw new UserError(operator, "python_scripting.wrong_input", new Object[]{RendererService.getName(input.getClass()), inputPorts.getPortNames()[index]});
        }
    }

    private void logScriptInputType() {
        if (this.scriptInputPort.isConnected()) {
            LogService.getRoot().finest("The Python code is obtained via the script input port in operator ' " + this.getName() + "'.");
        } else if (this.isFileSpecified()) {
            LogService.getRoot().finest("The Python code is obtained via the script file parameter in operator ' " + this.getName() + "'.");
        } else {
            LogService.getRoot().finest("The Python code is obtained via the script text parameter in operator ' " + this.getName() + "'.");
        }
    }

    public static class ScriptPreviewer
    implements PreviewCreator {
        public void createPreview(PreviewListener listener) {
            if (!(listener instanceof AbstractScriptingLanguageOperator)) {
                return;
            }
            try {
                MultipleCodeCellModel model;
                String tags;
                AbstractScriptingLanguageOperator operator;
                block12: {
                    operator = (AbstractScriptingLanguageOperator)listener;
                    String scriptFile = operator.getParameter(AbstractScriptingLanguageOperator.PARAMETER_SCRIPT_FILE);
                    tags = "";
                    if (operator.scriptInputPort.isConnected()) {
                        model = new PythonFileMultipleCodeCellModel(() -> new StringReader(operator.getScript(false)));
                        String source = operator.getSourceFromMetaData();
                        if (source != null) {
                            try {
                                File realScriptFile = AbstractScriptingLanguageOperator.getFileFromSource(source);
                                CodeCell.InputSupplier is = () -> new InputStreamReader((InputStream)new FileInputStream(realScriptFile), PluginInitPythonScripting.getExtensionDefaultEncoding());
                                if (source.endsWith(".ipynb")) {
                                    model = new IpynbFileMultipleCodeCellModel(is);
                                    tags = operator.getSelectedNotebookTagsRegexp();
                                    break block12;
                                }
                                model = new PythonFileMultipleCodeCellModel(is);
                            }
                            catch (OperatorException e) {
                                LogService.getRoot().fine(() -> String.format("Error while trying to read script from the input port: %s", e.getMessage()));
                            }
                        }
                    } else if (scriptFile.endsWith(".ipynb")) {
                        model = new IpynbFileMultipleCodeCellModel(() -> new InputStreamReader((InputStream)new FileInputStream(scriptFile), PluginInitPythonScripting.getExtensionDefaultEncoding()));
                        tags = operator.getSelectedNotebookTagsRegexp();
                    } else {
                        model = new PythonFileMultipleCodeCellModel(() -> new InputStreamReader((InputStream)new FileInputStream(scriptFile), PluginInitPythonScripting.getExtensionDefaultEncoding()));
                    }
                }
                MultipleCodeCellsPropertyDialog dialog = new MultipleCodeCellsPropertyDialog(operator.getScriptParameterTextType(), model, tags);
                dialog.setVisible(true);
                if (dialog.areTagsEdited() && dialog.isOk()) {
                    operator.setSelectedNotebookTagsRegexp(dialog.getTagsRegex());
                }
            }
            catch (UndefinedParameterError e) {
                LogService.getRoot().finest("Error while opening script preview: " + e.getMessage());
            }
        }
    }
}

