/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InputStreamLogger {
    private InputStreamLogger() {
    }

    public static void log(InputStream stream, Logger logger) {
        Runnable outputReader = () -> {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    logger.log(Level.INFO, line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        Thread outputReaderThread = new Thread(outputReader);
        outputReaderThread.setDaemon(true);
        outputReaderThread.start();
    }
}

