/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.metadata;

import com.rapidminer.Process;
import com.rapidminer.ProcessStateListener;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class MetaDataCachingRule
implements MDTransformationRule {
    private final Operator operator;
    private List<MetaData> cachedMetaData;
    private Set<Integer> noDataCache;
    private boolean cacherAdded;
    private boolean cachedInProcess;
    private boolean operatorWorked;

    public MetaDataCachingRule(Operator operator) {
        this.operator = operator;
    }

    public void setOperatorWorked() {
        this.operatorWorked = true;
    }

    public void transformMD() {
        if (!this.cacherAdded && this.operator.getProcess() != null) {
            this.addCacher();
            this.cacherAdded = true;
        }
        if (this.cachedMetaData == null) {
            this.operator.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.INFORMATION, this.operator.getPortOwner(), "python_scripting.metadata.cache_empty", new Object[0]));
        } else {
            List outputPorts = this.operator.getOutputPorts().getAllPorts();
            int index = 0;
            for (OutputPort port : outputPorts) {
                this.tryToDeliverMetaData(index, port);
                ++index;
            }
        }
    }

    private void tryToDeliverMetaData(int index, OutputPort port) {
        if (port.isConnected()) {
            if (index < this.cachedMetaData.size()) {
                MetaData md = this.cachedMetaData.get(index);
                if (md != null) {
                    port.deliverMD(md);
                } else if (this.noDataCache != null && this.noDataCache.contains(index)) {
                    this.operator.addError((ProcessSetupError)new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)port, "python_scripting.no_data", new Object[0]));
                } else {
                    this.operator.addError((ProcessSetupError)new SimpleMetaDataError(ProcessSetupError.Severity.INFORMATION, (Port)port, "python_scripting.cache_empty", new Object[0]));
                }
            } else {
                this.operator.addError((ProcessSetupError)new SimpleMetaDataError(ProcessSetupError.Severity.INFORMATION, (Port)port, "python_scripting.cache_empty", new Object[0]));
            }
        }
    }

    private void addCacher() {
        this.operator.getProcess().addProcessStateListener(new ProcessStateListener(){

            public void stopped(Process process) {
                if (!MetaDataCachingRule.this.cachedInProcess) {
                    MetaDataCachingRule.this.cacheMetaData();
                }
            }

            public void started(Process process) {
                MetaDataCachingRule.this.cachedInProcess = false;
                MetaDataCachingRule.this.operatorWorked = false;
            }

            public void resumed(Process process) {
            }

            public void paused(Process process) {
                if (MetaDataCachingRule.this.operatorWorked && !MetaDataCachingRule.this.cachedInProcess) {
                    MetaDataCachingRule.this.cacheMetaData();
                    MetaDataCachingRule.this.cachedInProcess = true;
                }
            }
        });
    }

    private void cacheMetaData() {
        this.cachedMetaData = new ArrayList<MetaData>();
        List outputPorts = this.operator.getOutputPorts().getAllPorts();
        this.noDataCache = new HashSet<Integer>(outputPorts.size());
        int index = 0;
        for (OutputPort port : outputPorts) {
            IOObject object = port.getAnyDataOrNull();
            if (object != null) {
                this.cachedMetaData.add(MetaData.forIOObject((IOObject)object));
            } else {
                if (port.isConnected()) {
                    this.noDataCache.add(index);
                }
                this.cachedMetaData.add(null);
            }
            ++index;
        }
        RapidMinerGUI.getMainFrame().validateProcess(true);
    }
}

