/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.os;

import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonProcessBuilder;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public abstract class OSCommandRunner {
    public abstract String runCondaVersionCommand() throws IOException;

    public abstract String runCondaEnvironmentListCommand() throws IOException;

    public abstract String runVenvwVersionCommand() throws IOException;

    public abstract String runVenvwEnvironmentListCommand() throws IOException;

    public abstract String runPrintWorkonHomeCommand() throws IOException;

    public static String readStream(InputStream stream) {
        return OSCommandRunner.readStream(stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readStream(InputStream stream, String encoding) {
        StringBuilder result = new StringBuilder();
        try (BufferedReader s = encoding != null ? new BufferedReader(new InputStreamReader(stream, encoding)) : new BufferedReader(new InputStreamReader(stream, PluginInitPythonScripting.getExtensionDefaultEncoding()));){
            String line;
            while ((line = s.readLine()) != null) {
                result.append(line);
                result.append("\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toString();
    }

    protected String getOutput(Process p) {
        return this.getOutput(p, null);
    }

    protected String getOutput(Process p, String encoding) {
        String output = OSCommandRunner.readStream(p.getInputStream(), encoding);
        String error = OSCommandRunner.readStream(p.getErrorStream(), encoding);
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            LogService.getRoot().warning("Error during executing process: " + e.getMessage());
            Thread.currentThread().interrupt();
            return "";
        }
        if (output.length() > 0) {
            LogService.getRoot().finer(() -> String.format("The output stream during operating system process execution was: '%s'", output.replace("\\n", " ")));
        }
        if (error.length() > 0) {
            LogService.getRoot().finest(() -> String.format("The error stream during executing operating system execution process was: '%s' Note that a non empty error stream may indicate proper behaviour.", error.replace("\\n", " ")));
        }
        return output;
    }

    protected String getPathEnvVarValue() throws IOException {
        Object res = System.getenv("PATH");
        if (PluginInitPythonScripting.getCurrentSearchPath().length() > 0) {
            res = Tools.unescape((String)PluginInitPythonScripting.getCurrentSearchPath().replaceAll(",", File.pathSeparator)) + File.pathSeparator + (String)res;
        }
        return res;
    }

    protected Process createProcess(List<String> command, String actualCommand) throws IOException {
        PythonProcessBuilder p = new PythonProcessBuilder(command, actualCommand);
        p.environment().put("PATH", this.getPathEnvVarValue());
        LogService.getRoot().finest(String.format("Running external process: '%s'.", command.stream().reduce("", (s1, s2) -> s1 + " " + s2)));
        return p.start();
    }

    protected String createProcessAndGetOutput(List<String> command, String actualCommand) throws IOException {
        Process p = this.createProcess(command, actualCommand);
        return this.getOutput(p);
    }
}

