/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.os;

import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.operator.scripting.os.ShellCommandRunner;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SystemInfoUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class UNIXCommandRunner
extends ShellCommandRunner {
    private static final String UNIQUE_STRING = "%%!!//==";
    private static final Pattern CONTENT_BETWEEN_UNIQUE_STRINGS = Pattern.compile(".*%%!!//==(.*)%%!!//==.*", 32);
    private static final Object LOCK = new Object();
    private volatile RunnerState state = RunnerState.UNITIALIZED;
    private static String additionalSearchPath = "";

    UNIXCommandRunner() {
        if (SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS) {
            throw new IllegalStateException(I18N.getErrorMessage((String)"process.error.python_scripting.unix_commands_windows", (Object[])new Object[0]));
        }
    }

    @Override
    protected List<String> getShellPrefix() {
        return new ArrayList<String>(PluginInitPythonScripting.getShellCommand());
    }

    @Override
    protected List<String> getShellCommand(String command) {
        String fullCommand = String.format("echo '%s' ; %s ; echo '%s' ; exit", UNIQUE_STRING, command, UNIQUE_STRING);
        List<String> result = this.getShellPrefix();
        result.add(fullCommand);
        return result;
    }

    @Override
    protected String createProcessAndGetOutput(List<String> command, String actualCommand) throws IOException {
        String output = super.createProcessAndGetOutput(command, actualCommand);
        return CONTENT_BETWEEN_UNIQUE_STRINGS.matcher(output).replaceFirst("$1").trim();
    }

    protected String createProcessAndGetOutputWithoutShell(String command, String actualCommand) throws IOException {
        List<String> commandList = Arrays.asList(command.trim().replaceAll(" +", " ").split(" "));
        return super.createProcessAndGetOutput(commandList, actualCommand);
    }

    @Override
    public String runCondaVersionCommand() throws IOException {
        return this.createProcessAndGetOutputWithoutShell("conda -V", "conda");
    }

    @Override
    public String runCondaEnvironmentListCommand() throws IOException {
        return this.createProcessAndGetOutputWithoutShell("conda info --json", "conda");
    }

    @Override
    public String runVenvwVersionCommand() throws IOException {
        return this.createProcessAndGetOutput("lsvirtualenv -h", "lsvirtualenv");
    }

    @Override
    public String runVenvwEnvironmentListCommand() throws IOException {
        return this.createProcessAndGetOutput("lsvirtualenv -b", "lsvirtualenv");
    }

    @Override
    public String runPrintWorkonHomeCommand() throws IOException {
        return this.createProcessAndGetOutput("echo $WORKON_HOME", "echo");
    }

    @Override
    protected String getPathEnvVarValue() throws IOException {
        Object path = super.getPathEnvVarValue();
        String aPath = this.getAdditionalSearchPath();
        if (!aPath.isEmpty()) {
            path = (String)path + File.pathSeparator + aPath;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAdditionalSearchPath() {
        if (this.state == RunnerState.INITIALIZING) {
            return "";
        }
        if (this.state == RunnerState.UNITIALIZED) {
            Object object = LOCK;
            synchronized (object) {
                if (this.state == RunnerState.UNITIALIZED) {
                    this.state = RunnerState.INITIALIZING;
                    try {
                        additionalSearchPath = this.createProcessAndGetOutput("echo $PATH", "echo");
                    }
                    catch (IOException e) {
                        additionalSearchPath = "";
                        LogService.getRoot().config("Error while trying to run shell command. You may have configured 'rapidminer.python_scripting.shell_command' property improperly: " + e.getMessage());
                    }
                    this.state = RunnerState.INITIALIZED;
                }
            }
        }
        return additionalSearchPath;
    }

    static enum RunnerState {
        UNITIALIZED,
        INITIALIZING,
        INITIALIZED;

    }
}

