/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.os;

import com.rapidminer.extension.pythonscripting.operator.scripting.os.ShellCommandRunner;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.SystemInfoUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WindowsCommandRunner
extends ShellCommandRunner {
    WindowsCommandRunner() {
        if (SystemInfoUtilities.getOperatingSystem() != SystemInfoUtilities.OperatingSystem.WINDOWS) {
            throw new IllegalStateException(I18N.getErrorMessage((String)"process.error.python_scripting.windows_commands_unix", (Object[])new Object[0]));
        }
    }

    @Override
    protected List<String> getShellPrefix() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("cmd");
        result.add("/C");
        return result;
    }

    @Override
    protected List<String> getShellCommand(String command) {
        List<String> result = this.getShellPrefix();
        result.add(command);
        return result;
    }

    @Override
    public String runCondaVersionCommand() throws IOException {
        return this.createProcessAndGetOutput("conda -V", "conda");
    }

    @Override
    public String runCondaEnvironmentListCommand() throws IOException {
        return this.createProcessAndGetOutput("conda info --json", "conda");
    }

    @Override
    public String runVenvwVersionCommand() throws IOException {
        return this.runVenvwEnvironmentListCommand();
    }

    @Override
    public String runVenvwEnvironmentListCommand() throws IOException {
        return this.createProcessAndGetOutput("lsvirtualenv", "lsvirtualenv");
    }

    @Override
    public String runPrintWorkonHomeCommand() throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("cmd");
        command.add("/U");
        command.add("/C");
        command.add("workon & set WORKON_HOME");
        Process p = this.createProcess(command, "cmd");
        return this.getOutput(p, "UTF-16LE");
    }
}

