/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.python;

import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.connection.ConnectionInformationContainerIOObject;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.operator.scripting.AbstractScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.InputStreamLogger;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonBinarySupplier;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonExitCode;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonNativeObject;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonProcessBuilder;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonScriptingOperator;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.parameter.UndefinedParameterError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PythonArrowScriptRunner
extends AbstractScriptRunner {
    private static final List<Class<? extends IOObject>> SUPPORTED_TYPES = List.of(ExampleSet.class, IOTable.class, PythonNativeObject.class, FileObject.class, ConnectionInformationContainerIOObject.class);
    private static final String ENCODING = "# coding=utf-8\n";
    private static final String FILE_OBJECT_INFO_EXTENSION = "foi";
    private static final String WRAPPER_FILE_NAME = "execute_userscript.py";
    private static final String UTILS_FILE_NAME = "serdeutils.py";
    private static final String PATH_SCRIPT_RESOURCES_DIR = "/com/rapidminer/resources/python/";
    private final PythonBinarySupplier pythonBinarySupplier;
    private final boolean hdf5CompliantDateAndTimeConversion;
    private Path workingDirectory = null;
    private String encryptionKey = null;

    public PythonArrowScriptRunner(String script, Operator operator, PythonBinarySupplier pythonBinarySupplier) {
        this(script, operator, pythonBinarySupplier, operator.getCompatibilityLevel().isAbove((VersionNumber)PythonScriptingOperator.VERSION_HDF5_DATE_TIME_BUG));
    }

    protected PythonArrowScriptRunner(String script, Operator operator, PythonBinarySupplier pythonBinarySupplier, boolean hdf5CompliantDateAndTimeConversion) {
        super(PythonArrowScriptRunner.addEncoding(script), operator);
        this.pythonBinarySupplier = pythonBinarySupplier;
        this.hdf5CompliantDateAndTimeConversion = hdf5CompliantDateAndTimeConversion;
    }

    public void setWorkingDirectory(Path workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    protected void handleLanguageSpecificExitCode(int exitCode, String errorString) throws UserError {
        PythonExitCode code = PythonExitCode.fromExitCode(exitCode);
        if (code != null) {
            throw new UserError(this.getOperator(), code.getUserErrorKey(), (Object[])errorString.split("\n"));
        }
    }

    @Override
    protected String getUserscriptFilename() {
        return "userscript.py";
    }

    @Override
    protected String getFileExtension(IOObject object) {
        if (object instanceof FileObject && !(object instanceof PythonNativeObject)) {
            return FILE_OBJECT_INFO_EXTENSION;
        }
        return super.getFileExtension(object);
    }

    @Override
    public List<Class<? extends IOObject>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    protected Process startScriptExecutionProcess(Path workingDirectory, int outputPortCount) throws IOException, UserError {
        this.prepareWrapperScript(workingDirectory);
        this.prepareUtilsScript(workingDirectory);
        Path pythonBinaryPath = this.getPythonBinaryPath();
        PythonProcessBuilder processBuilder = this.buildPythonProcess(pythonBinaryPath.toString(), workingDirectory, outputPortCount);
        return this.startProcessWithLogging(processBuilder);
    }

    @Override
    protected void serializeInputs(List<IOObject> inputs, Path workingDirectory) throws IOException, UserError, ProcessStoppedException {
        this.getLogger().log(Level.INFO, "Starting serialization of {0} input objects to directory: {1}", new Object[]{inputs.size(), workingDirectory});
        List<IOObject> annotatedInputs = inputs.stream().map(this::annotateIfConnectionInfo).collect(Collectors.toList());
        super.serializeInputs(annotatedInputs, workingDirectory);
    }

    private IOObject annotateIfConnectionInfo(IOObject object) {
        if (object instanceof ConnectionInformationContainerIOObject) {
            ConnectionInformationContainerIOObject clone = ((ConnectionInformationContainerIOObject)object).copy();
            clone.getAnnotations().put("serde-key", this.getEncryptionKey());
            return clone;
        }
        return object;
    }

    private void prepareUtilsScript(Path workingDirectory) throws IOException, PythonScriptRunnerException {
        Object version = PluginInitPythonScripting.getVersion();
        int postFixIndex = ((String)version).indexOf(45);
        if (postFixIndex > 0) {
            version = ((String)version).substring(0, postFixIndex);
        }
        version = "\"" + (String)version + "\"";
        this.writeModifiedScriptToTemp(workingDirectory.toString(), UTILS_FILE_NAME, new String[]{"\\s*__version__\\s*=\\s*(.*)"}, new String[]{version});
    }

    private void prepareWrapperScript(Path workingDirectory) throws IOException, PythonScriptRunnerException {
        this.copyWrapperScript(workingDirectory);
        String requiredPandas = this.hdf5CompliantDateAndTimeConversion ? "\"1.0.0\"" : "\"0.12.0\"";
        String requiredArrow = "\"" + this.getArrowVersion() + "\"";
        this.writeModifiedScriptToTemp(workingDirectory.toString(), WRAPPER_FILE_NAME, new String[]{"__required_pyarrow_version__\\s*=\\s*(.*)", "__required_pandas_version__\\s*=\\s*(.*)"}, new String[]{requiredArrow, requiredPandas});
    }

    private String getArrowVersion() throws IOException {
        try (InputStream input = PythonArrowScriptRunner.class.getResourceAsStream("/version.properties");){
            if (input == null) {
                throw new FileNotFoundException("version.properties file not found in resources.");
            }
            Properties prop = new Properties();
            prop.load(input);
            String version = prop.getProperty("arrow.version");
            if (version == null) {
                throw new IOException("arrow.version property not found in version.properties file.");
            }
            String string = version;
            return string;
        }
    }

    private void copyWrapperScript(Path workingDirectory) throws IOException {
        String resourcePath = "/com/rapidminer/resources/python/execute_userscript.py";
        try (InputStream wrapperStream = PythonArrowScriptRunner.class.getResourceAsStream(resourcePath);){
            if (wrapperStream == null) {
                throw new FileNotFoundException("Wrapper script not found in resources: execute_userscript.py");
            }
            Path destinationPath = workingDirectory.resolve(WRAPPER_FILE_NAME);
            Files.copy(wrapperStream, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private Path getPythonBinaryPath() throws UserError {
        try {
            Path pythonBinaryPath = this.pythonBinarySupplier.getPythonBinary();
            if (pythonBinaryPath == null) {
                String pythonEnvironmentName = this.pythonBinarySupplier.getPythonEnvironmentName();
                pythonEnvironmentName = pythonEnvironmentName != null ? pythonEnvironmentName : "";
                throw new UserError(this.getOperator(), "python_scripting.setup_test_environment.failure", new Object[]{pythonEnvironmentName});
            }
            this.getLogger().log(Level.INFO, "Python environment path obtained successfully: {0}", this.pythonBinarySupplier.getPythonEnvironmentName());
            return pythonBinaryPath;
        }
        catch (UndefinedParameterError | InvalidPathException e) {
            throw new UserError(this.getOperator(), e, "python_scripting.invalid_path", new Object[]{e.getMessage()});
        }
    }

    private PythonProcessBuilder buildPythonProcess(String pythonBinaryPath, Path workingDirectory, int outputPortCount) {
        PythonProcessBuilder processBuilder = new PythonProcessBuilder(pythonBinaryPath, "-u", WRAPPER_FILE_NAME, String.valueOf(outputPortCount));
        processBuilder.directory(workingDirectory.toFile());
        Map<String, String> env = processBuilder.environment();
        env.put("PYTHONIOENCODING", StandardCharsets.UTF_8.name());
        env.put("WORKING_DIRECTORY", this.workingDirectory == null ? workingDirectory.toString() : this.workingDirectory.toString());
        if (this.encryptionKey != null) {
            env.put("SERDE_KEY", this.encryptionKey);
        }
        return processBuilder;
    }

    private Process startProcessWithLogging(PythonProcessBuilder processBuilder) throws IOException {
        this.getLogger().log(Level.INFO, "Starting python process...");
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        InputStreamLogger.log(process.getInputStream(), this.getLogger());
        return process;
    }

    private void writeModifiedScriptToTemp(String workingDirectory, String fileName, String[] linePatterns, String[] replacements) throws IOException {
        if (linePatterns.length != replacements.length) {
            throw new IllegalArgumentException("The number of line patterns must match the number of replacements.");
        }
        int[] matchCounts = new int[linePatterns.length];
        Pattern[] compiledPatterns = this.compilePatterns(linePatterns);
        String templateScriptPath = PATH_SCRIPT_RESOURCES_DIR + fileName;
        Path outputScriptPath = Paths.get(workingDirectory, fileName);
        try (InputStream scriptInputStream = PythonArrowScriptRunner.class.getResourceAsStream(templateScriptPath);){
            if (scriptInputStream == null) {
                throw new FileNotFoundException("Template script file not found: " + templateScriptPath);
            }
            try (Scanner scanner = new Scanner(scriptInputStream, StandardCharsets.UTF_8);
                 PrintWriter writer = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(outputScriptPath, new OpenOption[0]), StandardCharsets.UTF_8));){
                while (scanner.hasNextLine()) {
                    String originalLine = scanner.nextLine();
                    String modifiedLine = this.replaceLineIfPatternMatches(originalLine, compiledPatterns, replacements, matchCounts);
                    writer.println(modifiedLine);
                }
                writer.flush();
            }
        }
        this.validateMatchCounts(linePatterns, matchCounts, fileName);
    }

    private Pattern[] compilePatterns(String[] linePatterns) {
        Pattern[] patterns = new Pattern[linePatterns.length];
        for (int i = 0; i < linePatterns.length; ++i) {
            patterns[i] = Pattern.compile(linePatterns[i], 32);
        }
        return patterns;
    }

    private String replaceLineIfPatternMatches(String line, Pattern[] patterns, String[] replacements, int[] matchCounts) throws PythonScriptRunnerException {
        Object modifiedLine = line;
        for (int i = 0; i < patterns.length; ++i) {
            Matcher matcher = patterns[i].matcher((CharSequence)modifiedLine);
            if (!matcher.matches()) continue;
            if (matcher.groupCount() < 1) {
                throw new PythonScriptRunnerException("Pattern must have at least one capturing group: " + patterns[i].pattern());
            }
            String before = ((String)modifiedLine).substring(0, matcher.start(1));
            String after = ((String)modifiedLine).substring(matcher.end(1));
            modifiedLine = before + replacements[i] + after;
            int n = i;
            matchCounts[n] = matchCounts[n] + 1;
        }
        return modifiedLine;
    }

    private void validateMatchCounts(String[] linePatterns, int[] matchCounts, String fileName) throws PythonScriptRunnerException {
        for (int i = 0; i < matchCounts.length; ++i) {
            if (matchCounts[i] == 0) {
                throw new PythonScriptRunnerException("No matches found for pattern: " + linePatterns[i] + " in file '" + fileName + "'.");
            }
            if (matchCounts[i] <= 1) continue;
            throw new PythonScriptRunnerException("Multiple matches found for pattern: " + linePatterns[i] + " in file '" + fileName + "'.");
        }
    }

    private static String addEncoding(String script) {
        return ENCODING + script;
    }

    private String getEncryptionKey() {
        if (this.encryptionKey == null) {
            SecureRandom rng = new SecureRandom();
            byte[] raw = new byte[32];
            rng.nextBytes(raw);
            this.encryptionKey = Base64.getEncoder().encodeToString(raw);
        }
        return this.encryptionKey;
    }

    protected static class PythonScriptRunnerException
    extends RuntimeException {
        PythonScriptRunnerException(String message) {
            super(message);
        }
    }
}

