/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.python;

import java.util.HashMap;
import java.util.Map;

public enum PythonExitCode {
    PANDAS_NOT_FOUND(50, "pandas"),
    PANDAS_WRONG_VERSION(51, "pandas_version"),
    PARSING_FAILED(55, "parsing"),
    EXECUTION_FAILED(60, "execution"),
    EXECUTION_FAILED_NO_RM_MAIN(61, "execution_no_rm_main"),
    DESERIALIZATION_FAILED(65, "deserialization"),
    SERIALIZATION_FAILED(66, "serialization"),
    DECRYPTION_FAILED(67, "decryption"),
    TYPE_CONVERSION_FAILED(68, "conversion"),
    FILE_NOT_FOUND(70, "filenotfound"),
    PYARROW_NOT_FOUND(72, "pyarrow"),
    PYARROW_WRONG_VERSION(73, "pyarrow_version");

    private static final String PYTHON_USER_ERROR_PREFIX = "python_scripting.failure.";
    private final int exitCode;
    private final String key;
    private static final Map<Integer, PythonExitCode> CODE_MAP;

    private PythonExitCode(int exitCode, String key) {
        this.exitCode = exitCode;
        this.key = key;
    }

    public String getUserErrorKey() {
        return PYTHON_USER_ERROR_PREFIX + this.key;
    }

    public static PythonExitCode fromExitCode(int exitCode) {
        return CODE_MAP.get(exitCode);
    }

    static {
        CODE_MAP = new HashMap<Integer, PythonExitCode>();
        for (PythonExitCode code : PythonExitCode.values()) {
            CODE_MAP.put(code.exitCode, code);
        }
    }
}

