/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.python;

import com.rapidminer.operator.nio.file.BufferedFileObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PythonNativeObject
extends BufferedFileObject {
    private static final long serialVersionUID = -150794654949869298L;
    public static final long MAX_FILE_SIZE = 0x7FFFFFF7L;
    private static final int BUFF_SIZE = 1024;

    public PythonNativeObject(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public PythonNativeObject(InputStream stream) throws IOException {
        super(PythonNativeObject.streamToBuffer(stream));
    }

    private static byte[] streamToBuffer(InputStream stream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        long size = 0L;
        byte[] data = new byte[1024];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
            if ((size += (long)nRead) <= 0x7FFFFFF7L) continue;
            throw new IOException("The stream is too big. You are only allowed to buffer maximal 2147483639 bytes. Your object has a size of " + size + " bytes.");
        }
        return buffer.toByteArray();
    }
}

