/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.python;

import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonSetupTester;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SystemInfoUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PythonProcessBuilder {
    private final String executableName;
    private final Path executablePath;
    private final ProcessBuilder processBuilder;
    private String actualCommand = null;
    private Path currentDir = null;

    public PythonProcessBuilder(String executableName, String ... arguments) {
        this.executableName = executableName;
        this.executablePath = Paths.get(executableName, new String[0]);
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.quotePath(this.executableName));
        args.addAll(Arrays.asList(arguments));
        this.processBuilder = new ProcessBuilder(args);
    }

    public PythonProcessBuilder(List<String> commands) {
        this(commands.get(0), commands.subList(1, commands.size()).toArray(new String[0]));
    }

    public PythonProcessBuilder(List<String> commands, String actualCommand) {
        this(commands.get(0), commands.subList(1, commands.size()).toArray(new String[0]));
        this.actualCommand = actualCommand;
    }

    public Map<String, String> environment() {
        return this.processBuilder.environment();
    }

    public Process start() throws IOException {
        if (this.isPythonExecutable()) {
            String oldPath = this.getPathVariable();
            String newPath = this.getPathPrefix() + oldPath;
            this.processBuilder.environment().put("PATH", newPath);
            Path cDir = this.getCurrentDir();
            if (this.isCondaDistribution() && cDir != null) {
                String condaPrefix = PythonProcessBuilder.isWindowsOS() ? cDir.toString() : cDir.getParent().toString();
                LogService.getRoot().finest(String.format("Setting environment variable CONDA_PREFIX='%s' for Python process %s.", condaPrefix, this.executableName));
                this.processBuilder.environment().put("CONDA_PREFIX", condaPrefix);
            }
            LogService.getRoot().finest(String.format("Starting Python process %s using PATH=%s", this.executableName, newPath));
        } else if (this.isCondaCommand()) {
            String oldPath = this.getPathVariable();
            Path cDir = this.getCurrentDir();
            if (cDir == null) {
                if (PythonProcessBuilder.isWindowsOS()) {
                    LogService.getRoot().warning("Could not find 'conda' command in the current search path. Please add the folder that contains the 'conda.exe' executable. (On Windows this is likely the '\\Scripts' folder of the conda installation)");
                } else {
                    LogService.getRoot().warning("Could not find 'conda' command in the current search path. Please add the folder that contains the 'conda' executable.");
                }
            } else {
                String newPath = this.getPathPrefix(cDir) + oldPath;
                if (this.actualCommand == null || this.actualCommand.equals(this.executableName)) {
                    this.processBuilder.command().set(0, cDir.resolve(this.processBuilder.command().get(0)).toAbsolutePath().toString());
                }
                this.processBuilder.environment().put("PATH", newPath);
                LogService.getRoot().finest(String.format("Starting conda command %s using PATH=%s", this.executableName, newPath));
            }
        } else {
            LogService.getRoot().finest(String.format("Starting process using PATH=%s (executable %s detected as no Python excutable)", this.processBuilder.environment().get("PATH"), this.executableName));
        }
        return this.processBuilder.start();
    }

    public void redirectErrorStream(boolean redirectErrorStream) {
        this.processBuilder.redirectErrorStream(redirectErrorStream);
    }

    public void redirectError(ProcessBuilder.Redirect stream) {
        this.processBuilder.redirectError(stream);
    }

    public void directory(File directory) {
        this.processBuilder.directory(directory);
    }

    private boolean isPythonExecutable() {
        return PythonSetupTester.INSTANCE.isPythonExecutable(this.executablePath);
    }

    private Path searchForCurrentDir() {
        String[] dirs;
        if (this.executablePath.isAbsolute()) {
            return this.executablePath.getParent();
        }
        String command = this.actualCommand != null ? this.actualCommand : this.executableName;
        String path = this.getPathVariable();
        for (String dir : dirs = path.split(File.pathSeparator)) {
            File dirFile;
            String[] files;
            if (dir == null || dir.isEmpty() || (files = (dirFile = new File(dir)).list(new CommandFileNameFilter(command))) == null || files.length <= 0) continue;
            return Paths.get(dir, files[0]).getParent();
        }
        return null;
    }

    private Path getCurrentDir() {
        if (this.currentDir == null) {
            this.currentDir = this.searchForCurrentDir();
        }
        return this.currentDir;
    }

    private boolean isCondaDistribution() {
        if (PythonSetupTester.INSTANCE.isCondaExecutable(this.executablePath)) {
            return true;
        }
        Path dir = this.getCurrentDir();
        if (dir == null || !dir.toFile().exists()) {
            LogService.getRoot().finest(String.format("Cannot find command '%s'.", this.actualCommand == null ? this.executableName : this.actualCommand));
            return false;
        }
        if (dir.endsWith("bin")) {
            dir = dir.getParent();
        }
        return dir.toFile().list((dir1, name) -> name.equalsIgnoreCase("conda-meta")).length > 0;
    }

    private static boolean isWindowsOS() {
        return SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS;
    }

    private boolean isCondaCommand() {
        return this.actualCommand != null && this.actualCommand.equalsIgnoreCase("conda") || this.executableName.equalsIgnoreCase("conda");
    }

    private String getPathVariable() {
        String p = this.processBuilder.environment().get("PATH");
        if (p != null) {
            return p;
        }
        p = System.getenv("PATH");
        if (p != null) {
            return p;
        }
        return "";
    }

    private String getPathPrefix() {
        if (this.executablePath == null) {
            return "";
        }
        if (!this.isCondaDistribution()) {
            LogService.getRoot().finest(String.format("Python executable %s detected and it is not a Conda installation.", this.executablePath));
            return "";
        }
        LogService.getRoot().finest("Running Python executable from Conda distribution, modifying the PATH variable.");
        Path baseCondaEnvPath = PythonSetupTester.INSTANCE.getFullPathForCondaEnvironment("base");
        Object prefix = this.getPathPrefix(baseCondaEnvPath);
        if (!this.executablePath.equals(baseCondaEnvPath)) {
            prefix = this.getPathPrefix(this.executablePath) + (String)prefix;
        }
        return prefix;
    }

    private Path resolvePythonBaseDir(Path path) {
        Path baseDirectory = path.getParent().toAbsolutePath();
        String deepestDir = baseDirectory.getFileName().toString();
        if ("bin".equals(deepestDir) || "Scripts".equals(deepestDir)) {
            baseDirectory = baseDirectory.getParent().toAbsolutePath();
        }
        return baseDirectory;
    }

    private String getPathPrefix(Path path) {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return "";
        }
        Path condaEnvDir = this.resolvePythonBaseDir(path);
        if (PythonProcessBuilder.isWindowsOS()) {
            return condaEnvDir + File.pathSeparator + condaEnvDir.resolve("Library").resolve("mingw-w64").resolve("bin") + File.pathSeparator + condaEnvDir.resolve("Library").resolve("usr").resolve("bin") + File.pathSeparator + condaEnvDir.resolve("Library").resolve("bin") + File.pathSeparator + condaEnvDir.resolve("Scripts") + File.pathSeparator + condaEnvDir.resolve("bin") + File.pathSeparator;
        }
        return condaEnvDir.resolve("bin") + File.pathSeparator;
    }

    private String quotePath(String pythonPath) {
        if (pythonPath == null) {
            return null;
        }
        if (SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS && ((String)pythonPath).matches(".*\\s+.*") && !((String)pythonPath).startsWith("\"") && !((String)pythonPath).endsWith("\"")) {
            pythonPath = "\"" + (String)pythonPath + "\"";
        }
        return pythonPath;
    }

    private static class CommandFileNameFilter
    implements FilenameFilter {
        private final String command;
        private final String commandWithExe;

        public CommandFileNameFilter(String command) {
            this.command = command;
            this.commandWithExe = command.toLowerCase().endsWith(".exe") ? command : command + ".exe";
        }

        @Override
        public boolean accept(File dir, String name) {
            if (PythonProcessBuilder.isWindowsOS()) {
                return name.equalsIgnoreCase(this.command) || name.equalsIgnoreCase(this.commandWithExe);
            }
            return name.equalsIgnoreCase(this.command);
        }
    }
}

