/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.python;

import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.connection.ConnectionInformationContainerIOObject;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.operator.scripting.AbstractScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.InputStreamLogger;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonBinarySupplier;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonExitCode;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonNativeObject;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonProcessBuilder;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonScriptingOperator;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.parameter.UndefinedParameterError;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PythonScriptRunner
extends AbstractScriptRunner {
    private static final String ENCODING = "# coding=utf-8\n";
    private static final String FILE_OBJECT_INFO_EXTENSION = "foi";
    private static final String EXAMPLE_SET_EXTENSION = "csv-encoded";
    private static final String WRAPPER_FILE_NAME = "wrapper.py";
    private static final String UTILS_FILE_NAME = "serdeutils.py";
    private static final String PATH_SCRIPT_RESOURCES_DIR = "/com/rapidminer/resources/python/";
    private final PythonBinarySupplier pythonBinarySupplier;
    private final boolean hdf5CompliantDateAndTimeConversion;
    private Path workingDirectory = null;
    private String encryptionKey = null;

    public PythonScriptRunner(String script, Operator operator, PythonBinarySupplier pythonBinarySupplier) {
        this(script, operator, pythonBinarySupplier, operator.getCompatibilityLevel().isAbove((VersionNumber)PythonScriptingOperator.VERSION_HDF5_DATE_TIME_BUG));
    }

    protected PythonScriptRunner(String script, Operator operator, PythonBinarySupplier pythonBinarySupplier, boolean hdf5CompliantDateAndTimeConversion) {
        super(PythonScriptRunner.addEncoding(script), operator);
        this.pythonBinarySupplier = pythonBinarySupplier;
        this.hdf5CompliantDateAndTimeConversion = hdf5CompliantDateAndTimeConversion;
    }

    public void setWorkingDirectory(Path workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    protected String getExampleSetExtension() {
        return EXAMPLE_SET_EXTENSION;
    }

    private static String addEncoding(String script) {
        return ENCODING + script;
    }

    @Override
    public List<Class<? extends IOObject>> getSupportedTypes() {
        int INITIAL_LIST_SIZE = 3;
        ArrayList<Class<? extends IOObject>> types = new ArrayList<Class<? extends IOObject>>(3);
        types.add(ExampleSet.class);
        types.add(IOTable.class);
        types.add(PythonNativeObject.class);
        types.add(FileObject.class);
        types.add(ConnectionInformationContainerIOObject.class);
        return types;
    }

    @Override
    public Process startScriptExecutionProcess(Path workingDirectory, int outputPortCount) throws IOException, UserError {
        Path pythonBinaryPath;
        Files.copy(PythonScriptRunner.class.getResourceAsStream("/com/rapidminer/resources/python/wrapper.py"), Paths.get(workingDirectory.toString(), WRAPPER_FILE_NAME), new CopyOption[0]);
        String hdf5Compliant = this.hdf5CompliantDateAndTimeConversion ? "True" : "False";
        String requiredPandas = this.hdf5CompliantDateAndTimeConversion ? "\"1.0.0\"" : "\"0.12.0\"";
        this.writeReplacedScriptToTemp(workingDirectory.toString(), WRAPPER_FILE_NAME, new String[]{"__hdf5_compliant_date_and_time_conversion__\\s*=\\s*(.*)", "__required_pandas_version__\\s*=\\s*(.*)"}, new String[]{hdf5Compliant, requiredPandas});
        Object version = PluginInitPythonScripting.getVersion();
        int postFixIndex = ((String)version).indexOf(45);
        if (postFixIndex > 0) {
            version = ((String)version).substring(0, postFixIndex);
        }
        version = "\"" + (String)version + "\"";
        this.writeReplacedScriptToTemp(workingDirectory.toString(), UTILS_FILE_NAME, new String[]{"\\s*__version__\\s*=\\s*(.*)"}, new String[]{version});
        try {
            pythonBinaryPath = this.pythonBinarySupplier.getPythonBinary();
        }
        catch (UndefinedParameterError | InvalidPathException e) {
            throw new UserError(this.getOperator(), e, "python_scripting.invalid_path", new Object[]{e.getMessage()});
        }
        if (pythonBinaryPath == null) {
            String name = this.pythonBinarySupplier.getPythonEnvironmentName();
            if (name == null) {
                name = "";
            }
            throw new UserError(this.getOperator(), "python_scripting.setup_test_environment.failure", new Object[]{name});
        }
        String pythonPath = pythonBinaryPath.toString();
        PythonProcessBuilder processBuilder = new PythonProcessBuilder(pythonPath, "-u", WRAPPER_FILE_NAME, "" + outputPortCount);
        processBuilder.directory(workingDirectory.toFile());
        Map<String, String> env = processBuilder.environment();
        env.put("PYTHONIOENCODING", StandardCharsets.UTF_8.name());
        env.put("EXAMPLESET_FORMAT", this.getExampleSetExtension());
        env.put("WORKING_DIRECTORY", this.workingDirectory == null ? workingDirectory.toString() : this.workingDirectory.toString());
        if (this.encryptionKey != null) {
            env.put("SERDE_KEY", this.encryptionKey);
        }
        return this.getProcessWithLogging(processBuilder);
    }

    private Process getProcessWithLogging(PythonProcessBuilder processBuilder) throws IOException {
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectError(ProcessBuilder.Redirect.PIPE);
        Process process = processBuilder.start();
        InputStreamLogger.log(process.getInputStream(), this.getLogger());
        return process;
    }

    @Override
    protected String getUserscriptFilename() {
        return "userscript.py";
    }

    @Override
    protected void handleLanguageSpecificExitCode(int exitCode, String errorString) throws UserError {
        PythonExitCode code = PythonExitCode.fromExitCode(exitCode);
        if (code != null) {
            throw new UserError(this.getOperator(), code.getUserErrorKey(), (Object[])errorString.split("\n"));
        }
    }

    @Override
    protected String getFileExtension(IOObject object) {
        if (object instanceof FileObject && !(object instanceof PythonNativeObject)) {
            return FILE_OBJECT_INFO_EXTENSION;
        }
        return super.getFileExtension(object);
    }

    @Override
    protected void serializeInputs(List<IOObject> inputs, Path workingDirectory) throws IOException, UserError, ProcessStoppedException {
        ArrayList<IOObject> annotatedInputs = new ArrayList<IOObject>();
        for (IOObject object : inputs) {
            if (object instanceof ConnectionInformationContainerIOObject) {
                ConnectionInformationContainerIOObject clone = ((ConnectionInformationContainerIOObject)object).copy();
                clone.getAnnotations().put("serde-key", this.getEncryptionKey());
                annotatedInputs.add((IOObject)clone);
                continue;
            }
            annotatedInputs.add(object);
        }
        super.serializeInputs(annotatedInputs, workingDirectory);
    }

    private void writeReplacedScriptToTemp(String tempFolder, String fileName, String[] linePatterns, String[] replacements) throws IOException {
        Integer[] matches = (Integer[])Arrays.stream(linePatterns).map(s -> 0).toArray(Integer[]::new);
        Pattern[] patterns = (Pattern[])Arrays.stream(linePatterns).map(s -> Pattern.compile(s, 32)).toArray(Pattern[]::new);
        try (Scanner scanner = new Scanner(PythonScriptRunner.class.getResourceAsStream(PATH_SCRIPT_RESOURCES_DIR + fileName), StandardCharsets.UTF_8.toString());
             PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Paths.get(tempFolder, fileName).toFile()), StandardCharsets.UTF_8.toString()));){
            while (scanner.hasNextLine()) {
                Object line = scanner.nextLine();
                for (int i = 0; i < patterns.length; ++i) {
                    Matcher matcher = patterns[i].matcher((CharSequence)line);
                    if (!matcher.matches()) continue;
                    line = ((String)line).substring(0, matcher.start(1)) + replacements[i] + ((String)line).substring(matcher.end(1));
                    Integer[] integerArray = matches;
                    int n = i;
                    Integer n2 = integerArray[n];
                    Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
                }
                out.println((String)line);
            }
            out.flush();
        }
        if (Arrays.stream(matches).anyMatch(p -> p == 0)) {
            throw new PythonScriptRunnerException("No matches found for regex in file '" + fileName + "'.");
        }
        if (Arrays.stream(matches).anyMatch(p -> p > 1)) {
            throw new PythonScriptRunnerException("Multiple matches found for regex in file '" + fileName + "'.");
        }
    }

    private String getEncryptionKey() {
        if (this.encryptionKey == null) {
            SecureRandom rng = new SecureRandom();
            byte[] raw = new byte[32];
            rng.nextBytes(raw);
            this.encryptionKey = Base64.getEncoder().encodeToString(raw);
        }
        return this.encryptionKey;
    }

    protected class PythonScriptRunnerException
    extends RuntimeException {
        PythonScriptRunnerException(String message) {
            super(message);
        }
    }
}

