/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.python;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.operator.EnvironmentTools;
import com.rapidminer.extension.pythonscripting.operator.scripting.AbstractScriptingLanguageOperator;
import com.rapidminer.extension.pythonscripting.operator.scripting.ScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonSetupTester;
import com.rapidminer.extension.pythonscripting.serialization.MacrosIOObject;
import com.rapidminer.extension.pythonscripting.tools.ScriptingTools;
import com.rapidminer.gui.properties.SettingsDialog;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeLinkButton;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.parameter.TextType;
import com.rapidminer.parameter.UndefinedMacroError;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.usagestats.ActionStatisticsCollector;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import org.json.JSONException;

public class PythonScriptingOperator
extends AbstractScriptingLanguageOperator {
    private static final String PARAMETER_SCRIPT = "script";
    private static final String PARAMETER_BUTTON = "connect_to_python";
    private static final String PARAMETER_NOTEBOOK_TAG = "notebook_cell_tag_filter";
    private static final String PARAMETER_USE_MACROS = "use_macros";
    public static final OperatorVersion VERSION_CSV_SERIALIZER = new OperatorVersion(9, 3, 1);
    public static final OperatorVersion VERSION_HDF5_DATE_TIME_BUG = new OperatorVersion(9, 8, 0);
    public static final OperatorVersion VERSION_ARROW_SERIALIZATION = new OperatorVersion(10, 1, 2);
    private ParameterType configurationLink;
    private File newlyCreatedFromFile = null;

    public PythonScriptingOperator(OperatorDescription description) {
        super(description);
        if (RapidMiner.isInitialized()) {
            PluginInitPythonScripting.initPluginForFirstTime();
        }
    }

    public Operator cloneOperator(String name, boolean forParallelExecution) {
        PythonScriptingOperator op = (PythonScriptingOperator)super.cloneOperator(name, forParallelExecution);
        op.newlyCreatedFromFile = this.newlyCreatedFromFile;
        return op;
    }

    public void markAsNewlyCreatedFromFile(Path filePath) {
        this.newlyCreatedFromFile = filePath.toFile();
    }

    @Override
    public void doWork() throws OperatorException {
        try {
            ActionStatisticsCollector.getInstance().log("python", "script_source", this.getScriptSourceTypeForLogging());
        }
        catch (IOException e) {
            throw this.getUserError(e);
        }
        ActionStatisticsCollector.getInstance().log("python", this.getParameterAsBoolean("use_default_python") ? "script_env_default" : "script_env", this.getPackageManagerSettingForLogging());
        EnvironmentTools.checkPythonEnvironment(this);
        super.doWork();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSuggestion notebookTag = new ParameterTypeSuggestion(PARAMETER_NOTEBOOK_TAG, I18N.getGUIMessage((String)"gui.parameters.python_scripting.preferences.notebook_tag", (Object[])new Object[0]), (SuggestionProvider)new NotebookTagSuggestionProvider(), "", true);
        notebookTag.setExpert(true);
        notebookTag.registerDependencyCondition(new ParameterCondition((ParameterHandler)this, false){

            public boolean isConditionFullfilled() {
                try {
                    return PythonScriptingOperator.this.isFileSpecified() && Arrays.asList(".ipynb", "unknown").contains(PythonScriptingOperator.this.getFileFormat());
                }
                catch (OperatorException e) {
                    LogService.getRoot().finest("Error during updating parameter dependencies: " + e.getMessage());
                    return true;
                }
            }
        });
        types.add((ParameterType)notebookTag);
        types.addAll(EnvironmentTools.getParameterTypes(this));
        ParameterTypeBoolean useMacrosParameter = new ParameterTypeBoolean(PARAMETER_USE_MACROS, I18N.getGUIMessage((String)"gui.parameters.python_scripting.preferences.use_macros_parameter", (Object[])new Object[0]), false, true);
        types.add((ParameterType)useMacrosParameter);
        this.configurationLink = new ParameterTypeLinkButton(PARAMETER_BUTTON, I18N.getGUIMessage((String)"gui.parameters.python_scripting.preferences.configure_python", (Object[])new Object[0]), new ResourceAction(true, "python_scripting.open_settings", new Object[0]){
            private static final long serialVersionUID = -9196390395936467038L;

            public void actionPerformed(ActionEvent e) {
                new SettingsDialog("python_scripting").setVisible(true);
            }
        });
        this.configurationLink.setHidden(true);
        types.add(this.configurationLink);
        return types;
    }

    public OperatorVersion[] getIncompatibleVersionChanges() {
        ArrayList<OperatorVersion> versions = new ArrayList<OperatorVersion>(Arrays.asList(super.getIncompatibleVersionChanges()));
        versions.add(VERSION_CSV_SERIALIZER);
        versions.add(VERSION_HDF5_DATE_TIME_BUG);
        versions.add(VERSION_ARROW_SERIALIZATION);
        return versions.toArray(new OperatorVersion[0]);
    }

    static boolean isEntrypointDefined(@Nonnull String script) {
        StringBuilder lineBuffer = new StringBuilder();
        PythonParserState state = new PythonParserState();
        for (String line : script.replaceAll("\r\n", "\n").split("\n")) {
            if (line.endsWith("\\")) {
                lineBuffer.append(line, 0, line.length() - 1);
                continue;
            }
            lineBuffer.append(line);
            state.updateState(lineBuffer.toString());
            if (state.rmMainMatched) {
                return true;
            }
            lineBuffer = new StringBuilder();
        }
        return false;
    }

    private ProcessSetupError executePrivilegedAction(Path finalPath, Exception finalException) {
        return AccessController.doPrivileged(() -> this.getPythonBinarySetupRelatedProblems(finalPath, finalException));
    }

    @Override
    protected synchronized void showSetupProblems() {
        Path pythonPath;
        if (!RapidMiner.isInitialized()) {
            return;
        }
        super.showSetupProblems();
        Throwable exception = null;
        try {
            pythonPath = EnvironmentTools.getPythonBinary(this);
        }
        catch (UndefinedParameterError | InvalidPathException e) {
            LogService.getRoot().finest("Cannot get path for python binary, reason: " + e.getMessage());
            pythonPath = null;
            exception = e;
        }
        ProcessSetupError error = this.executePrivilegedAction(pythonPath, (Exception)exception);
        if (error != null) {
            this.addError(error);
        }
        try {
            if (!this.isScriptPortConnected()) {
                this.showScriptRelatedSetupProblems();
            }
        }
        catch (OperatorException e) {
            LogService.getRoot().finest(I18N.getErrorMessage((String)"process.error.python_scripting.validating_error", (Object[])new Object[]{this.getName(), e.getMessage()}));
        }
        catch (IOException e) {
            this.logWarningMessage(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerOperator(Process process) {
        super.registerOperator(process);
        if (this.newlyCreatedFromFile != null) {
            try {
                try {
                    String script;
                    try {
                        script = this.replaceMacros(this.getScriptFromOriginalFile(this.newlyCreatedFromFile));
                    }
                    catch (UndefinedParameterError undefinedParameterError) {
                        script = null;
                    }
                    String fileName = this.newlyCreatedFromFile.getName();
                    if (script != null && (fileName.endsWith(".ipynb") || fileName.endsWith(".py")) && !PythonScriptingOperator.isEntrypointDefined(script)) {
                        this.showInsertingCodeWithoutEntrypointDialog(fileName);
                    }
                }
                finally {
                    this.newlyCreatedFromFile = null;
                }
            }
            catch (IOException e) {
                LogService.getRoot().warning("Ignoring error during Python script content check: " + e.getMessage());
            }
        }
    }

    @Override
    protected ScriptRunner getScriptRunner() throws IOException, OperatorException {
        String script = this.getScriptAndReplaceMacros(true);
        boolean legacyIo = this.getCompatibilityLevel().isAtMost((VersionNumber)VERSION_CSV_SERIALIZER);
        boolean arrowSerializationUsed = this.getCompatibilityLevel().isAbove((VersionNumber)VERSION_ARROW_SERIALIZATION);
        Path workingDirectory = this.isFileSpecified() ? Paths.get(this.getFileName(), new String[0]).getParent() : null;
        return EnvironmentTools.getScriptRunner(this, script, workingDirectory, legacyIo, arrowSerializationUsed);
    }

    protected Set<String> getNotebookTags() throws IOException, OperatorException {
        if (!this.isFileSpecified() || "unknown".equals(this.getFileFormat())) {
            return new HashSet<String>();
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.getFileName()), PluginInitPythonScripting.getExtensionDefaultEncoding());){
            Set<String> set = ScriptingTools.readTagsFromNotebook(reader);
            return set;
        }
    }

    @Override
    protected String getSelectedNotebookTagsRegexp() {
        try {
            String paramValue = this.getParameter(PARAMETER_NOTEBOOK_TAG);
            if (paramValue.isEmpty()) {
                return ".*";
            }
            return "^(" + paramValue + ")$";
        }
        catch (UndefinedParameterError undefinedParameterError) {
            return "";
        }
    }

    @Override
    protected void setSelectedNotebookTagsRegexp(String regex) {
        if (!regex.startsWith("^(") || !regex.endsWith(")$")) {
            throw new IllegalArgumentException("Regex for notebooks tag should start with '^(' and end with ')$'. (To consider the whole tags).");
        }
        regex = regex.substring(0, regex.length() - 2).substring(2);
        this.setParameter(PARAMETER_NOTEBOOK_TAG, regex);
    }

    @Override
    protected String getNotebook(Reader reader) throws IOException {
        return ScriptingTools.readNotebook(reader, this.getSelectedNotebookTagsRegexp());
    }

    @Override
    protected String getScriptParameterName() {
        return PARAMETER_SCRIPT;
    }

    @Override
    protected String getScriptParameterDescription() {
        return "The python script to execute.";
    }

    @Override
    protected TextType getScriptParameterTextType() {
        return TextType.PYTHON;
    }

    @Override
    protected String getScriptParameterTemplateScript() {
        return "import pandas as pd\n\n# The rm_main function is mandatory.\n# The number of arguments must match the number of input ports (can be none),\n# or the number of input ports plus one if the \"use macros\" parameter is set.\n#\n# If you want to use macros, uncomment the following line and check the \"use macros\" parameter:\n# def rm_main(data, macros):\ndef rm_main(data):\n    # Print a greeting message (output can be found in the Log View)\n    print('Hello, world!')\n\n    # Display the type of the input data\n    print(f\"Type of input data: {type(data)}\")\n\n    # Access the data (display first few rows)\n    print(\"Input data preview:\")\n    print(data.head())\n\n    # Create an additional DataFrame to output\n    data2 = pd.DataFrame({'values': [3, 5, 77, 8]})\n\n    # Return the results\n    # Connect two output ports to receive 'data' and 'data2'\n    return data, data2";
    }

    @Override
    protected String[] getScriptFileExtensions() {
        return new String[]{"py", "ipynb"};
    }

    @Override
    protected List<IOObject> checkInputTypes(ScriptRunner scriptRunner) throws UserError {
        List<IOObject> inputs = super.checkInputTypes(scriptRunner);
        if (this.getParameterAsBoolean(PARAMETER_USE_MACROS)) {
            inputs.add((IOObject)new MacrosIOObject(this));
        }
        return inputs;
    }

    private void showInsertingCodeWithoutEntrypointDialog(String fileName) {
        SwingUtilities.invokeLater(() -> SwingTools.showVerySimpleErrorMessage((String)"python_scripting.add_without_rm_main", (Object[])new Object[]{fileName}));
    }

    private void setConfigurationLinkVisible(boolean visible) {
        if (this.configurationLink != null) {
            this.configurationLink.setHidden(!visible);
        }
    }

    private void logWarningMessage(Exception e) {
        if (e.getCause() instanceof JSONException) {
            LogService.getRoot().warning(I18N.getErrorMessage((String)"process.error.python_scripting.notebook_format", (Object[])new Object[]{this.getName(), e.getCause().getMessage()}));
        } else {
            LogService.getRoot().warning(I18N.getErrorMessage((String)"process.error.python_scripting.notebook_parsing", (Object[])new Object[]{this.getName(), e.getMessage()}));
        }
    }

    private ProcessSetupError getPythonBinarySetupRelatedProblems(Path path, Exception exception) {
        ProcessSetupError res = null;
        if (path != null && PythonSetupTester.INSTANCE.isPythonInstalled(path.toString())) {
            res = EnvironmentTools.getErrorForPythonInstallationProblem(this, path);
            this.setConfigurationLinkVisible(res != null && this.getParameterAsBoolean("use_default_python"));
        } else if (this.getParameterAsBoolean("use_default_python")) {
            this.setConfigurationLinkVisible(true);
            res = EnvironmentTools.getErrorForDefaultPythonNotSetProperlyProblem(this);
        } else {
            this.setConfigurationLinkVisible(false);
            res = EnvironmentTools.getErrorForOperatorsPythonNotSetProperlyProblem(this, exception);
        }
        return res;
    }

    private String getPackageManagerSettingForLogging() throws UndefinedParameterError {
        if (this.getParameterAsBoolean("use_default_python")) {
            return PluginInitPythonScripting.getDefaultPackageManagerSettingForLogging();
        }
        String packageManager = this.getParameterAsString("package_manager");
        if (packageManager.equals("conda (anaconda)")) {
            return "conda";
        }
        if (packageManager.equals("virtualenvwrapper")) {
            return "virtualenvwrapper";
        }
        return "custom";
    }

    private void showScriptRelatedSetupProblems() throws OperatorException, IOException {
        String script = null;
        try {
            script = this.getScriptAndReplaceMacros(false);
        }
        catch (UndefinedMacroError e) {
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "python_scripting.undefined_macro", new Object[]{e.getMessage()}));
        }
        catch (UndefinedParameterError e) {
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "python_scripting.undefined_parameter", new Object[]{e.getMessage()}));
        }
        this.showNoEntryPointDefinedSetupProblem(script);
        this.showMagicCommandsRelatedSetupProblems(script);
    }

    private void showNoEntryPointDefinedSetupProblem(String script) {
        if (script != null && !PythonScriptingOperator.isEntrypointDefined(script)) {
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "python_scripting.no_rm_main", new Object[0]));
        }
    }

    private void showMagicCommandsRelatedSetupProblems(String script) throws OperatorException, IOException {
        if (this.isNotebookSpecified()) {
            Set<String> tags = this.getNotebookTags();
            tags.add("");
            Pattern pattern = Pattern.compile(this.getSelectedNotebookTagsRegexp());
            if (tags.stream().noneMatch(tag -> pattern.matcher((CharSequence)tag).find())) {
                ArrayList<ParameterSettingQuickFix> fixes = new ArrayList<ParameterSettingQuickFix>();
                fixes.add(new ParameterSettingQuickFix((Operator)this, PARAMETER_NOTEBOOK_TAG));
                this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), fixes, "python_scripting.no_notebook_tag", new Object[]{this.getParameter(PARAMETER_NOTEBOOK_TAG)}));
            }
            if (script == null) {
                script = this.getScript(false);
            }
            if (ScriptingTools.hasMagicCommands(script)) {
                this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "python_scripting.magic_commands", new Object[0]));
            }
        }
    }

    private boolean isNotebookSpecified() throws OperatorException {
        return this.isFileSpecified() && ".ipynb".equals(this.getFileFormat());
    }

    protected class NotebookTagSuggestionProvider
    implements SuggestionProvider<String> {
        protected NotebookTagSuggestionProvider() {
        }

        public List<String> getSuggestions(Operator op, ProgressListener pl) {
            try {
                return new ArrayList<String>(PythonScriptingOperator.this.getNotebookTags());
            }
            catch (OperatorException | IOException e) {
                PythonScriptingOperator.this.logWarningMessage((Exception)e);
                return new ArrayList<String>();
            }
        }

        public ResourceAction getAction() {
            return null;
        }
    }

    private static class PythonParserState {
        private static Pattern blockComment = Pattern.compile("^[ \\t\\x0b\\r\\f]*('''|\"\"\")");
        private static Pattern globalKeyword = Pattern.compile("^[ \\t\\x0b\\r\\f]*global[ \\t\\x0b\\r\\f]*rm_main[, \\t\\x0b\\r\\f]*.*");
        private static Pattern globalMethod = Pattern.compile("^def[ \\t\\x0b\\r\\f]*rm_main[ \\t\\x0b\\r\\f]*\\([^\\n#]*\\)[ \\t\\x0b\\r\\f]*:.*");
        private static Pattern globalVar = Pattern.compile("^rm_main[ \\t\\x0b\\r\\f]*=.*");
        private static Pattern localVar = Pattern.compile("^[ \\t\\x0b\\r\\f]*rm_main[ \\t\\x0b\\r\\f]*=.*");
        private String blockCommentType = null;
        private boolean globalKeyWordDefined = false;
        private boolean rmMainMatched = false;

        private PythonParserState() {
        }

        private void updateState(String line) {
            if (this.blockCommentType != null) {
                Pattern blockCommentEnd = Pattern.compile("^.*" + this.blockCommentType);
                if (blockCommentEnd.matcher(line).find()) {
                    line = blockCommentEnd.matcher(line).replaceFirst("");
                    this.blockCommentType = null;
                    this.updateState(line);
                }
            } else {
                Matcher m = blockComment.matcher(line);
                if (m.find()) {
                    line = blockComment.matcher(line).replaceFirst("");
                    this.blockCommentType = m.group(1);
                    this.updateState(line);
                } else {
                    this.updateStateForRegularLine(line);
                }
            }
        }

        private void updateStateForRegularLine(String line) {
            if (globalMethod.matcher(line).matches() || globalVar.matcher(line).matches() || this.globalKeyWordDefined && localVar.matcher(line).matches()) {
                this.rmMainMatched = true;
            } else if (globalKeyword.matcher(line).matches()) {
                this.globalKeyWordDefined = true;
            }
        }
    }
}

