/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.python;

import com.rapidminer.RapidMiner;
import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.gui.properties.celleditors.value.PythonBinaryComparator;
import com.rapidminer.extension.pythonscripting.operator.scripting.SetupTester;
import com.rapidminer.extension.pythonscripting.operator.scripting.os.OSCommandRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.os.SingletonOSCommandFactory;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonProcessBuilder;
import com.rapidminer.extension.pythonscripting.parameter.TestActionResult;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.SystemInfoUtilities;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.config.actions.ActionResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONException;
import org.json.JSONObject;

public final class PythonSetupTester
implements SetupTester {
    private static final int PANDAS_MINIMUM_MAJOR_VERSION = 0;
    private static final int PANDAS_MINIMUM_MINOR_VERSION = 12;
    private static final String PANDAS_MINUMUM_VERSION = String.format("%d.%d.%d", 0, 12, 0);
    private static final int MODULE_TEST_FAILED = 77;
    private static final String PYTHON_FILE_EXTENSION = ".py";
    private static final String C_PICKLE_MODULE_NAME = "cPickle";
    private static final String PANDAS_MODULE_NAME = "pandas";
    private static final String VERSION = "--version";
    private static final String IMPORT = "import ";
    private static final String IMPORT_TEST = "import sys%ntry:%n    import  %s%nexcept:%n    sys.exit(%d)";
    private static final String PYTHON = "python";
    private static final String[] LINUX_MAC_FOLDERS = new String[]{"/usr/bin", "/usr/local/bin"};
    private static final String WINDOWS_PYTHON_BINARY_MATCH_PATTERN = "python(\\.exe)?";
    private static final String LINUX_MAC_PYTHON_BINARY_MATCH_PATTERN = "python([2-3](\\.[0-9])?)?([dum])?";
    private static final String PYTHON_EXE = "python.exe";
    private static final String[] WINDOWS_PATH_PREFIXES = new String[]{"C:/", "C:/Program Files"};
    private static final String[] PYTHON_DIRECTORY_MATCH_PATTERN = new String[]{"miniconda*", "anaconda.*", "python.*"};
    public static final PythonSetupTester INSTANCE = new PythonSetupTester();
    private static final OSCommandRunner commandRunner = SingletonOSCommandFactory.getCommandFactory();
    private static final String PYTHON2_IMPORT = "import sys\nif sys.version_info < (3, 0):\n    import ";
    private static final String PYTHON2_IMPORT_TEST = "import sys%nif sys.version_info < (3, 0):%n    try:%n        import %s%n    except:%n        sys.exit(%d)";
    private static final String PANDAS_VERSION_TEST = "import pandas%nimport sys%nif float(pandas.__version__.split('.')[0]) < 1 and float(pandas.__version__.split('.')[1]) < %d:%n    sys.exit(%d)";
    private static final String PARAMETER_LIST_ITEM_SEPARATOR = ",";
    private static final String DEFAULT_CONDA_ENVIRONMENT = "base";
    private static final Object LOCK = new Object();
    private static final Pattern patternPandasVersion = Pattern.compile("pandas==(?<major>[0-9])\\.(?<minor>[1-9][0-9]*)((<?minorminor>\\.[1-9][0-9]*))?");
    private volatile Boolean condaInstalled = null;
    private volatile List<String> condaEnvironments = null;
    private volatile Map<String, Path> condaEnvironmentPaths = null;
    private volatile Boolean venvwInstalled = null;
    private volatile List<String> venvwEnvironments = null;
    private volatile Map<String, Path> venvEnvironmentPaths = null;
    private volatile List<String> pythonBinaries = null;
    private volatile boolean wasAlreadyInitialized = false;

    private PythonSetupTester() {
    }

    private Path getPythonExecutable(Path path, Path baseCondaExecutable) {
        if (SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS) {
            Path firstGuess = path.resolve(PYTHON_EXE);
            if (firstGuess.toFile().exists()) {
                return firstGuess;
            }
            Path secondGuess = path.resolve("Scripts\\python.exe");
            if (secondGuess.toFile().exists()) {
                return secondGuess;
            }
        } else {
            Path firstGuess = path.resolve("bin").resolve(PYTHON);
            if (firstGuess.toFile().exists()) {
                return firstGuess;
            }
        }
        if (baseCondaExecutable != null && baseCondaExecutable.toFile().exists()) {
            LogService.getRoot().fine(String.format("No Python executable found for the conda environment at: %s. Using the base executable (%s) instead.", path, baseCondaExecutable));
            return baseCondaExecutable;
        }
        throw new IllegalStateException(String.format("No appropriate Python executable found, searching the path: %s.", path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCondaCache() {
        Object object = LOCK;
        synchronized (object) {
            this.condaInstalled = null;
            this.condaEnvironments = null;
        }
        this.listCondaEnvironments(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshVirtualEnvwrapperCache() {
        Object object = LOCK;
        synchronized (object) {
            this.venvwInstalled = null;
            this.venvwEnvironments = null;
        }
        this.listVirtualenvwrapperEnvironments(true);
    }

    public void refreshPythonBinariesCache(ProgressThread progressThread) {
        LogService.getRoot().info("Refreshing Python settings. This may take some time...");
        this.listPythonBinaries(true, progressThread);
        LogService.getRoot().info("Refreshing Python settings DONE.");
    }

    public boolean isPythonInstalled(String pythonPath) {
        return this.scriptingPathTest(pythonPath);
    }

    public boolean isPandasInstalled(String pythonPath) {
        return this.isModuleInstalled(PANDAS_MODULE_NAME, pythonPath, false);
    }

    public boolean isCPickleInstalled(String pythonPath) {
        return this.isModuleInstalled(C_PICKLE_MODULE_NAME, pythonPath, true);
    }

    private String getInstalledModules(String pythonPath) {
        PythonProcessBuilder pb = new PythonProcessBuilder(pythonPath, "-m", "pip", "freeze");
        Object installedModules = "";
        try {
            Process p = pb.start();
            installedModules = OSCommandRunner.readStream(p.getInputStream());
            if (((String)installedModules).length() == 0) {
                String errorMsg = OSCommandRunner.readStream(p.getErrorStream());
                errorMsg = errorMsg.length() == 0 ? I18N.getErrorMessage((String)"process.error.python_scripting.collecting_pip_packages.unknown_error", (Object[])new Object[0]) : I18N.getErrorMessage((String)"process.error.python_scripting.collecting_pip_packages.error_prefix", (Object[])new Object[]{errorMsg});
                errorMsg = errorMsg.replace("\n", "<br>");
                installedModules = "<html><body><i><p style='color:gray';>" + errorMsg + "</p></i></body></html>";
            } else {
                installedModules = "<html><body>" + ((String)installedModules).replace("\n", "<br>") + "</html></body>";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return installedModules;
    }

    public TestActionResult scriptingSetupTest(String pythonPath) {
        TestActionResult result = null;
        String HTML_TAG = "</html>";
        String pathForLogging = pythonPath == null ? "<null>" : pythonPath;
        LogService.getRoot().fine(String.format("Testing Python executable at: %s", pathForLogging));
        if (pythonPath == null || !pythonPath.contains(PYTHON)) {
            LogService.getRoot().warning(String.format("No Python found on path: %s", pathForLogging));
            String errorKey = "setup.action.python_scripting.path.failure";
            String message = I18N.getGUIMessage((String)errorKey, (Object[])new Object[0]);
            return new TestActionResult(message, "", ActionResult.Result.FAILURE, errorKey);
        }
        LogService.getRoot().finest("Running Python.");
        PythonProcessBuilder processBuilder = new PythonProcessBuilder(pythonPath, VERSION);
        TestActionResult firstResult = this.processTest(processBuilder);
        LogService.getRoot().finest("Result of the first test step: " + firstResult.getMessage());
        result = new TestActionResult(firstResult.getMessage(), "", firstResult.getResult(), firstResult.getErrorKeyForLogging());
        if (result.getResult() == ActionResult.Result.SUCCESS) {
            String message;
            String errorKey;
            LogService.getRoot().finest("Running Python.");
            String installedModules = this.getInstalledModules(pythonPath);
            LogService.getRoot().finest("The following installed modules detected: " + installedModules.replaceAll("\\n", " "));
            result = new TestActionResult(result.getMessage(), installedModules, result.getResult(), "");
            boolean canImportPandas = !this.moduleNotFound(PANDAS_MODULE_NAME, pythonPath, false);
            boolean pandasPipVersionSufficient = true;
            if (!canImportPandas) {
                String errorKey2;
                Matcher pandasVersionMatcher = patternPandasVersion.matcher(installedModules);
                if (pandasVersionMatcher.find()) {
                    pandasPipVersionSufficient = Integer.parseInt(pandasVersionMatcher.group("minor")) >= 12;
                    errorKey2 = "setup.action.python_scripting.pandas_import.failure";
                    String message2 = result.getMessage().substring(0, result.getMessage().indexOf("</html>")) + "<br/><font color = \"red\">" + I18N.getGUIMessage((String)errorKey2, (Object[])new Object[0]) + "</font></html>";
                    LogService.getRoot().warning("Pandas module detected, but the extension is unable to load it. Check your installation.");
                    result = new TestActionResult(message2, installedModules, ActionResult.Result.FAILURE, errorKey2);
                } else {
                    errorKey2 = "setup.action.python_scripting.pandas.failure";
                    String message3 = result.getMessage().substring(0, result.getMessage().indexOf("</html>")) + "<br/><font color = \"red\">" + I18N.getGUIMessage((String)errorKey2, (Object[])new Object[]{PANDAS_MINUMUM_VERSION}) + "</font></html>";
                    LogService.getRoot().warning("Pandas module not found!");
                    result = new TestActionResult(message3, installedModules, ActionResult.Result.FAILURE, errorKey2);
                }
            }
            if (canImportPandas && this.pandasVersionNotSufficient(pythonPath) || !canImportPandas && !pandasPipVersionSufficient) {
                errorKey = "setup.action.python_scripting.pandas_version.failure";
                message = result.getMessage().substring(0, result.getMessage().indexOf("</html>")) + "<br/><font color = \"red\">" + I18N.getGUIMessage((String)errorKey, (Object[])new Object[]{PANDAS_MINUMUM_VERSION}) + "</font></html>";
                LogService.getRoot().warning("Pandas version not sufficient!");
                result = new TestActionResult(message, installedModules, ActionResult.Result.FAILURE, errorKey);
            }
            if (this.moduleNotFound(C_PICKLE_MODULE_NAME, pythonPath, true)) {
                errorKey = "setup.action.python_scripting.cpickle.failure";
                message = result.getMessage().substring(0, result.getMessage().indexOf("</html>")) + "<br/><br/>" + I18N.getGUIMessage((String)errorKey, (Object[])new Object[0]) + "</html>";
                LogService.getRoot().warning("CPickle module not found!");
                result = new TestActionResult(message, installedModules, result.getResult(), errorKey);
            }
        }
        LogService.getRoot().finest(String.format("Tested Python executable: %s", pathForLogging));
        return result;
    }

    @Override
    public void autodetectPath() {
        LogService.getRoot().info("Initializing Python Scripting Extension for the first time. Thank you for downloading!");
        PluginInitPythonScripting.logExtensionProperties();
        if (this.isCondaInstalled()) {
            LogService.getRoot().info("Conda installation detected, skipping search for other Python installations.");
            ParameterService.setParameterValue((String)"rapidminer.python_scripting.package_manager", (String)"conda (anaconda)");
            ParameterService.setParameterValue((String)"rapidminer.python_scripting.conda_environment", (String)DEFAULT_CONDA_ENVIRONMENT);
            ParameterService.saveParameters();
        } else {
            LogService.getRoot().info("No conda installation is detected. Searching for other Python installations...");
            boolean isHeadless = RapidMiner.getExecutionMode().isHeadless();
            this.forceRefreshPythonBinaries(null, isHeadless);
            int size = this.pythonBinaries.size();
            LogService.getRoot().info(String.format("Found and kept %d potential Python %s", size, size == 1 ? "binary." : "binaries."));
            if (!this.pythonBinaries.isEmpty()) {
                ParameterService.setParameterValue((String)"rapidminer.python_scripting.package_manager", (String)"specific python binaries");
                ParameterService.setParameterValue((String)"rapidminer.python_scripting.python_binary", (String)this.pythonBinaries.get(0));
                ParameterService.saveParameters();
            } else {
                LogService.getRoot().info("No Python installation found.");
            }
        }
    }

    private boolean scriptingPathTest(String pythonPath) {
        if (!pythonPath.contains(PYTHON)) {
            return false;
        }
        PythonProcessBuilder processBuilder = new PythonProcessBuilder(pythonPath, VERSION);
        return this.processTestFast(processBuilder);
    }

    private void saveList(String key, List<String> value) {
        Optional commaSeparatedValues = value.stream().reduce((s1, s2) -> s1 + PARAMETER_LIST_ITEM_SEPARATOR + s2);
        if (commaSeparatedValues.isPresent()) {
            ParameterService.setParameterValue((String)key, (String)((String)commaSeparatedValues.get()));
        } else {
            ParameterService.setParameterValue((String)key, (String)"");
        }
        ParameterService.saveParameters();
    }

    public List<String> listPythonBinaries() {
        return this.listPythonBinaries(false);
    }

    private List<String> listPythonBinaries(boolean forceRefresh) {
        return this.listPythonBinaries(forceRefresh, null);
    }

    private List<String> listPythonBinaries(boolean forceRefresh, ProgressThread progressThread) {
        if (forceRefresh) {
            this.forceRefreshPythonBinaries(progressThread, false);
        } else if (this.pythonBinaries == null) {
            String cachedEnvironments = ParameterService.getParameterValue((String)"rapidminer.python_scripting.cached.binaries");
            if (!this.wasAlreadyInitialized && cachedEnvironments != null && cachedEnvironments.length() > 0) {
                this.wasAlreadyInitialized = true;
                this.pythonBinaries = Arrays.asList(cachedEnvironments.split(PARAMETER_LIST_ITEM_SEPARATOR));
            } else {
                this.forceRefreshPythonBinaries(progressThread, false);
            }
        }
        return this.pythonBinaries;
    }

    Set<Path> getDirsToCheck() {
        String[] pathPrefixes = SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS ? WINDOWS_PATH_PREFIXES : LINUX_MAC_FOLDERS;
        String dirMsg = "Adding directory {0} to search paths";
        LinkedHashSet<Path> dirsToCheck = new LinkedHashSet<Path>();
        for (String dir : PluginInitPythonScripting.getCurrentSearchPath().split(PARAMETER_LIST_ITEM_SEPARATOR)) {
            Path p = Paths.get(dir, new String[0]);
            if (!dirsToCheck.add(p)) continue;
            LogService.getRoot().log(Level.FINEST, dirMsg, dir.replace("\\\\", "\\"));
        }
        String pathVariable = System.getenv("PATH");
        if (pathVariable != null) {
            for (String dir : pathVariable.split(File.pathSeparator)) {
                if (!dirsToCheck.add(Paths.get(dir, new String[0]))) continue;
                LogService.getRoot().log(Level.FINEST, dirMsg, dir);
            }
        }
        for (String dir : pathPrefixes) {
            Path p = Paths.get(dir, new String[0]);
            if (!dirsToCheck.add(p)) continue;
            LogService.getRoot().log(Level.FINEST, dirMsg, dir);
        }
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            dirsToCheck.add(Paths.get(userHome, new String[0]));
        }
        return dirsToCheck;
    }

    private static String getFileMatchPattern() {
        Object pattern = SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS ? WINDOWS_PYTHON_BINARY_MATCH_PATTERN : LINUX_MAC_PYTHON_BINARY_MATCH_PATTERN;
        pattern = "\\".equals(File.separator) ? "(.*\\\\)?" + (String)pattern : "(.*" + File.separator + ")?" + (String)pattern;
        return pattern;
    }

    public boolean isPythonExecutable(Path path) {
        return path.toString().matches(PythonSetupTester.getFileMatchPattern());
    }

    private void updateProgressThread(ProgressThread pt, int current, int max) {
        if (pt != null) {
            pt.getProgressListener().setTotal(max);
            pt.getProgressListener().setCompleted(current);
        }
    }

    private void forceRefreshPythonBinaries(ProgressThread progressThread, boolean findFirstOnly) {
        this.wasAlreadyInitialized = true;
        List<String> results = new ArrayList<String>();
        List<String> oldValues = this.pythonBinaries;
        Set<Path> dirsToCheck = this.getDirsToCheck();
        HashSet<Path> scannedDirs = new HashSet<Path>();
        this.updateProgressThread(progressThread, 0, dirsToCheck.size());
        int completedDirs = 0;
        for (Path p : dirsToCheck) {
            if (progressThread != null && progressThread.isCancelled()) {
                this.pythonBinaries = oldValues;
                return;
            }
            try {
                Files.walkFileTree(p, new PythonBinarySearcher(p, results, scannedDirs, progressThread, findFirstOnly));
                if (findFirstOnly && !results.isEmpty()) {
                    break;
                }
            }
            catch (IOException e) {
                LogService.getRoot().fine("Error during scanning file system: " + e.getMessage());
            }
            catch (RefreshCancelledException e) {
                this.pythonBinaries = oldValues;
                return;
            }
            this.updateProgressThread(progressThread, ++completedDirs, dirsToCheck.size());
        }
        results.sort(new PythonBinaryComparator());
        results = PythonBinaryComparator.sortByDirectory(results);
        this.pythonBinaries = results;
        this.saveList("rapidminer.python_scripting.cached.binaries", this.pythonBinaries);
    }

    public Path getFullPathForPythonBinary(String path) {
        return Paths.get(path, new String[0]);
    }

    boolean isCondaInstalled() {
        return this.isCondaInstalled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCondaInstalled(boolean forceRefresh) {
        Boolean res = this.condaInstalled;
        if (forceRefresh || res == null) {
            Object object = LOCK;
            synchronized (object) {
                if (forceRefresh || this.condaInstalled == null) {
                    LogService.getRoot().finest("Trying to detect Conda installation...");
                    try {
                        this.condaInstalled = commandRunner.runCondaVersionCommand().length() > 0;
                    }
                    catch (IOException e) {
                        LogService.getRoot().finest("Could not retrieve Conda version info: " + e.getMessage());
                        this.condaInstalled = false;
                    }
                    if (this.condaInstalled.booleanValue()) {
                        LogService.getRoot().finest("Detected Conda installation on the system.");
                    } else {
                        LogService.getRoot().fine("No Conda installation detected: check your installation and configure search path parameter.");
                    }
                }
                return this.condaInstalled;
            }
        }
        LogService.getRoot().finest("Conda installation flag was already initialized.");
        return res;
    }

    public List<String> listCondaEnvironments() {
        return this.listCondaEnvironments(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listCondaEnvironments(boolean forceRefresh) {
        String CONDA_ENV_ALREADY_INITIALIZED = "Conda environment list already initialized.";
        if (this.isCondaInstalled(forceRefresh)) {
            if (forceRefresh || this.condaEnvironments == null) {
                LogService.getRoot().finest("Force refreshing list of Conda environments...");
                this.forceRefreshCondaEnvironments();
            } else {
                LogService.getRoot().finest("Conda environment list already initialized.");
            }
        } else if (this.condaEnvironments == null) {
            Object object = LOCK;
            synchronized (object) {
                if (this.condaEnvironments == null) {
                    LogService.getRoot().finest("Initializing list of Conda environments to an empty list: no Conda installation found.");
                    this.condaEnvironments = new ArrayList<String>();
                    this.condaEnvironmentPaths = new HashMap<String, Path>();
                } else {
                    LogService.getRoot().finest("Conda environment list already initialized.");
                }
            }
        } else {
            LogService.getRoot().finest("Conda environment list already initialized.");
        }
        return this.condaEnvironments;
    }

    private String getEnvironmentName(Path pathToEnvDir, Path baseEnvironmentPath, List<String> duplicatedEnvNames) {
        if (pathToEnvDir.equals(baseEnvironmentPath)) {
            return DEFAULT_CONDA_ENVIRONMENT;
        }
        String simpleName = pathToEnvDir.getFileName().toString();
        if (duplicatedEnvNames != null && duplicatedEnvNames.contains(simpleName)) {
            return String.format("%s [%s]", simpleName, pathToEnvDir.toAbsolutePath());
        }
        return simpleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceRefreshCondaEnvironments() {
        String response = "empty";
        Object object = LOCK;
        synchronized (object) {
            try {
                LogService.getRoot().finest("Collecting list of Conda environments...");
                response = commandRunner.runCondaEnvironmentListCommand();
                JSONObject root = new JSONObject(response);
                Path baseEnvironmentPath = Paths.get(root.getString("root_prefix"), new String[0]);
                Path baseEnvironmentExecutable = this.getPythonExecutable(baseEnvironmentPath, null);
                LogService.getRoot().fine(String.format("Path for base environment is: %s", baseEnvironmentPath));
                Set envs = root.getJSONArray("envs").toList().stream().map(o -> new PathWrapper(Paths.get((String)o, new String[0]))).collect(Collectors.toSet());
                List duplicatedEnvs = envs.stream().map(p -> this.getEnvironmentName(p.path, baseEnvironmentPath, null)).collect(Collectors.toMap(Function.identity(), o -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
                Map<String, Path> envMap = envs.stream().collect(Collectors.toMap(p -> this.getEnvironmentName(p.path, baseEnvironmentPath, duplicatedEnvs), p -> this.getPythonExecutable(p.path, baseEnvironmentExecutable)));
                envMap.entrySet().forEach(e -> LogService.getRoot().fine("Found conda environment: " + ((String)e.getKey()).toString() + " (at " + ((Path)e.getValue()).toString() + ")."));
                ArrayList<String> envList = new ArrayList<String>(envMap.keySet());
                envList.sort((o1, o2) -> {
                    if (DEFAULT_CONDA_ENVIRONMENT.equals(o1)) {
                        return -1;
                    }
                    if (DEFAULT_CONDA_ENVIRONMENT.equals(o2)) {
                        return 1;
                    }
                    return o1.compareTo((String)o2);
                });
                this.condaEnvironments = envList;
                this.condaEnvironmentPaths = envMap;
                LogService.getRoot().finest("Collected list of Conda environments.");
            }
            catch (IOException | JSONException e2) {
                LogService.getRoot().warning("Could not parse result of listing Conda environments: " + e2.getMessage());
                LogService.getRoot().fine("Last command output was: " + response);
                this.condaEnvironments = new ArrayList<String>();
                this.condaEnvironmentPaths = new HashMap<String, Path>();
            }
        }
    }

    public boolean isCondaExecutable(Path pythonPath) {
        if (this.condaEnvironmentPaths == null) {
            this.refreshCondaCache();
        }
        return this.condaEnvironmentPaths.values().stream().anyMatch(p -> p.equals(pythonPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getFullPathForCondaEnvironment(String environment) {
        if (this.condaEnvironmentPaths == null || !this.condaEnvironmentPaths.containsKey(environment)) {
            this.refreshCondaCache();
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.condaEnvironmentPaths == null) {
                return null;
            }
            Path result = this.condaEnvironmentPaths.get(environment);
            LogService.getRoot().finest(String.format("Executable location for Conda environment %s is %s.", environment, result));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVirtualenvwrapperInstalled(boolean forceRefresh) {
        Boolean res = this.venvwInstalled;
        if (forceRefresh || res == null) {
            Object object = LOCK;
            synchronized (object) {
                if (forceRefresh || this.venvwInstalled == null) {
                    LogService.getRoot().finest("Trying to detect Virtualenvwrapper installation...");
                    try {
                        this.venvwInstalled = commandRunner.runVenvwVersionCommand().length() > 0;
                    }
                    catch (IOException e) {
                        this.venvwInstalled = false;
                    }
                    if (this.venvwInstalled.booleanValue()) {
                        LogService.getRoot().finest("Detected Virtualenvwrapper installation on the system.");
                    } else {
                        LogService.getRoot().fine("No Virtualenvwrapper installation detected: check your installation and configure search path parameter.");
                    }
                }
                return this.venvwInstalled;
            }
        }
        LogService.getRoot().finest("Virtualenvwrapper installation flag was already initialized.");
        return res;
    }

    public List<String> listVirtualenvwrapperEnvironments() {
        return this.listVirtualenvwrapperEnvironments(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listVirtualenvwrapperEnvironments(boolean forceRefresh) {
        Object object;
        String VENVW_ENV_ALREADY_INITIALIZED = "Virtualenvwrapper environment list already initialized.";
        if (this.isVirtualenvwrapperInstalled(forceRefresh)) {
            if (forceRefresh || this.venvwEnvironments == null) {
                LogService.getRoot().finest("Force refreshing list of Virtualenvwrapper environments...");
                this.forceRefreshVenvwEnvironments();
            } else {
                LogService.getRoot().finest("Virtualenvwrapper environment list already initialized.");
            }
        } else if (this.venvwEnvironments == null) {
            object = LOCK;
            synchronized (object) {
                if (this.venvwEnvironments == null) {
                    LogService.getRoot().finest("Initializing list of Virtualenvwrapper environments to an empty list: no Virtualenvwrapper installation found.");
                    this.venvwEnvironments = new ArrayList<String>();
                    this.venvEnvironmentPaths = new HashMap<String, Path>();
                } else {
                    LogService.getRoot().finest("Virtualenvwrapper environment list already initialized.");
                }
            }
        } else {
            LogService.getRoot().finest("Virtualenvwrapper environment list already initialized.");
        }
        object = LOCK;
        synchronized (object) {
            return this.venvwEnvironments;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceRefreshVenvwEnvironments() {
        Object object = LOCK;
        synchronized (object) {
            String workonHomeOutput = "<not initalized>";
            try {
                LogService.getRoot().finest("Collecting list of Virtualenvwrapper environments...");
                String[] envs = commandRunner.runVenvwEnvironmentListCommand().split("\n");
                LogService.getRoot().finest("Determining WORKON_HOME...");
                workonHomeOutput = commandRunner.runPrintWorkonHomeCommand();
                workonHomeOutput = workonHomeOutput.replaceAll("(.|\\n)*WORKON_HOME=", "");
                Path baseDir = Paths.get(workonHomeOutput.trim(), new String[0]);
                LogService.getRoot().fine(String.format("Workon-home: %s", baseDir.toString()));
                this.venvwEnvironments = Arrays.stream(envs).filter(s -> s.length() > 0 && !s.contains(" ") && !s.contains("=")).sorted().collect(Collectors.toList());
                this.venvEnvironmentPaths = this.venvwEnvironments.stream().collect(Collectors.toMap(Function.identity(), s -> this.getPythonExecutable(baseDir.resolve((String)s), null)));
                this.venvwEnvironments.forEach(s -> LogService.getRoot().fine("Detected Virtualenvwrapper environment: " + s));
                LogService.getRoot().finest("Collected list of Virtualenvwrapper environments.");
            }
            catch (InvalidPathException e) {
                String finalWorkonHomeOutput = workonHomeOutput;
                LogService.getRoot().warning(String.format("Cannot get WORKON_HOME variable. Invalid path: '%s'.", finalWorkonHomeOutput));
            }
            catch (IOException e) {
                LogService.getRoot().warning(String.format("Could not parse result of listing Virtualenvwrapper environments: %s", e.getMessage()));
                this.venvwEnvironments = new ArrayList<String>();
                this.venvEnvironmentPaths = new HashMap<String, Path>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getFullPathForVenvwEnvironment(String environment) {
        if (this.venvEnvironmentPaths == null || !this.venvEnvironmentPaths.containsKey(environment)) {
            this.refreshVirtualEnvwrapperCache();
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.venvEnvironmentPaths == null) {
                return null;
            }
            Path result = this.venvEnvironmentPaths.get(environment);
            LogService.getRoot().finest(String.format("Executable location for Virtualenvwrapper environment %s is %s.", environment, result));
            return result;
        }
    }

    private boolean isModuleInstalled(String moduleName, String pythonPath, boolean onlyPython2) {
        String test = onlyPython2 ? PYTHON2_IMPORT + moduleName : IMPORT + moduleName;
        return this.checkScriptForSuccess(test, pythonPath, PYTHON_FILE_EXTENSION);
    }

    private boolean moduleNotFound(String moduleName, String pythonPath, boolean onlyPython2) {
        String test = onlyPython2 ? String.format(PYTHON2_IMPORT_TEST, moduleName, 77) : String.format(IMPORT_TEST, moduleName, 77);
        return this.checkScriptForExitCode(test, pythonPath, 77, PYTHON_FILE_EXTENSION);
    }

    public boolean pandasVersionNotSufficient(String pythonPath) {
        String script = String.format(PANDAS_VERSION_TEST, 12, 77);
        return this.checkScriptForExitCode(script, pythonPath, 77, PYTHON_FILE_EXTENSION);
    }

    @Override
    public ResourceAction showActionLink() {
        return null;
    }

    private String getSubdirectoryList(String directory) {
        if (SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS) {
            return directory + PARAMETER_LIST_ITEM_SEPARATOR + directory + File.separator + "Scripts";
        }
        return directory + PARAMETER_LIST_ITEM_SEPARATOR + directory + File.separator + "bin";
    }

    private String existsCaseInsensitive(String directory) {
        Path dir = Paths.get(directory, new String[0]);
        if (dir.toFile().exists()) {
            return directory;
        }
        Path parent = dir.getParent();
        String[] matches = parent.toFile().list((dir1, name) -> name.equalsIgnoreCase(dir.getFileName().toString()));
        if (matches != null && matches.length > 0) {
            return Arrays.stream(matches).sorted().findFirst().get();
        }
        return null;
    }

    private String appendPotentialCondaLocation(String locations, String potentialLocation) {
        String caseSensitivePotentialLocation = this.existsCaseInsensitive(potentialLocation);
        if (caseSensitivePotentialLocation == null) {
            return locations;
        }
        if (locations.length() > 0) {
            return locations + PARAMETER_LIST_ITEM_SEPARATOR + this.getSubdirectoryList(caseSensitivePotentialLocation);
        }
        return this.getSubdirectoryList(potentialLocation);
    }

    public String getDefaultSearchPathValues() {
        String result = "";
        String userHome = System.getProperty("user.home");
        List<String> condaInstallationTypes = Arrays.asList("Anaconda2", "Anaconda3", "Miniconda2", "Miniconda3");
        if (userHome != null) {
            for (String condaDir : condaInstallationTypes) {
                result = this.appendPotentialCondaLocation(result, userHome + File.separator + condaDir);
            }
        }
        if (SystemInfoUtilities.getOperatingSystem() == SystemInfoUtilities.OperatingSystem.WINDOWS) {
            for (String condaDir : condaInstallationTypes) {
                result = this.appendPotentialCondaLocation(result, String.format("C:%sProgramData%s%s", File.separator, File.separator, condaDir));
                result = this.appendPotentialCondaLocation(result, String.format("%s%sAppData%sLocal%sContinuum%s%s", userHome, File.separator, File.separator, File.separator, File.separator, condaDir));
            }
            result = result.replaceAll("\\\\", "\\\\\\\\");
        }
        return result;
    }

    private TestActionResult processTest(PythonProcessBuilder processBuilder) {
        String message;
        String errorKey;
        ActionResult.Result result;
        processBuilder.redirectErrorStream(true);
        try {
            Process process = processBuilder.start();
            int exit = process.waitFor();
            if (exit == 0) {
                result = ActionResult.Result.SUCCESS;
                String version = Tools.parseInputStreamToString((InputStream)process.getInputStream(), (boolean)true);
                errorKey = "setup.action.python_scripting.test_setup.success";
                message = I18N.getGUIMessage((String)errorKey, (Object[])new Object[]{version});
            } else {
                result = ActionResult.Result.FAILURE;
                String errorMessage = Tools.parseInputStreamToString((InputStream)process.getInputStream(), (boolean)true);
                errorKey = "setup.action.python_scripting.test_setup.failure";
                message = I18N.getGUIMessage((String)errorKey, (Object[])new Object[]{errorMessage});
            }
        }
        catch (IOException | InterruptedException e) {
            result = ActionResult.Result.FAILURE;
            errorKey = "setup.action.python_scripting.test_setup.failure";
            message = I18N.getGUIMessage((String)errorKey, (Object[])new Object[]{e.getLocalizedMessage()});
        }
        return new TestActionResult(message, "", result, errorKey);
    }

    private boolean processTestFast(PythonProcessBuilder processBuilder) {
        try {
            Process process = processBuilder.start();
            int exit = process.waitFor();
            return exit == 0;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkScriptForSuccess(String script, String path, String fileExtension) {
        Path tempPath = null;
        try {
            tempPath = Files.createTempFile("check", fileExtension, new FileAttribute[0]);
            Files.write(tempPath, script.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE);
            PythonProcessBuilder processBuilder = new PythonProcessBuilder(path, tempPath.toAbsolutePath().toString());
            boolean bl = this.processTestFast(processBuilder);
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempPath != null) {
                try {
                    Files.delete(tempPath);
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkScriptForExitCode(String script, String scriptingPath, int exitCode, String fileExtension) {
        Path tempPath = null;
        try {
            tempPath = Files.createTempFile("check", fileExtension, new FileAttribute[0]);
            Files.write(tempPath, script.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE);
            PythonProcessBuilder processBuilder = new PythonProcessBuilder(scriptingPath, tempPath.toAbsolutePath().toString());
            Process process = processBuilder.start();
            int exit = process.waitFor();
            boolean bl = exit == exitCode;
            return bl;
        }
        catch (IOException | InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempPath != null) {
                try {
                    Files.delete(tempPath);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class PathWrapper {
        Path path;

        public PathWrapper(Path path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathWrapper that = (PathWrapper)o;
            return Objects.equals(this.path.toString().toUpperCase(), that.path.toString().toUpperCase());
        }

        public int hashCode() {
            return Objects.hashCode(this.path.toString().toUpperCase());
        }
    }

    private static class PythonBinarySearcher
    implements FileVisitor<Path> {
        private final ProgressThread progressThread;
        private final String fileMatchPattern;
        private final Path path;
        private final List<String> results;
        private final Set<Path> scannedDirs;
        private final boolean findFirstOnly;

        private PythonBinarySearcher(Path path, List<String> results, Set<Path> scannedDirs, ProgressThread pt, boolean findFirstOnly) {
            this.progressThread = pt;
            this.fileMatchPattern = PythonSetupTester.getFileMatchPattern();
            this.path = path;
            this.results = results;
            this.scannedDirs = scannedDirs;
            this.findFirstOnly = findFirstOnly;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (this.progressThread != null && this.progressThread.isCancelled()) {
                throw new RefreshCancelledException();
            }
            if (this.scannedDirs.contains(dir)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            String name = dir.getNameCount() > 0 ? dir.getName(dir.getNameCount() - 1).toString() : dir.toString();
            boolean isPythonFolder = false;
            for (String dirMatchPattern : PYTHON_DIRECTORY_MATCH_PATTERN) {
                isPythonFolder = isPythonFolder || name.toLowerCase().matches(dirMatchPattern);
            }
            boolean isPythonBinFolder = "bin".equalsIgnoreCase(name);
            if (Files.isReadable(dir) && (this.path.equals(dir) || isPythonBinFolder || isPythonFolder)) {
                this.scannedDirs.add(dir);
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (Files.isReadable(file)) {
                if (this.progressThread != null && this.progressThread.isCancelled()) {
                    throw new RefreshCancelledException();
                }
                String entry = file.toAbsolutePath().toString();
                if (entry.matches(this.fileMatchPattern)) {
                    LogService.getRoot().fine(String.format("Detected Python binary at: %s", entry));
                    this.results.add(entry);
                }
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            if (this.progressThread != null && this.progressThread.isCancelled()) {
                throw new RefreshCancelledException();
            }
            if (exc != null) {
                LogService.getRoot().fine(String.format("Error during scanning file '%s': %s", file, exc.getMessage()));
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (this.progressThread != null && this.progressThread.isCancelled()) {
                throw new RefreshCancelledException();
            }
            if (exc != null) {
                LogService.getRoot().fine(String.format("Error during scanning directory '%s': %s", dir, exc.getMessage()));
            }
            if (this.findFirstOnly && !this.results.isEmpty()) {
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static class RefreshCancelledException
    extends RuntimeException {
        private static final long serialVersionUID = 5132990303924172383L;

        private RefreshCancelledException() {
        }
    }
}

