/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.operator.scripting.python;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.pythonscripting.operator.scripting.ScriptRunner;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonExitCode;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonNativeObject;
import com.rapidminer.extension.pythonscripting.serialization.MacrosIOObject;
import com.rapidminer.extension.pythonscripting.serialization.SerializationService;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.BufferedFileObject;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.tools.LogService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.io.CloseMode;

public class RemoteScriptRunner
implements ScriptRunner {
    private static final List<Class<? extends IOObject>> SUPPORTED_TYPES = Arrays.asList(ExampleSet.class, FileObject.class, IOTable.class, PythonNativeObject.class);
    private static final JsonFactory JSON = new JsonFactory().setCodec((ObjectCodec)new ObjectMapper());
    private static final Map<String, PythonExitCode> EXIT_CODES = new HashMap<String, PythonExitCode>();
    private final String script;
    private final Operator operator;
    private final String endpoint;
    private final String token;

    public RemoteScriptRunner(String script, Operator operator, Map<String, String> connection) {
        this.script = script;
        this.operator = operator;
        this.endpoint = connection.get("basic.endpoint");
        this.token = connection.get("basic.token");
    }

    @Override
    public List<Class<? extends IOObject>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<IOObject> run(List<IOObject> inputs, int outputPortCount) throws IOException, OperatorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeInputs(List<IOObject> inputs, OutputStream out) throws IOException, OperatorException {
        Base64.Encoder encoder = Base64.getEncoder();
        try (JsonGenerator generator = JSON.createGenerator(out);){
            generator.writeStartObject();
            generator.writeStringField("script", this.script);
            generator.writeArrayFieldStart("inputs");
            Map<String, String> macros = null;
            for (IOObject iOObject : inputs) {
                if (iOObject instanceof MacrosIOObject) {
                    macros = ((MacrosIOObject)iOObject).getAllMacros();
                    continue;
                }
                generator.writeStartObject();
                if (iOObject instanceof ExampleSet || iOObject instanceof IOTable) {
                    ByteArrayOutputStream csv = new ByteArrayOutputStream();
                    ByteArrayOutputStream pmd = new ByteArrayOutputStream();
                    try (OutputStream encodedCSV = encoder.wrap(csv);
                         OutputStream encodedPmd = encoder.wrap(pmd);){
                        SerializationService.getInstance().serialize(iOObject, "csv-encoded", new OutputStream[]{encodedCSV, encodedPmd}, this.operator);
                    }
                    generator.writeStringField("type", "table");
                    generator.writeStringField("schema", new String(pmd.toByteArray(), StandardCharsets.UTF_8));
                    generator.writeStringField("data", new String(csv.toByteArray(), StandardCharsets.UTF_8));
                } else if (iOObject instanceof PythonNativeObject) {
                    ByteArrayOutputStream object = new ByteArrayOutputStream();
                    try (OutputStream encodedObject = encoder.wrap(object);){
                        SerializationService.getInstance().serialize(iOObject, "bin", new OutputStream[]{encodedObject}, this.operator);
                    }
                    generator.writeStringField("type", "python");
                    generator.writeStringField("data", new String(object.toByteArray(), StandardCharsets.UTF_8));
                } else if (iOObject instanceof FileObject) {
                    ByteArrayOutputStream contents = new ByteArrayOutputStream();
                    try (OutputStream encodedContents = encoder.wrap(contents);){
                        SerializationService.getInstance().serialize(iOObject, "fo", new OutputStream[]{encodedContents}, this.operator);
                    }
                    generator.writeStringField("type", "file");
                    generator.writeStringField("data", new String(contents.toByteArray(), StandardCharsets.UTF_8));
                } else {
                    throw new AssertionError((Object)("Unsupported input type: " + iOObject.getClass()));
                }
                generator.writeEndObject();
            }
            generator.writeEndArray();
            if (macros != null) {
                generator.writeObjectFieldStart("macros");
                for (Map.Entry entry : macros.entrySet()) {
                    generator.writeStringField((String)entry.getKey(), (String)entry.getValue());
                }
                generator.writeEndObject();
            }
            generator.writeEndObject();
        }
    }

    private void handleErrors(Operator operator, CloseableHttpResponse response) throws IOException, UserError {
        block8: {
            int code = response.getCode();
            try {
                if (code == 200) break block8;
                JsonParser parser = JSON.createParser(response.getEntity().getContent());
                try {
                    ObjectNode root = (ObjectNode)parser.readValueAsTree();
                    Object message = root.get("message").asText();
                    if (root.has("traceback")) {
                        message = (String)message + "\n" + root.get("traceback").asText();
                    }
                    LogService.getRoot().log(Level.SEVERE, (String)message);
                    PythonExitCode exitCode = root.has("appcode") ? EXIT_CODES.getOrDefault(root.get("appcode").asText(), PythonExitCode.EXECUTION_FAILED) : PythonExitCode.EXECUTION_FAILED;
                    throw new UserError(operator, exitCode.getUserErrorKey(), new Object[]{message});
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (JsonProcessingException | NullPointerException e) {
                throw new UserError(operator, PythonExitCode.EXECUTION_FAILED.getUserErrorKey(), new Object[]{"Request to remote Python engine failed with HTTP code: " + code});
            }
        }
    }

    private ResultContainer readResults(InputStream in) throws IOException, OperatorException {
        Base64.Decoder decoder = Base64.getDecoder();
        ArrayList<IOObject> outputs = new ArrayList<IOObject>();
        String logs = null;
        try (JsonParser parser = JSON.createParser(in);){
            ObjectNode root = (ObjectNode)parser.readValueAsTree();
            ArrayNode items = (ArrayNode)root.get("outputs");
            block15: for (JsonNode output : items) {
                String type;
                ObjectNode node = (ObjectNode)output;
                switch (type = node.get("type").asText()) {
                    case "table": {
                        ByteArrayInputStream pmd = new ByteArrayInputStream(decoder.decode(node.get("schema").asText()));
                        ByteArrayInputStream csv = new ByteArrayInputStream(decoder.decode(node.get("data").asText()));
                        HashMap<String, InputStream> tableStreams = new HashMap<String, InputStream>(2);
                        tableStreams.put("pmd-encoded", pmd);
                        tableStreams.put("csv-encoded", csv);
                        IOObject table = SerializationService.getInstance().deserialize(tableStreams, "csv-encoded", this.operator);
                        outputs.add(table);
                        continue block15;
                    }
                    case "file": {
                        byte[] contents = decoder.decode(node.get("data").asText());
                        outputs.add((IOObject)new BufferedFileObject(contents));
                        continue block15;
                    }
                    case "python": {
                        ByteArrayInputStream objectStream = new ByteArrayInputStream(decoder.decode(node.get("data").asText()));
                        IOObject object = SerializationService.getInstance().deserialize(Collections.singletonMap("bin", objectStream), "bin", this.operator);
                        outputs.add(object);
                        continue block15;
                    }
                }
                throw new OperatorException("Unsupported output type: " + type);
            }
            if (root.has("log")) {
                logs = root.get("log").asText();
            }
        }
        return new ResultContainer(outputs, logs);
    }

    @Override
    public void cancel() {
    }

    @Override
    public void registerLogger(Logger logger) {
    }

    private static /* synthetic */ void lambda$run$0(CloseableHttpClient client) {
        client.close(CloseMode.IMMEDIATE);
    }

    static {
        EXIT_CODES.put("parsing-error", PythonExitCode.PARSING_FAILED);
        EXIT_CODES.put("runtime-error", PythonExitCode.EXECUTION_FAILED);
        EXIT_CODES.put("missing-callback", PythonExitCode.EXECUTION_FAILED_NO_RM_MAIN);
        EXIT_CODES.put("unknown-input-type", PythonExitCode.SERIALIZATION_FAILED);
        EXIT_CODES.put("deserialization-error", PythonExitCode.SERIALIZATION_FAILED);
        EXIT_CODES.put("unknown-output-type", PythonExitCode.DESERIALIZATION_FAILED);
        EXIT_CODES.put("serialization-error", PythonExitCode.DESERIALIZATION_FAILED);
    }

    private static final class ResultContainer {
        private final List<IOObject> outputs;
        private final String log;

        private ResultContainer(List<IOObject> outputs, String log) {
            this.outputs = outputs;
            this.log = log;
        }
    }
}

