/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.parameter;

import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonSetupTester;
import com.rapidminer.extension.pythonscripting.parameter.PythonEnvironmentSetupTestingResult;
import com.rapidminer.extension.pythonscripting.parameter.TestActionResult;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.tools.config.actions.ActionResult;
import com.rapidminer.tools.usagestats.ActionStatisticsCollector;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;

public abstract class AbstractEnvironmentSuggestionProvider
implements SuggestionProvider<String> {
    private static final int SHOW_DIALOG_TIMER_DELAY = 2000;

    public ResourceAction getAction() {
        return null;
    }

    public ResourceAction getTestAction() {
        return new ResourceAction("python_scripting.test", new Object[0]){

            protected void loggedActionPerformed(ActionEvent e) {
                String environment = e.getActionCommand();
                TestActionResult result = PythonSetupTester.INSTANCE.scriptingSetupTest(AbstractEnvironmentSuggestionProvider.this.getFullPathForEnvironment(environment));
                if (result != null) {
                    ActionStatisticsCollector.getInstance().log("python", "test", AbstractEnvironmentSuggestionProvider.this.getPackageManagerNameForLogging() + "|" + (result.getResult() == ActionResult.Result.FAILURE ? "error" : "success") + "|" + (result.getErrorKeyForLogging() != null ? result.getErrorKeyForLogging() : ""));
                }
                throw new PythonEnvironmentSetupTestingResult(result);
            }
        };
    }

    protected abstract String getRefreshActionI18nKey();

    protected abstract String getProgressThreadI18nKey();

    protected abstract void runRefreshOperation(ProgressThread var1);

    public ResourceAction getRefreshAction() {
        return new RefreshAction();
    }

    public abstract boolean areFilePathsProvided();

    public abstract String getFullPathForEnvironment(String var1);

    protected abstract String getPackageManagerNameForLogging();

    private final class RefreshAction
    extends ResourceAction {
        private RefreshAction() {
            super(true, AbstractEnvironmentSuggestionProvider.this.getRefreshActionI18nKey(), new Object[0]);
            this.putValue("Name", "");
        }

        public void loggedActionPerformed(ActionEvent e) {
            this.putValue("SwingLargeIconKey", SwingTools.createIcon((String)"16/loading.gif"));
            ProgressThread refreshThread = new ProgressThread(AbstractEnvironmentSuggestionProvider.this.getProgressThreadI18nKey()){

                public void run() {
                    AbstractEnvironmentSuggestionProvider.this.runRefreshOperation(this);
                    SwingUtilities.invokeLater(() -> RefreshAction.this.putValue("SwingLargeIconKey", SwingTools.createIcon((String)"16/refresh.png")));
                }
            };
            refreshThread.setCancelable(false);
            refreshThread.setShowDialogTimerDelay(2000L);
            refreshThread.setStartDialogShowTimer(true);
            refreshThread.setIndeterminate(true);
            refreshThread.start();
        }
    }
}

