/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.ConnectionInformationContainerIOObject;
import com.rapidminer.connection.configuration.ConnectionConfiguration;
import com.rapidminer.connection.valueprovider.handler.ValueProviderHandlerRegistry;
import com.rapidminer.extension.pythonscripting.serialization.Serializer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class ConnectionSerializer
implements Serializer {
    private static final int GCM_IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 128;
    private static final JsonFactory JSON = new JsonFactory();

    @Override
    public void serialize(IOObject resource, OutputStream[] streams, @Nullable Operator op) throws IOException, ProcessStoppedException, UserError {
        this.checkIfCanHandle(resource);
        this.checkNumberOfStreams(streams);
        ConnectionInformationContainerIOObject connection = (ConnectionInformationContainerIOObject)resource;
        ConnectionInformation info = connection.getConnectionInformation();
        ConnectionConfiguration config = info.getConfiguration();
        Map values = ValueProviderHandlerRegistry.getInstance().injectValues(info, op, false);
        try (JsonGenerator generator = JSON.createGenerator(streams[0]);){
            generator.writeStartObject();
            for (Map.Entry entry : values.entrySet()) {
                String key = (String)entry.getKey();
                if (config.getParameter(key) == null) continue;
                String value = (String)entry.getValue();
                if (config.getParameter(key).isEncrypted() && value != null) {
                    String encodedKey = connection.getAnnotations().getAnnotation("serde-key");
                    if (encodedKey == null) {
                        throw new IOException("Connection object lacks encryption key annotation");
                    }
                    generator.writeObjectFieldStart(key);
                    generator.writeStringField("type", "aes-gcm-encrypted-utf8");
                    generator.writeStringField("message", this.encryptSecret(value, encodedKey));
                    generator.writeEndObject();
                    continue;
                }
                generator.writeStringField(key, value);
            }
            generator.writeEndObject();
        }
    }

    private String encryptSecret(String message, String encodedKey) {
        byte[] rawKey = Base64.getDecoder().decode(encodedKey);
        SecretKeySpec key = new SecretKeySpec(rawKey, "AES");
        byte[] iv = new byte[12];
        SecureRandom rng = new SecureRandom();
        rng.nextBytes(iv);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)key, new GCMParameterSpec(128, iv));
            byte[] cipherText = cipher.doFinal(message.getBytes(StandardCharsets.UTF_8));
            byte[] out = Arrays.copyOf(iv, iv.length + cipherText.length);
            System.arraycopy(cipherText, 0, out, iv.length, cipherText.length);
            return Base64.getEncoder().encodeToString(out);
        }
        catch (Exception e) {
            throw new AssertionError("Builtin AES-GCM encryption failed.", e);
        }
    }

    @Override
    public String[] getSerializedFileExtensions() {
        return new String[]{"connection"};
    }

    @Override
    public boolean canHandle(IOObject resource) {
        return resource instanceof ConnectionInformationContainerIOObject;
    }
}

