/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public interface Deserializer {
    public IOObject deserialize(Map<String, InputStream> var1, @Nullable Operator var2) throws IOException, ProcessStoppedException, UserError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public IOObject deserialize(String filePathWithoutExtension, @Nullable Operator op) throws IOException, ProcessStoppedException, UserError {
        HashMap<String, InputStream> streams = new HashMap<String, InputStream>(this.getDeserializableFileExtensions().length);
        try {
            for (String extension : this.getDeserializableFileExtensions()) {
                String filePath = filePathWithoutExtension + "." + extension;
                streams.put(extension, new FileInputStream(filePath));
            }
            IOObject iOObject = this.deserialize(streams, op);
            return iOObject;
        }
        finally {
            for (InputStream stream : streams.values()) {
                if (stream == null) continue;
                stream.close();
            }
        }
    }

    public String[] getDeserializableFileExtensions();

    default public String getPrimaryDeserializableFileExtension() {
        return this.getDeserializableFileExtensions()[0];
    }

    default public void validateStreams(Map<String, InputStream> streams) {
        Object[] extensions = this.getDeserializableFileExtensions();
        if (streams.size() != extensions.length) {
            throw new IllegalArgumentException("Deserializer " + this.getClass().getCanonicalName() + " expects " + extensions.length + " input streams, but received " + streams.size() + ".");
        }
        if (!Stream.of(extensions).allMatch(streams::containsKey)) {
            throw new IllegalArgumentException("Deserializer " + this.getClass().getCanonicalName() + " expects input streams with extensions: " + Arrays.toString(extensions));
        }
    }

    default public int checkForStop(@Nullable Operator op, int counter) throws ProcessStoppedException {
        if (op != null && (counter = (counter + 1) % 10000) == 0) {
            op.checkForStop();
        }
        return counter;
    }
}

