/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonDecimalFormat;
import com.rapidminer.extension.pythonscripting.serialization.MetadataJsonDeserializer;
import com.rapidminer.extension.pythonscripting.serialization.SerializedCSVExampleSource;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nullable;

public class ExampleSetCSVDeserializer
extends MetadataJsonDeserializer {
    @Override
    public IOObject deserialize(Map<String, InputStream> streams, @Nullable Operator op) throws IOException {
        this.validateStreams(streams);
        try {
            SerializedCSVExampleSource csvSource = new SerializedCSVExampleSource();
            csvSource.setInputStream(streams.get("csv"));
            csvSource.setParameter("column_separators", ",");
            csvSource.setParameter("csv_file", "");
            csvSource.setParameter("encoding", StandardCharsets.UTF_8.name());
            csvSource.setParameter("date_format", "yyyy-MM-dd HH:mm:ss.SSS");
            csvSource.setNumberFormat(new PythonDecimalFormat());
            csvSource.setMetadata(this.readMetadataFromStream(streams.get("pmd")));
            csvSource.setCompatibilityLevel(op.getCompatibilityLevel());
            return csvSource.createExampleSet();
        }
        catch (OperatorException e) {
            e.printStackTrace();
            throw new IOException("Deserialization failed", e);
        }
    }

    @Override
    public String[] getDeserializableFileExtensions() {
        return new String[]{"csv", "pmd"};
    }
}

