/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.pythonscripting.serialization.MetadataJsonSerializer;
import com.rapidminer.extension.pythonscripting.serialization.PythonCSVExampleSetWriter;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.io.CSVExampleSetWriter;
import com.rapidminer.tools.OperatorService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.annotation.Nullable;

public class ExampleSetCSVSerializer
extends MetadataJsonSerializer {
    public static final String DATE_TIME_FORMAT_YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_TIME_FORMAT_YYYY_MM_DD_HH_MM_SS_SSS));

    @Override
    public void serialize(IOObject resource, OutputStream[] streams, @Nullable Operator op) throws IOException {
        this.checkIfCanHandle(resource);
        this.checkNumberOfStreams(streams);
        ExampleSet es = (ExampleSet)resource;
        PrintWriter printer = new PrintWriter(new OutputStreamWriter(streams[0], StandardCharsets.UTF_8));
        try {
            OperatorDescription opDesc = OperatorService.getOperatorDescriptions(CSVExampleSetWriter.class)[0];
            PythonCSVExampleSetWriter writer = new PythonCSVExampleSetWriter(opDesc);
            writer.writeCSV(es, printer, DATE_FORMAT.get(), op == null ? null : op.getProgress());
        }
        catch (ProcessStoppedException e) {
            throw new IOException("Error during serialization: " + e.getMessage(), e);
        }
        printer.flush();
        this.writeMetaData(es, new PrintWriter(new OutputStreamWriter(streams[1], StandardCharsets.UTF_8)));
    }

    @Override
    public String[] getSerializedFileExtensions() {
        return new String[]{"csv", "pmd"};
    }

    @Override
    public boolean canHandle(IOObject resource) {
        return resource instanceof ExampleSet;
    }
}

