/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeTypeException;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.utils.ExampleSetBuilder;
import com.rapidminer.example.utils.ExampleSets;
import com.rapidminer.extension.pythonscripting.serialization.MetadataJsonDeserializer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExampleSetEncodedCsvDeserializer
extends MetadataJsonDeserializer {
    private static final int BUFFER_LENGTH = 4096;

    private static double getDoubleValue(Operator op, String value, Attribute attr) throws UserError, AttributeTypeException {
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attr.getValueType(), 1)) {
            String strValue;
            if (value == null || "null".equals(value)) {
                return Double.NaN;
            }
            try {
                strValue = new String(Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                throw new UserError(op, "python_scripting.nominal_b64", new Object[]{attr.getName(), value, e.getMessage()});
            }
            return attr.getMapping().mapString(strValue);
        }
        if (value == null || value.isEmpty() || "null".equals(value)) {
            return Double.NaN;
        }
        if ("inf".equals(value)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-inf".equals(value)) {
            return Double.NEGATIVE_INFINITY;
        }
        try {
            Double d = Double.parseDouble(value);
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attr.getValueType(), 9)) {
                d = d / 1000.0;
            }
            return d;
        }
        catch (NumberFormatException e) {
            throw new UserError(op, "python_scripting.number_format", new Object[]{attr.getName(), value});
        }
    }

    @Override
    public IOObject deserialize(Map<String, InputStream> streams, @Nullable Operator op) throws ProcessStoppedException, IOException, UserError {
        JSONObject json;
        this.validateStreams(streams);
        try (Scanner input = new Scanner(streams.get("pmd-encoded"));){
            input.useDelimiter("\\A");
            json = new JSONObject(input.hasNext() ? input.next() : "{}");
        }
        JSONArray metadata = json.getJSONArray("metadata");
        List<String[]> parsedMetadata = this.readMetadataFromArray(metadata);
        List<Attribute> attributes = this.createAttributesFromMetadata(parsedMetadata);
        ExampleSetBuilder builder = ExampleSets.from(attributes);
        this.setRoles(builder, parsedMetadata, attributes);
        InputStreamReader input = new InputStreamReader(streams.get("csv-encoded"));
        this.processDataStream(op, builder, input, attributes);
        return builder.build();
    }

    @Override
    public String[] getDeserializableFileExtensions() {
        return new String[]{"csv-encoded", "pmd-encoded"};
    }

    protected void processDataStream(Operator op, ExampleSetBuilder builder, Reader input, List<Attribute> attributes) throws IOException, UserError, ProcessStoppedException {
        if (attributes.size() == 0) {
            return;
        }
        int progressCounter = 0;
        char[] buffer = new char[4096];
        double[] dataArray = new double[attributes.size()];
        int fieldIndex = 0;
        StringBuilder field = new StringBuilder();
        progressCounter = this.checkForStop(op, progressCounter);
        int numChars = input.read(buffer);
        while (numChars > 0) {
            block6: for (int index = 0; index < numChars; ++index) {
                char c = buffer[index];
                switch (c) {
                    case '\n': {
                        dataArray[fieldIndex] = ExampleSetEncodedCsvDeserializer.getDoubleValue(op, field.toString(), attributes.get(fieldIndex));
                        field.setLength(0);
                        fieldIndex = 0;
                        builder.addRow(dataArray);
                        continue block6;
                    }
                    case '\r': {
                        continue block6;
                    }
                    case ',': {
                        dataArray[fieldIndex] = ExampleSetEncodedCsvDeserializer.getDoubleValue(op, field.toString(), attributes.get(fieldIndex));
                        field.setLength(0);
                        ++fieldIndex;
                        continue block6;
                    }
                    default: {
                        field.append(c);
                    }
                }
            }
            progressCounter = this.checkForStop(op, progressCounter);
            numChars = input.read(buffer);
        }
        if (field.length() > 0) {
            dataArray[fieldIndex] = ExampleSetEncodedCsvDeserializer.getDoubleValue(op, field.toString(), attributes.get(fieldIndex));
            builder.addRow(dataArray);
        }
    }

    private List<Attribute> createAttributesFromMetadata(List<String[]> metadata) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (String[] attrInfo : metadata) {
            String valueTypeName;
            String name = attrInfo[0];
            int valueType = 7;
            if (attrInfo[1] != null && (valueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(valueTypeName = attrInfo[1].trim())) < 0) {
                LogService.getRoot().fine(String.format("Unknown type for attribute '%s': %s", name, valueTypeName));
                valueType = 7;
            }
            Attribute attr = AttributeFactory.createAttribute((String)name, (int)valueType);
            attributes.add(attr);
        }
        return attributes;
    }

    private void setRoles(ExampleSetBuilder builder, List<String[]> metadata, List<Attribute> attributes) {
        for (int i = 0; i < metadata.size(); ++i) {
            String[] attrInfo = metadata.get(i);
            Attribute attr = attributes.get(i);
            if ("attribute".equals(attrInfo[2])) continue;
            builder.withRole(attr, attrInfo[2]);
        }
    }
}

