/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.pythonscripting.PluginInitPythonScripting;
import com.rapidminer.extension.pythonscripting.serialization.MetadataJsonSerializer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.tools.Ontology;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import javax.annotation.Nullable;

@Deprecated
public class ExampleSetEncodedCsvSerializer
extends MetadataJsonSerializer {
    @Override
    public void serialize(IOObject resource, OutputStream[] streams, @Nullable Operator op) throws IOException, ProcessStoppedException {
        this.checkIfCanHandle(resource);
        this.checkNumberOfStreams(streams);
        ExampleSet es = (ExampleSet)resource;
        PrintWriter printer = new PrintWriter(new OutputStreamWriter(streams[1], StandardCharsets.UTF_8));
        printer.write("{\n");
        printer.write("  \"source\": \"RapidMiner Python Scripting Extension\",\n");
        printer.write("  \"module\": \"Java\",\n");
        printer.write("  \"version\": \"" + PluginInitPythonScripting.getVersion() + "\",\n");
        printer.write("  \"metadata\":\n");
        this.writeMetaData(es, printer, true);
        printer.write("\n}");
        printer.flush();
        printer = new PrintWriter(new OutputStreamWriter(streams[0], StandardCharsets.UTF_8));
        this.writeData(es, printer, op);
        printer.flush();
    }

    @Override
    public String[] getSerializedFileExtensions() {
        return new String[]{"csv-encoded", "pmd-encoded"};
    }

    @Override
    public boolean canHandle(IOObject resource) {
        return resource instanceof ExampleSet;
    }

    private static String getField(Example ex, Attribute attr) {
        double val = ex.getValue(attr);
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attr.getValueType(), 2)) {
            if (Double.isNaN(val)) {
                return "";
            }
            if (Double.isInfinite(val) && val > 0.0) {
                return "\"inf\"";
            }
            if (Double.isInfinite(val) && val < 0.0) {
                return "\"-inf\"";
            }
            if (attr.getValueType() == 3) {
                long value = (long)ex.getValue(attr);
                return Long.toString(value);
            }
            return ex.getValueAsString(attr);
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attr.getValueType(), 1)) {
            if (Double.isNaN(val)) {
                return "null";
            }
            return new String(Base64.getEncoder().encode(ex.getValueAsString(attr).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        if (Double.isNaN(val)) {
            return "null";
        }
        long value = (long)ex.getValue(attr);
        return Long.toString(value *= 1000L);
    }

    private void writeData(ExampleSet es, PrintWriter printer, @Nullable Operator op) throws ProcessStoppedException {
        Attributes attrs = es.getAttributes();
        Attribute[] firstAttr = new Attribute[]{null};
        ArrayList remainingAttrs = new ArrayList();
        attrs.allAttributes().forEachRemaining(attr -> {
            if (firstAttr[0] == null) {
                firstAttr[0] = attr;
            } else {
                remainingAttrs.add(attr);
            }
        });
        int progressCounter = 0;
        if (firstAttr[0] == null) {
            for (Example ignored : es) {
                printer.write("\n");
                progressCounter = this.checkForStop(op, progressCounter);
            }
        } else {
            for (Example ex : es) {
                printer.write(ExampleSetEncodedCsvSerializer.getField(ex, firstAttr[0]));
                for (Attribute attr2 : remainingAttrs) {
                    printer.write(",");
                    printer.write(ExampleSetEncodedCsvSerializer.getField(ex, attr2));
                }
                printer.write("\n");
                progressCounter = this.checkForStop(op, progressCounter);
            }
        }
    }
}

