/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.RapidMiner;
import com.rapidminer.extension.pythonscripting.serialization.Deserializer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.BufferedFileObject;
import com.rapidminer.operator.nio.file.SimpleFileObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Scanner;
import javax.annotation.Nullable;

public class FileObjectDeserializer
implements Deserializer {
    @Override
    public IOObject deserialize(Map<String, InputStream> streams, @Nullable Operator op) throws IOException {
        this.validateStreams(streams);
        try (Scanner s = new Scanner(streams.get("foi"), StandardCharsets.UTF_8);){
            s.useDelimiter("\\A");
            if (!s.hasNext()) {
                throw new FileNotFoundException("Empty path specified.");
            }
            SimpleFileObject simpleFileObject = new SimpleFileObject(new File(s.next()));
            return simpleFileObject;
        }
    }

    @Override
    public IOObject deserialize(String filePathWithoutExtension, @Nullable Operator op) throws IOException, UserError {
        Path workingDirectory;
        Path foiFile = new File(filePathWithoutExtension + "." + this.getDeserializableFileExtensions()[0]).toPath();
        String path = new String(Files.readAllBytes(foiFile), StandardCharsets.UTF_8);
        Path fileOfInterest = Paths.get(path, new String[0]);
        if (fileOfInterest.startsWith(workingDirectory = foiFile.getParent()) || fileOfInterest.getParent() == null) {
            if (fileOfInterest.getParent() == null) {
                fileOfInterest = Paths.get(workingDirectory.toString(), fileOfInterest.toString());
            }
            if (RapidMiner.getExecutionMode().isHeadless()) {
                if (Files.size(fileOfInterest) > 0x7FFFFFF7L) {
                    throw new UserError(op, "python_scripting.deserialization.file_size");
                }
                return new BufferedFileObject(Files.readAllBytes(fileOfInterest));
            }
            String name = fileOfInterest.getFileName().toString();
            Path destinationFile = Files.createTempFile("scripting-studio-", "-" + name, new FileAttribute[0]);
            Files.move(fileOfInterest, destinationFile, StandardCopyOption.REPLACE_EXISTING);
            destinationFile.toFile().deleteOnExit();
            return new SimpleFileObject(destinationFile.toFile());
        }
        return new SimpleFileObject(fileOfInterest.toFile());
    }

    @Override
    public String[] getDeserializableFileExtensions() {
        return new String[]{"foi"};
    }
}

