/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.extension.pythonscripting.serialization.Serializer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.BufferedFileObject;
import com.rapidminer.operator.nio.file.FileObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;

public class FileObjectSerializer
implements Serializer {
    @Override
    public void serialize(IOObject object, OutputStream[] streams, @Nullable Operator op) throws IOException, UserError {
        String path;
        this.checkIfCanHandle(object);
        this.checkNumberOfStreams(streams);
        if (object instanceof BufferedFileObject) {
            BufferedFileObject bufferedFile = (BufferedFileObject)object;
            Path tempFile = Files.createTempFile("rm_file_", ".dump", new FileAttribute[0]);
            try (ByteArrayInputStream stream = bufferedFile.openStream();){
                Files.copy(stream, tempFile, StandardCopyOption.REPLACE_EXISTING);
            }
            path = tempFile.toString();
        } else {
            FileObject foiFile = (FileObject)object;
            try {
                path = foiFile.getFile().getAbsolutePath();
            }
            catch (OperatorException e) {
                throw new UserError(op, (Throwable)e, "python_scripting.serialization", new Object[]{e.getMessage()});
            }
        }
        try (PrintWriter printer = new PrintWriter(new OutputStreamWriter(streams[0], StandardCharsets.UTF_8));){
            printer.print(path);
            printer.flush();
        }
    }

    @Override
    public String[] getSerializedFileExtensions() {
        return new String[]{"foi"};
    }

    @Override
    public boolean canHandle(IOObject resource) {
        return resource instanceof FileObject;
    }
}

