/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.extension.pythonscripting.serialization.Deserializer;
import com.rapidminer.extension.pythonscripting.serialization.SerializationService;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.nio.file.SimpleFileObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;

public class FoFileObjectDeserializer
implements Deserializer {
    private SerializationService service;
    private static int BUFF_SIZE = 1024;

    public FoFileObjectDeserializer(SerializationService service) {
        this.service = service;
    }

    @Override
    public IOObject deserialize(Map<String, InputStream> streams, @Nullable Operator op) throws IOException {
        this.validateStreams(streams);
        byte[] buff = new byte[BUFF_SIZE];
        InputStream in = streams.get("fo");
        File f = this.service.createTempFile(this.getPrimaryDeserializableFileExtension()).toFile();
        try (FileOutputStream out = new FileOutputStream(f);){
            int num = in.read(buff);
            while (num >= 0) {
                ((OutputStream)out).write(buff, 0, num);
                num = in.read(buff);
            }
            SimpleFileObject simpleFileObject = new SimpleFileObject(f);
            return simpleFileObject;
        }
    }

    @Override
    public String[] getDeserializableFileExtensions() {
        return new String[]{"fo"};
    }
}

