/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.extension.pythonscripting.serialization.Serializer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.file.FileObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class FoFileObjectSerializer
implements Serializer {
    private static final int BUFF_SIZE = 1024;

    @Override
    public void serialize(IOObject resource, OutputStream[] streams, @Nullable Operator op) throws IOException {
        this.checkIfCanHandle(resource);
        this.checkNumberOfStreams(streams);
        FileObject fo = (FileObject)resource;
        try (InputStream in = fo.openStream();){
            byte[] buf = new byte[1024];
            int num = in.read(buf);
            while (num >= 0) {
                streams[0].write(buf, 0, num);
                num = in.read(buf);
            }
        }
        catch (OperatorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String[] getSerializedFileExtensions() {
        return new String[]{"fo"};
    }

    @Override
    public boolean canHandle(IOObject resource) {
        return resource instanceof FileObject;
    }
}

