/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.MacroHandler;
import com.rapidminer.operator.AbstractIOObject;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.Operator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MacrosIOObject
extends AbstractIOObject {
    private static final long serialVersionUID = 987771134877729217L;
    private transient Operator operator;
    private transient MacroHandler handler;
    private Map<String, String> macros;

    public Annotations getAnnotations() {
        return new Annotations();
    }

    public MacrosIOObject(Operator operator) {
        this(operator, null);
    }

    public MacrosIOObject(Operator operator, Map<String, String> macros) {
        this.setOperator(operator);
        this.macros = macros != null ? macros : this.loadMacrosFromHandler(this.handler);
    }

    public Map<String, String> getAllMacros() {
        return this.macros;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
        this.handler = operator != null ? operator.getProcess().getMacroHandler() : null;
    }

    public void updateDefinedMacros() {
        if (this.handler == null || this.macros == null) {
            return;
        }
        HashMap<String, String> macrosCopy = new HashMap<String, String>(this.macros);
        Arrays.stream(this.handler.getAllPredefinedMacros()).forEach(macrosCopy::remove);
        macrosCopy.entrySet().forEach(e -> this.handler.addMacro((String)e.getKey(), (String)e.getValue()));
    }

    private Map<String, String> loadMacrosFromHandler(MacroHandler handler) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (handler == null) {
            return result;
        }
        Iterator it = handler.getDefinedMacroNames();
        while (it.hasNext()) {
            String macro = (String)it.next();
            String macroValue = handler.getMacro(macro);
            result.put(macro, macroValue);
        }
        if (this.operator != null) {
            for (String macro : handler.getAllPredefinedMacros()) {
                if ("p[]".equals(macro) || "v[]".equals(macro)) continue;
                String macroValue = handler.getMacro(macro, this.operator);
                if (macroValue == null) {
                    macroValue = "";
                }
                result.put(macro, macroValue);
            }
        }
        return result;
    }
}

