/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.extension.pythonscripting.serialization.MacrosIOObject;
import com.rapidminer.extension.pythonscripting.serialization.Serializer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class MacrosToJsonSerializer
implements Serializer {
    @Override
    public void serialize(IOObject resource, OutputStream[] streams, @Nullable Operator operator) throws IOException {
        this.checkIfCanHandle(resource);
        this.checkNumberOfStreams(streams);
        MacrosIOObject macros = (MacrosIOObject)resource;
        PrintWriter printer = new PrintWriter(new OutputStreamWriter(streams[0], StandardCharsets.UTF_8));
        this.writeMacros(macros, printer);
        printer.flush();
    }

    @Override
    public String[] getSerializedFileExtensions() {
        return new String[]{"json-macros"};
    }

    @Override
    public boolean canHandle(IOObject resource) {
        return resource instanceof MacrosIOObject;
    }

    private void writeMacros(MacrosIOObject macros, PrintWriter printer) {
        JSONObject obj = new JSONObject();
        for (Map.Entry<String, String> macroEntry : macros.getAllMacros().entrySet()) {
            obj.put(macroEntry.getKey(), (Object)macroEntry.getValue());
        }
        printer.write(obj.toString(2));
    }
}

