/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.pythonscripting.serialization.Serializer;
import com.rapidminer.tools.Ontology;
import java.io.PrintWriter;
import java.util.Iterator;

public abstract class MetadataJsonSerializer
implements Serializer {
    protected void writeMetaData(ExampleSet exampleSet, PrintWriter printer) {
        this.writeMetaData(exampleSet, printer, false);
    }

    private static String escapeChars(String str, boolean newFormat) {
        if (newFormat) {
            return str.replace("\\", "\\\\").replace("\"", "\\\"");
        }
        return str.replace("\"", "'");
    }

    protected void writeMetaData(ExampleSet exampleSet, PrintWriter printer, boolean newFormat) {
        String attrEnd;
        String attrStart;
        String mdEnd;
        String mdStart;
        if (newFormat) {
            mdStart = "[";
            mdEnd = "]";
            attrStart = "{";
            attrEnd = "}";
        } else {
            mdStart = "{";
            mdEnd = "}";
            attrStart = "";
            attrEnd = "";
        }
        printer.print(mdStart);
        Iterator a = exampleSet.getAttributes().allAttributes();
        boolean first = true;
        while (a.hasNext()) {
            if (!first) {
                printer.print(", ");
            } else {
                first = false;
            }
            printer.print(attrStart);
            Attribute attribute = (Attribute)a.next();
            String attributeName = MetadataJsonSerializer.escapeChars(attribute.getName(), newFormat);
            printer.print("\"" + attributeName + "\"");
            printer.print(": [");
            String valueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(attribute.getValueType());
            printer.print("\"" + valueType + "\"");
            printer.print(", ");
            AttributeRole role = exampleSet.getAttributes().findRoleByName(attribute.getName());
            String roleName = role == null || role.getSpecialName() == null ? "attribute" : MetadataJsonSerializer.escapeChars(role.getSpecialName(), newFormat);
            printer.print("\"" + roleName + "\"");
            printer.print("]");
            printer.print(attrEnd);
        }
        printer.print(mdEnd);
        printer.flush();
    }
}

