/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonNativeObject;
import com.rapidminer.extension.pythonscripting.serialization.Deserializer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Map;
import javax.annotation.Nullable;

public class PythonObjectDeserializer
implements Deserializer {
    @Override
    public IOObject deserialize(Map<String, InputStream> streams, @Nullable Operator op) throws IOException {
        this.validateStreams(streams);
        return new PythonNativeObject(streams.get("bin"));
    }

    @Override
    public IOObject deserialize(String filePathWithoutExtension, @Nullable Operator op) throws IOException, ProcessStoppedException, UserError {
        if (Files.size(new File(filePathWithoutExtension + "." + this.getDeserializableFileExtensions()[0]).toPath()) > 0x7FFFFFF7L) {
            throw new UserError(op, "python_scripting.deserialization.file_size");
        }
        return Deserializer.super.deserialize(filePathWithoutExtension, op);
    }

    @Override
    public String[] getDeserializableFileExtensions() {
        return new String[]{"bin"};
    }
}

