/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonNativeObject;
import com.rapidminer.extension.pythonscripting.serialization.Serializer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class PythonObjectSerializer
implements Serializer {
    private static final int BUFF_SIZE = 1024;

    @Override
    public void serialize(IOObject resource, OutputStream[] streams, @Nullable Operator op) throws IOException {
        this.canHandle(resource);
        this.checkNumberOfStreams(streams);
        PythonNativeObject pythonObject = (PythonNativeObject)resource;
        try (ByteArrayInputStream inputStream = pythonObject.openStream();){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                streams[0].write(buffer, 0, len);
            }
        }
    }

    @Override
    public String[] getSerializedFileExtensions() {
        return new String[]{"bin"};
    }

    @Override
    public boolean canHandle(IOObject resource) {
        return resource instanceof PythonNativeObject;
    }
}

