/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.extension.pythonscripting.operator.scripting.python.PythonScriptingOperator;
import com.rapidminer.extension.pythonscripting.serialization.ConnectionSerializer;
import com.rapidminer.extension.pythonscripting.serialization.Deserializer;
import com.rapidminer.extension.pythonscripting.serialization.DummyDeserializer;
import com.rapidminer.extension.pythonscripting.serialization.ExampleSetCSVDeserializer;
import com.rapidminer.extension.pythonscripting.serialization.ExampleSetCSVSerializer;
import com.rapidminer.extension.pythonscripting.serialization.ExampleSetEncodedCsvDeserializer;
import com.rapidminer.extension.pythonscripting.serialization.FileObjectDeserializer;
import com.rapidminer.extension.pythonscripting.serialization.FileObjectSerializer;
import com.rapidminer.extension.pythonscripting.serialization.FoFileObjectDeserializer;
import com.rapidminer.extension.pythonscripting.serialization.FoFileObjectSerializer;
import com.rapidminer.extension.pythonscripting.serialization.Hdf5Deserializer;
import com.rapidminer.extension.pythonscripting.serialization.IOObjectDeserializer;
import com.rapidminer.extension.pythonscripting.serialization.IOObjectSerializer;
import com.rapidminer.extension.pythonscripting.serialization.MacrosFromJsonDeserializer;
import com.rapidminer.extension.pythonscripting.serialization.MacrosToJsonSerializer;
import com.rapidminer.extension.pythonscripting.serialization.PythonObjectDeserializer;
import com.rapidminer.extension.pythonscripting.serialization.PythonObjectSerializer;
import com.rapidminer.extension.pythonscripting.serialization.Serializer;
import com.rapidminer.extension.pythonscripting.serialization.TabularDataToEncodedCsvSerializer;
import com.rapidminer.extension.pythonscripting.serialization.arrow.TabularDataToArrowDeserializer;
import com.rapidminer.extension.pythonscripting.serialization.arrow.TabularDataToArrowSerializer;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryLocationBuilder;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.XMLException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class SerializationService {
    public static final String REPOSITORY_LOCATION_PREFIX = "repositorylocation:";
    public static final String FILE_PREFIX = "file:";
    private static final String OUTPUT_FILE_NAME = "converted";
    private static final String ILLEGAL_PREFIX_MSG = "Illegal prefix or no prefix specified for entry.";
    private static final SerializationService INSTANCE = new SerializationService();
    private final Map<String, Serializer> serializers = new LinkedHashMap<String, Serializer>();
    private final Map<String, Deserializer> deserializers = new LinkedHashMap<String, Deserializer>();
    private Path tempDir;

    private SerializationService() {
        this.registerSerializers();
        this.registerDeserializers();
    }

    public static SerializationService getInstance() {
        return INSTANCE;
    }

    public void serialize(IOObject resource, String format, OutputStream[] outputStreams, @Nullable Operator operator) throws IOException, ProcessStoppedException, UserError {
        Serializer serializer = this.serializers.get(format.toLowerCase());
        if (serializer == null) {
            throw new NoSuchElementException("No serializer found for format: " + format);
        }
        serializer.serialize(resource, outputStreams, operator);
    }

    public void serialize(IOObject resource, String entry, @Nullable Operator operator) throws IOException, MalformedRepositoryLocationException, RepositoryException, ProcessStoppedException, UserError {
        if (entry.startsWith(REPOSITORY_LOCATION_PREFIX)) {
            this.serializeToRepository(resource, entry.substring(REPOSITORY_LOCATION_PREFIX.length()));
        } else if (entry.startsWith(FILE_PREFIX)) {
            this.serializeToFileLocation(resource, entry.substring(FILE_PREFIX.length()), operator);
        } else {
            throw new IllegalArgumentException(ILLEGAL_PREFIX_MSG);
        }
    }

    private void serializeToFile(IOObject resource, Path filePath, @Nullable Operator operator) throws IOException, ProcessStoppedException, UserError {
        Serializer serializer;
        String extensionFromFileName;
        String fileName = filePath.toAbsolutePath().toString();
        boolean arrowSerializationUsed = operator != null && operator.getCompatibilityLevel().isAbove((VersionNumber)PythonScriptingOperator.VERSION_ARROW_SERIALIZATION);
        String extensionForResource = this.getPrimaryExtensionForResource(resource, arrowSerializationUsed);
        String baseFilePath = filePath.toString();
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex != -1 && this.serializers.containsKey(extensionFromFileName = fileName.substring(extensionIndex + 1).toLowerCase())) {
            extensionForResource = extensionFromFileName;
            baseFilePath = fileName.substring(0, extensionIndex);
        }
        if ((serializer = this.serializers.get(extensionForResource)) == null) {
            throw new NoSuchElementException("No serializer found for extension: " + extensionForResource);
        }
        serializer.serialize(resource, baseFilePath, operator);
    }

    public String[] getSerializedFileExtensionsForResource(IOObject resource, boolean arrowSerializationUsed) {
        return this.serializers.values().stream().filter(serializer -> serializer.canHandle(resource)).filter(serializer -> arrowSerializationUsed || !(serializer instanceof TabularDataToArrowSerializer)).findFirst().orElseThrow(() -> new IllegalArgumentException("Object type not supported for serialization: " + resource.getClass().getCanonicalName())).getSerializedFileExtensions();
    }

    public String getSupportedFormat(String extension) {
        return this.deserializers.values().stream().filter(deserializer -> Stream.of(deserializer.getDeserializableFileExtensions()).anyMatch(ext -> ext.equalsIgnoreCase(extension))).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported file extension: " + extension)).getPrimaryDeserializableFileExtension();
    }

    public IOObject deserialize(Map<String, InputStream> inputStreams, String extension, @Nullable Operator operator) throws IOException, ProcessStoppedException, UserError {
        Deserializer deserializer = this.deserializers.get(extension.toLowerCase());
        if (deserializer == null) {
            throw new NoSuchElementException("No deserializer found for extension: " + extension);
        }
        return deserializer.deserialize(inputStreams, operator);
    }

    public IOObject deserialize(String entry, @Nullable Operator operator) throws IOException, MalformedRepositoryLocationException, RepositoryException, ProcessStoppedException, UserError {
        if (entry.startsWith(REPOSITORY_LOCATION_PREFIX)) {
            return this.deserializeFromRepository(entry.substring(REPOSITORY_LOCATION_PREFIX.length()));
        }
        if (entry.startsWith(FILE_PREFIX)) {
            return this.deserializeFromFileLocation(entry.substring(FILE_PREFIX.length()), operator);
        }
        throw new IllegalArgumentException(ILLEGAL_PREFIX_MSG);
    }

    public Process loadProcess(String processEntry) throws XMLException, MalformedRepositoryLocationException, IOException {
        try {
            if (processEntry.startsWith(FILE_PREFIX)) {
                return this.loadProcessFromFile(processEntry.substring(FILE_PREFIX.length()));
            }
            if (processEntry.startsWith(REPOSITORY_LOCATION_PREFIX)) {
                return this.loadProcessFromRepository(processEntry.substring(REPOSITORY_LOCATION_PREFIX.length()));
            }
            throw new IllegalArgumentException(ILLEGAL_PREFIX_MSG);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.rapidminer.RapidMinerCommandLine.reading_process_setup_error", (Object[])new Object[]{processEntry, e.getMessage()}), e);
            throw e;
        }
    }

    public Path createTempFile(String extension) throws IOException {
        Path directory = this.getTempDirectory();
        Object suffix = extension.isEmpty() ? "" : "." + extension;
        return Files.createTempFile(directory, null, (String)suffix, new FileAttribute[0]);
    }

    public void setTempDir(Path directory) {
        if (this.tempDir != null) {
            throw new IllegalArgumentException("Temporary directory is already set.");
        }
        if (!directory.toFile().isDirectory()) {
            throw new IllegalArgumentException("Provided path is not a directory: " + directory);
        }
        this.tempDir = directory;
    }

    private void registerSerializers() {
        this.registerSerializer(new TabularDataToArrowSerializer());
        this.registerSerializer(new TabularDataToEncodedCsvSerializer());
        this.registerSerializer(new ExampleSetCSVSerializer());
        this.registerSerializer(new PythonObjectSerializer());
        this.registerSerializer(new FoFileObjectSerializer());
        this.registerSerializer(new FileObjectSerializer());
        this.registerSerializer(new ConnectionSerializer());
        this.registerSerializer(new MacrosToJsonSerializer());
        this.registerSerializer(new IOObjectSerializer());
    }

    private void registerDeserializers() {
        this.registerDeserializer(new TabularDataToArrowDeserializer());
        this.registerDeserializer(new ExampleSetEncodedCsvDeserializer());
        this.registerDeserializer(new ExampleSetCSVDeserializer());
        this.registerDeserializer(new Hdf5Deserializer());
        this.registerDeserializer(new PythonObjectDeserializer());
        this.registerDeserializer(new FoFileObjectDeserializer(this));
        this.registerDeserializer(new FileObjectDeserializer());
        this.registerDeserializer(new MacrosFromJsonDeserializer());
        this.registerDeserializer(new IOObjectDeserializer());
        this.registerDeserializer(new DummyDeserializer("pmd"));
        this.registerDeserializer(new DummyDeserializer("pmd-encoded"));
    }

    private void registerSerializer(Serializer serializer) {
        String format = serializer.getPrimarySerializedFileExtension().toLowerCase();
        if (this.serializers.containsKey(format)) {
            throw new IllegalStateException("Serializer for format '" + format + "' is already registered.");
        }
        this.serializers.put(format, serializer);
    }

    private void registerDeserializer(Deserializer deserializer) {
        String format = deserializer.getPrimaryDeserializableFileExtension().toLowerCase();
        if (this.deserializers.containsKey(format)) {
            throw new IllegalStateException("Deserializer for format '" + format + "' is already registered.");
        }
        this.deserializers.put(format, deserializer);
    }

    private String getPrimaryExtensionForResource(IOObject resource, boolean arrowSerializationUsed) {
        return this.serializers.values().stream().filter(serializer -> serializer.canHandle(resource)).filter(serializer -> arrowSerializationUsed || !(serializer instanceof TabularDataToArrowSerializer)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported IOObject type for serialization.")).getPrimarySerializedFileExtension();
    }

    private void serializeToRepository(IOObject resource, String repositoryPath) throws MalformedRepositoryLocationException, RepositoryException {
        RepositoryLocation location = new RepositoryLocationBuilder().buildFromAbsoluteLocation(repositoryPath);
        Folder parentFolder = location.parent().createFoldersRecursively();
        parentFolder.createIOObjectEntry(location.getName(), resource, null, null);
    }

    private void serializeToFileLocation(IOObject resource, String filePath, @Nullable Operator operator) throws IOException, ProcessStoppedException, UserError {
        Path path = Paths.get(filePath, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.serializeToFile(resource, path.resolve(OUTPUT_FILE_NAME), operator);
        } else {
            this.serializeToFile(resource, path, operator);
        }
    }

    private IOObject deserializeFromRepository(String repositoryPath) throws RepositoryException, MalformedRepositoryLocationException {
        RepositoryLocation location = new RepositoryLocationBuilder().buildFromAbsoluteLocation(repositoryPath);
        DataEntry dataEntry = location.locateData();
        if (dataEntry == null) {
            throw new IllegalArgumentException("Repository entry does not exist: " + repositoryPath);
        }
        return this.deserializeRepositoryEntry((Entry)dataEntry);
    }

    private IOObject deserializeFromFileLocation(String filePath, @Nullable Operator operator) throws IOException, ProcessStoppedException, UserError {
        Path path = Paths.get(filePath, new String[0]);
        return this.deserializeFile(path, operator);
    }

    private IOObject deserializeRepositoryEntry(Entry entry) throws RepositoryException {
        if (entry instanceof IOObjectEntry) {
            IOObjectEntry ioObjectEntry = (IOObjectEntry)entry;
            return ioObjectEntry.retrieveData(null);
        }
        throw new UnsupportedOperationException("Unsupported repository entry type: " + entry.getClass().getSimpleName());
    }

    private IOObject deserializeFile(Path filePath, @Nullable Operator operator) throws IOException, ProcessStoppedException, UserError {
        String fileName = filePath.toAbsolutePath().toString();
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex == -1) {
            throw new IllegalArgumentException("No file extension is provided, cannot determine the type of serialization for file: " + filePath);
        }
        String format = fileName.substring(extensionIndex + 1).toLowerCase();
        String baseFilePath = fileName.substring(0, extensionIndex);
        Deserializer deserializer = this.deserializers.get(format);
        if (deserializer == null) {
            throw new NoSuchElementException("No deserializer found for file type: " + format);
        }
        return deserializer.deserialize(baseFilePath, operator);
    }

    private Process loadProcessFromFile(String filePath) throws XMLException, IOException {
        File file = new File(filePath);
        return RapidMiner.readProcessFile((File)file);
    }

    private Process loadProcessFromRepository(String repositoryPath) throws MalformedRepositoryLocationException, XMLException, IOException {
        RepositoryLocation repoLocation = new RepositoryLocationBuilder().buildFromAbsoluteLocation(repositoryPath);
        RepositoryProcessLocation processLocation = new RepositoryProcessLocation(repoLocation);
        return processLocation.load(null);
    }

    private Path getTempDirectory() {
        if (this.tempDir == null) {
            throw new IllegalStateException("Temporary directory is not set for serialization tasks.");
        }
        return this.tempDir;
    }
}

