/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.CSVExampleSource;
import com.rapidminer.operator.nio.model.AbstractDataResultSetReader;
import com.rapidminer.operator.nio.model.CSVResultSet;
import com.rapidminer.operator.nio.model.CSVResultSetConfiguration;
import com.rapidminer.operator.nio.model.ColumnMetaData;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.DataResultSetFactory;
import com.rapidminer.operator.nio.model.DataResultSetTranslationConfiguration;
import com.rapidminer.operator.nio.model.DataResultSetTranslator;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.StrictDecimalFormat;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

public class SerializedCSVExampleSource
extends CSVExampleSource {
    private DecimalFormat specialDecimalFormat;
    private List<String[]> metadata;
    private InputStream inputStream;

    public SerializedCSVExampleSource() {
        super(SerializedCSVExampleSource.getCSVExampleSourceDescription());
    }

    void setInputStream(final InputStream inputStream) {
        this.inputStream = new InputStream(){
            private int BUFF_SIZE = 1;
            private int position = 0;
            private int available = 0x7FFFFFF7;
            private InputStream underlyingStream = inputStream;
            private byte[] buff = null;

            @Override
            public int read() throws IOException {
                if (this.buff == null) {
                    this.buff = new byte[this.BUFF_SIZE];
                    for (int i = 0; i < this.BUFF_SIZE; ++i) {
                        int nextByte = this.underlyingStream.read();
                        if (nextByte == -1) {
                            this.available = i;
                            break;
                        }
                        this.buff[i] = (byte)nextByte;
                    }
                }
                if (this.position < this.BUFF_SIZE) {
                    if (this.position >= this.available) {
                        return -1;
                    }
                    byte nextByte = this.buff[this.position];
                    ++this.position;
                    return nextByte;
                }
                return this.underlyingStream.read();
            }

            @Override
            public void reset() throws IOException {
                if (this.position > this.BUFF_SIZE) {
                    throw new IOException("Reset operation not supported at this position (" + this.position + ").");
                }
                this.position = 0;
            }
        };
    }

    protected DataResultSetFactory getDataResultSetFactory() throws OperatorException {
        return new CSVResultSetConfiguration(this){

            public DataResultSet makeDataResultSet(Operator operator) throws OperatorException {
                return new CSVResultSet(this, operator){

                    protected InputStream openStream() throws UserError {
                        try {
                            SerializedCSVExampleSource.this.inputStream.reset();
                        }
                        catch (IOException e) {
                            throw new UserError(null, e.toString(), new Object[]{0});
                        }
                        return SerializedCSVExampleSource.this.inputStream;
                    }

                    public void reset(ProgressListener listener) throws OperatorException {
                    }
                };
            }
        };
    }

    private static OperatorDescription getCSVExampleSourceDescription() {
        OperatorDescription[] descriptions = OperatorService.getOperatorDescriptions(CSVExampleSource.class);
        return descriptions[0];
    }

    protected NumberFormat getNumberFormat() throws OperatorException {
        if (this.specialDecimalFormat == null) {
            return StrictDecimalFormat.getInstance((ParameterHandler)this, (boolean)true);
        }
        return this.specialDecimalFormat;
    }

    public void setNumberFormat(DecimalFormat decimalFormat) {
        this.specialDecimalFormat = decimalFormat;
    }

    protected ExampleSet transformDataResultSet(DataResultSet dataResultSet) throws OperatorException {
        ColumnMetaData[] columnMetaData;
        DataResultSetTranslationConfiguration configuration = new DataResultSetTranslationConfiguration((AbstractDataResultSetReader)this);
        DataResultSetTranslator translator = new DataResultSetTranslator((Operator)this);
        NumberFormat numberFormat = this.getNumberFormat();
        if (numberFormat != null) {
            configuration.setNumberFormat(numberFormat);
        }
        if ((columnMetaData = this.prepareMetaData(dataResultSet, this.metadata)) != null) {
            configuration.setColumnMetaData(columnMetaData);
        } else if (!configuration.isComplete()) {
            configuration.reconfigure(dataResultSet);
            translator.guessValueTypes(configuration, dataResultSet, null);
        }
        return translator.read(dataResultSet, configuration, false, null);
    }

    public void setMetadata(List<String[]> metadata) {
        this.metadata = metadata;
    }

    protected ColumnMetaData[] prepareMetaData(DataResultSet dataResultSet, List<String[]> metadata) {
        if (dataResultSet == null || metadata == null) {
            return null;
        }
        int numberOfColumns = dataResultSet.getNumberOfColumns();
        ColumnMetaData[] columnMetaData = new ColumnMetaData[numberOfColumns];
        String[] originalColumnNames = dataResultSet.getColumnNames();
        try {
            for (int i = 0; i < numberOfColumns; ++i) {
                String[] typeRolePair = metadata.get(i);
                String attributeRole = "attribute";
                int valueType = 7;
                if (typeRolePair != null) {
                    String valueTypeName = typeRolePair[0].trim();
                    valueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(valueTypeName);
                    if (valueType < 0) {
                        valueType = 7;
                    }
                    attributeRole = typeRolePair[1].trim();
                }
                columnMetaData[i] = new ColumnMetaData(originalColumnNames[i], originalColumnNames[i], valueType, attributeRole, true);
            }
            return columnMetaData;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}

