/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;

public interface Serializer {
    public void serialize(IOObject var1, OutputStream[] var2, @Nullable Operator var3) throws IOException, ProcessStoppedException, UserError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void serialize(IOObject resource, String filePathWithoutExtension, @Nullable Operator op) throws IOException, ProcessStoppedException, UserError {
        String[] extensions = this.getSerializedFileExtensions();
        OutputStream[] streams = new OutputStream[extensions.length];
        try {
            for (int i = 0; i < extensions.length; ++i) {
                streams[i] = new FileOutputStream(filePathWithoutExtension + "." + extensions[i]);
            }
            this.serialize(resource, streams, op);
        }
        finally {
            for (OutputStream stream : streams) {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String[] getSerializedFileExtensions();

    default public String getPrimarySerializedFileExtension() {
        String[] extensions = this.getSerializedFileExtensions();
        return extensions.length > 0 ? extensions[0] : "";
    }

    public boolean canHandle(IOObject var1);

    default public void checkIfCanHandle(IOObject resource) {
        if (!this.canHandle(resource)) {
            throw new IllegalArgumentException("Serializer " + this.getClass().getCanonicalName() + " cannot handle IOObject with type " + resource.getClass().getCanonicalName() + ".");
        }
    }

    default public void checkNumberOfStreams(OutputStream[] streams) {
        if (streams.length != this.getSerializedFileExtensions().length) {
            throw new IllegalArgumentException("Serializer " + this.getClass().getCanonicalName() + " expects " + this.getSerializedFileExtensions().length + " output streams.");
        }
    }

    default public int checkForStop(@Nullable Operator op, int counter) throws ProcessStoppedException {
        if (op != null && (counter = (counter + 1) % 10000) == 0) {
            op.checkForStop();
        }
        return counter;
    }
}

