/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.pythonscripting.serialization.arrow;

import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.column.ColumnType;
import com.rapidminer.belt.column.DateTimeColumn;
import com.rapidminer.belt.reader.NumericReader;
import com.rapidminer.belt.reader.ObjectReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.Table;
import com.rapidminer.belt.util.ColumnAnnotation;
import com.rapidminer.belt.util.ColumnMetaData;
import com.rapidminer.belt.util.ColumnReference;
import com.rapidminer.belt.util.ColumnRole;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.commons.lang3.StringUtils;

public class ColumnTypeMapper {
    public Field mapColumnType(Table table, int columnIndex, Map<Integer, Integer> maxValueLengthForColumns) {
        FieldType type;
        String columnName = table.label(columnIndex);
        ColumnType columnType = ((Column)table.select().columns().get(columnIndex)).type();
        HashMap<String, String> metadata = new HashMap<String, String>();
        this.addMetadata(table, columnName, ColumnRole.class, metadata, "role");
        this.addMetadata(table, columnName, ColumnAnnotation.class, metadata, "annotation");
        this.addMetadata(table, columnName, ColumnReference.class, metadata, "reference");
        metadata.put("rm_type", columnType.id().toString());
        int maxValueLength = this.maxValueLengthInAColumn(table, columnType, columnIndex);
        maxValueLengthForColumns.put(columnIndex, maxValueLength);
        switch (columnType.id()) {
            case REAL: {
                type = new FieldType(true, new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null, metadata);
                break;
            }
            case INTEGER_53_BIT: {
                if (this.containsAny(table, columnType, columnIndex, Arrays.asList(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY))) {
                    type = new FieldType(true, new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null, metadata);
                    break;
                }
                type = new FieldType(true, new ArrowType.Int(64, true), null, metadata);
                break;
            }
            case TEXT: {
                type = new FieldType(true, new ArrowType.Utf8(), null, metadata);
                break;
            }
            case NOMINAL: {
                type = this.mapNominalType(table, columnIndex, maxValueLength, metadata);
                break;
            }
            case TIME: {
                type = new FieldType(true, new ArrowType.Duration(TimeUnit.NANOSECOND), null, metadata);
                break;
            }
            case DATE_TIME: {
                type = this.mapDateTimeType(table, columnIndex, metadata);
                break;
            }
            case TEXT_LIST: 
            case TEXT_SET: {
                Field childField = new Field("text", new FieldType(true, new ArrowType.Utf8(), null, null), null);
                FieldType listType = new FieldType(false, new ArrowType.List(), null, metadata);
                return new Field(columnName, listType, Collections.singletonList(childField));
            }
            case REAL_ARRAY: {
                Field realChildField = new Field("real", new FieldType(true, new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null, null), null);
                FieldType realListType = new FieldType(false, new ArrowType.List(), null, metadata);
                return new Field(columnName, realListType, Collections.singletonList(realChildField));
            }
            default: {
                throw new IllegalArgumentException("Unsupported column type: " + columnType);
            }
        }
        return new Field(columnName, type, null);
    }

    private void addMetadata(Table table, String columnName, Class<? extends ColumnMetaData> metaClass, Map<String, String> metadata, String label) {
        Object metaDataObject;
        if (!table.getMetaData(columnName, metaClass).isEmpty() && (metaDataObject = table.getMetaData(columnName, metaClass).get(0)) != null) {
            String key = "rm_" + label;
            metadata.put(key, metaDataObject.toString());
        }
    }

    private FieldType mapNominalType(Table table, int index, int maxValueLength, Map<String, String> metadata) {
        int dictSize = ((Column)table.select().columns().get(index)).getDictionary().size();
        if (dictSize > Short.MAX_VALUE || maxValueLength > 512) {
            return new FieldType(true, new ArrowType.Utf8(), null, metadata);
        }
        ArrowType.Int intType = dictSize <= 127 ? new ArrowType.Int(8, true) : new ArrowType.Int(16, true);
        DictionaryEncoding dictionary = new DictionaryEncoding(index, false, intType);
        return new FieldType(true, intType, dictionary, metadata);
    }

    private FieldType mapDateTimeType(Table table, int index, Map<String, String> metadata) {
        DateTimeColumn dateTimeColumn = (DateTimeColumn)table.select().columns().get(index);
        if (!dateTimeColumn.hasSubSecondPrecision()) {
            return new FieldType(true, new ArrowType.Timestamp(TimeUnit.SECOND, "utc"), null, metadata);
        }
        return new FieldType(true, new ArrowType.Timestamp(TimeUnit.NANOSECOND, "utc"), null, metadata);
    }

    private int maxValueLengthInAColumn(Table table, ColumnType<?> columnType, int colIndex) {
        int maxValueLength = 0;
        if (columnType == ColumnType.NOMINAL || columnType == ColumnType.TEXT) {
            ObjectReader reader = Readers.objectReader((Column)((Column)table.select().columns().get(colIndex)), String.class);
            while (reader.hasRemaining()) {
                String value = (String)reader.read();
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                maxValueLength = Math.max(maxValueLength, value.length());
            }
        }
        return maxValueLength;
    }

    private boolean containsAny(Table table, ColumnType<?> columnType, int colIndex, List<Double> values) {
        if (columnType == ColumnType.REAL || columnType == ColumnType.INTEGER_53_BIT) {
            NumericReader reader = Readers.numericReader((Column)((Column)table.select().columns().get(colIndex)));
            while (reader.hasRemaining()) {
                double rawValue = reader.read();
                if (!values.contains(rawValue)) continue;
                return true;
            }
        }
        return false;
    }
}

